/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.ecommerce;

import android.support.annotation.NonNull;
import io.airbridge.ecommerce.Product;
import io.airbridge.internal.Param;
import io.airbridge.statistics.events.GoalEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SearchResultViewEvent
extends GoalEvent {
    private String query;
    private List<Product> products = new ArrayList<Product>();

    public SearchResultViewEvent(String query, @NonNull List<Product> products) {
        super("airbridge.ecommerce.searchResults.viewed");
        this.query = query;
        this.products.addAll(products);
    }

    public SearchResultViewEvent(String query, Product product) {
        this(query, Collections.singletonList(product));
    }

    public SearchResultViewEvent() {
        this(null, Collections.emptyList());
    }

    public SearchResultViewEvent addProduct(Product product) {
        this.products.add(product);
        return this;
    }

    public SearchResultViewEvent addProduct(List<Product> products) {
        if (this.products.size() <= 0) {
            this.products = products;
        } else {
            for (Product product : products) {
                this.products.add(product);
            }
        }
        return this;
    }

    public SearchResultViewEvent setQuery(String query) {
        this.query = query;
        return this;
    }

    @Override
    protected Param getSemanticAttributes() {
        return new Param().maybePut("query", this.query).put("products", this.products);
    }
}

