/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.ecommerce;

import android.support.annotation.NonNull;
import io.airbridge.ecommerce.Product;
import io.airbridge.internal.Param;
import io.airbridge.statistics.events.GoalEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PurchaseEvent
extends GoalEvent {
    private boolean inAppPurchased;
    private String transactionId;
    private List<Product> products = new ArrayList<Product>();

    public PurchaseEvent(@NonNull List<Product> products) {
        super("airbridge.ecommerce.order.completed");
        this.products.addAll(products);
    }

    public PurchaseEvent(Product product) {
        this(Collections.singletonList(product));
    }

    public PurchaseEvent() {
        this(Collections.emptyList());
    }

    public PurchaseEvent addProduct(Product product) {
        this.products.add(product);
        return this;
    }

    public PurchaseEvent addProduct(List<Product> products) {
        this.products.addAll(products);
        return this;
    }

    public PurchaseEvent setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public PurchaseEvent setInAppPurchased(boolean inAppPurchased) {
        this.inAppPurchased = inAppPurchased;
        return this;
    }

    public PurchaseEvent setTotalValue(int value) {
        super.setValue(value);
        return this;
    }

    public PurchaseEvent setCurrency(String currency) {
        super.setCustomAttribute("currency", currency);
        return this;
    }

    @Override
    protected Param getSemanticAttributes() {
        return new Param().maybePut("transactionID", this.transactionId).put("inAppPurchased", this.inAppPurchased).put("products", this.products);
    }
}

