/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.ecommerce;

import android.support.annotation.NonNull;
import io.airbridge.ecommerce.Product;
import io.airbridge.internal.Param;
import io.airbridge.statistics.events.GoalEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProductListViewEvent
extends GoalEvent {
    private String listId;
    private List<Product> products = new ArrayList<Product>();

    public ProductListViewEvent(String listId, @NonNull List<Product> products) {
        super("airbridge.ecommerce.productList.viewed");
        this.listId = listId;
        this.products.addAll(products);
    }

    public ProductListViewEvent(String listId, Product product) {
        this(listId, Collections.singletonList(product));
    }

    public ProductListViewEvent() {
        this(null, Collections.emptyList());
    }

    public ProductListViewEvent addProduct(Product product) {
        this.products.add(product);
        return this;
    }

    public ProductListViewEvent addProduct(List<Product> products) {
        if (this.products.size() <= 0) {
            this.products = products;
        } else {
            for (Product product : products) {
                this.products.add(product);
            }
        }
        return this;
    }

    public ProductListViewEvent setListId(String listId) {
        this.listId = listId;
        return this;
    }

    @Override
    protected Param getSemanticAttributes() {
        return new Param().maybePut("productListID", this.listId).put("products", this.products);
    }
}

