/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.ecommerce;

import android.support.annotation.NonNull;
import io.airbridge.ecommerce.Product;
import io.airbridge.internal.Param;
import io.airbridge.statistics.events.GoalEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AddedToCartEvent
extends GoalEvent {
    private String cartId;
    private List<Product> products = new ArrayList<Product>();

    public AddedToCartEvent(String cartId, @NonNull List<Product> products) {
        super("airbridge.ecommerce.product.addedToCart");
        this.cartId = cartId;
        this.products.addAll(products);
    }

    public AddedToCartEvent(String cartId, Product product) {
        this(cartId, Collections.singletonList(product));
    }

    public AddedToCartEvent() {
        this(null, Collections.emptyList());
    }

    public AddedToCartEvent addProduct(Product product) {
        this.products.add(product);
        return this;
    }

    public AddedToCartEvent addProduct(List<Product> products) {
        if (this.products.size() <= 0) {
            this.products = products;
        } else {
            for (Product product : products) {
                this.products.add(product);
            }
        }
        return this;
    }

    public AddedToCartEvent setCartId(String cartId) {
        this.cartId = cartId;
        return this;
    }

    public AddedToCartEvent setTotalValue(int value) {
        super.setValue(value);
        return this;
    }

    public AddedToCartEvent setCurrency(String currency) {
        super.setCustomAttribute("currency", currency);
        return this;
    }

    @Override
    protected Param getSemanticAttributes() {
        return new Param().maybePut("cartID", this.cartId).put("products", this.products);
    }
}

