/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.deviceinfo;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.LocationManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import io.airbridge.deviceinfo.WifiCallback;
import io.airbridge.internal.Param;
import io.airbridge.internal.StateOwner;
import io.airbridge.internal.log.Logger;
import java.util.List;

public class WifiListProvider
extends StateOwner<State> {
    private static WifiListProvider instance;
    private Context context;
    private WifiManager wifiManager;
    private WifiCallback scanCompleteCallback;
    private boolean wifiStateChanger;
    private int retryCounter;
    Param param;
    @SuppressLint(value={"MissingPermission"})
    private BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action != null && action.equals("android.net.wifi.SCAN_RESULTS")) {
                List scanResultList = WifiListProvider.this.wifiManager.getScanResults();
                WifiListProvider.this.retryCounter++;
                if (scanResultList.size() > 0 || WifiListProvider.this.retryCounter > 3) {
                    Logger.d("wifi Retry Counter : " + String.valueOf(WifiListProvider.this.retryCounter), new Object[0]);
                    WifiListProvider.this.stopScan();
                    WifiListProvider.this.scanCompleteCallback.scanComplete(scanResultList);
                }
            } else if (action != null && action.equals("android.net.wifi.STATE_CHANGE")) {
                context.sendBroadcast(new Intent("wifi.ON_NETWORK_STATE_CHANGED"));
            }
        }
    };

    private WifiListProvider(Context context) {
        this.context = context;
        this.param = new Param();
        this.retryCounter = 0;
        this.initWifiScanner();
    }

    private void initWifiScanner() {
        this.wifiManager = (WifiManager)this.context.getSystemService("wifi");
        this.wifiStateChanger = false;
    }

    public static synchronized WifiListProvider getInstance(Context context) {
        if (instance == null) {
            instance = new WifiListProvider(context);
        }
        return instance;
    }

    public void setResponseCallback(WifiCallback wifiCallback) {
        this.scanCompleteCallback = wifiCallback;
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean getWifiList() {
        if (this.isWifiScanable()) {
            IntentFilter filter = new IntentFilter("android.net.wifi.SCAN_RESULTS");
            filter.addAction("android.net.wifi.STATE_CHANGE");
            this.context.registerReceiver(this.receiver, filter);
            this.wifiManager.startScan();
            return true;
        }
        return false;
    }

    private boolean isWifiScanable() {
        if (!this.hasPermission("android.permission.ACCESS_WIFI_STATE")) {
            Logger.d("ACESS_WIFI_STATE Deny", new Object[0]);
            return false;
        }
        if (!this.hasPermission("android.permission.CHANGE_WIFI_STATE")) {
            Logger.d("CHANGE_WIFI_STATE Deny", new Object[0]);
            return false;
        }
        if (!this.isWifiScanEnable()) {
            if (!this.hasPermission("android.permission.CHANGE_WIFI_STATE")) {
                return false;
            }
            this.makeWifiEnable();
        }
        if (Build.VERSION.SDK_INT > 22) {
            if (!this.hasPermission("android.permission.ACCESS_FINE_LOCATION") && !this.hasPermission("android.permission.ACCESS_COARSE_LOCATION")) {
                return false;
            }
            if (!this.isGpsEnable()) {
                return false;
            }
        }
        return true;
    }

    @SuppressLint(value={"MissingPermission"})
    private boolean isWifiScanEnable() {
        if (this.wifiManager.getWifiState() != 3 && this.wifiManager.getWifiState() != 2) {
            if (Build.VERSION.SDK_INT >= 18) {
                Logger.d("is Wifi enable : " + String.valueOf(this.wifiManager.isScanAlwaysAvailable()), new Object[0]);
                if (!this.wifiManager.isScanAlwaysAvailable()) {
                    Logger.d("wifi not available", new Object[0]);
                    return false;
                }
            } else {
                Logger.d("wifi not available", new Object[0]);
                return false;
            }
        }
        return true;
    }

    private boolean isGpsEnable() {
        LocationManager manager = (LocationManager)this.context.getSystemService("location");
        if (manager != null && !manager.isProviderEnabled("gps")) {
            Logger.d("gps disable", new Object[0]);
            return false;
        }
        return true;
    }

    @SuppressLint(value={"MissingPermission"})
    private void makeWifiEnable() {
        this.wifiStateChanger = true;
        this.wifiManager.setWifiEnabled(true);
        Logger.d("make Wifi Enable", new Object[0]);
    }

    private boolean hasPermission(String permission2) {
        return Build.VERSION.SDK_INT >= 23 && this.context.checkSelfPermission(permission2) == 0 || this.context.getPackageManager().checkPermission(permission2, this.context.getPackageName()) == 0;
    }

    @SuppressLint(value={"MissingPermission"})
    private void stopScan() {
        Logger.d("stop Scan", new Object[0]);
        if (this.wifiStateChanger) {
            this.wifiManager.setWifiEnabled(false);
        }
        this.context.unregisterReceiver(this.receiver);
        this.retryCounter = 0;
    }

    public static enum State {
        EMPTY,
        SET;

    }
}

