/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.deviceinfo;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.provider.Settings;
import android.support.annotation.WorkerThread;
import android.telephony.TelephonyManager;
import io.airbridge.deviceinfo.AdvertisingIdInfo;
import io.airbridge.deviceinfo.AdvertisingIdServiceConnection;
import io.airbridge.deviceinfo.AdvertisingIdServiceProxy;
import io.airbridge.internal.log.Logger;
import java.lang.reflect.Method;
import java.util.UUID;

class UuidProvider {
    private static int PRIORITY_GAID_FROM_GMS = 3;
    private static int PRIORITY_GAID_DIRECT = 2;
    private static int PRIORITY_UUID_TELEPHONY = 1;
    private static int PRIORITY_UUID_RANDOM = 1;
    private static final String PREF_UNIQUE_ID = "PREF_UNIQUE_ID";
    private static final String KEY_UUID = "uuid";
    private static final String KEY_GAID = "gaid";
    private static final String KEY_LAT = "isLAT";
    private static final String KEY_PRIORITY = "priority";
    public String uuid;
    public AdvertisingIdInfo adIdInfo;
    int savedPriority;

    public UuidProvider(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREF_UNIQUE_ID, 0);
        this.uuid = prefs.getString(KEY_UUID, null);
        this.savedPriority = prefs.getInt(KEY_PRIORITY, PRIORITY_UUID_RANDOM);
        if (prefs.contains(KEY_GAID)) {
            String gaid = prefs.getString(KEY_GAID, null);
            boolean isLAT = prefs.getBoolean(KEY_LAT, false);
            this.adIdInfo = new AdvertisingIdInfo(gaid, isLAT);
        }
        Logger.d("UUID Loaded : uuid=%s, gaid=%s", this.uuid, this.adIdInfo != null ? this.adIdInfo.id : "null");
    }

    @WorkerThread
    public void update(Context context) {
        int priority;
        String uuid;
        AdvertisingIdInfo adIdInfo = this.fetchAdIdUsingPlayServicesSDK(context);
        if (adIdInfo != null) {
            this.updateIfNeeded(context, PRIORITY_GAID_FROM_GMS, adIdInfo);
            return;
        }
        Logger.i("Try to fetch GAID from Play Services directly..", new Object[0]);
        adIdInfo = this.fetchAdIdDirectly(context);
        if (adIdInfo != null) {
            this.updateIfNeeded(context, PRIORITY_GAID_DIRECT, adIdInfo);
            return;
        }
        try {
            Logger.i("Trying Telephony UUID instead...", new Object[0]);
            uuid = this.generateTelephonyUuid(context);
            priority = PRIORITY_UUID_TELEPHONY;
        }
        catch (Exception ex) {
            Logger.i("Trying Random UUID instead...", new Object[0]);
            uuid = this.generateRandomUuid();
            priority = PRIORITY_UUID_RANDOM;
        }
        this.updateIfNeeded(context, priority, uuid);
    }

    void updateIfNeeded(Context context, int priority, AdvertisingIdInfo adIdInfo) {
        if (this.savedPriority > priority) {
            return;
        }
        this.uuid = adIdInfo.getId();
        this.adIdInfo = adIdInfo;
        this.savedPriority = priority;
        Logger.i("Updating GAID.", new Object[0]);
        this.save(context);
    }

    void updateIfNeeded(Context context, int priority, String uuid) {
        if (this.savedPriority > priority) {
            return;
        }
        this.uuid = uuid;
        this.savedPriority = priority;
        Logger.i("Updating UUID.", new Object[0]);
        this.save(context);
    }

    private void save(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREF_UNIQUE_ID, 0);
        prefs.edit().putString(KEY_UUID, this.uuid).putString(KEY_GAID, this.adIdInfo != null ? this.adIdInfo.id : null).putBoolean(KEY_LAT, this.adIdInfo != null && this.adIdInfo.isLAT).putInt(KEY_PRIORITY, this.savedPriority).apply();
    }

    private AdvertisingIdInfo fetchAdIdUsingPlayServicesSDK(Context context) {
        try {
            Class<?> adidClass = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
            Method getAdvertisingIdInfoMethod = adidClass.getMethod("getAdvertisingIdInfo", Context.class);
            Object adidInfoObject = getAdvertisingIdInfoMethod.invoke(null, context);
            Method isLimitAdTrackingEnabledMethod = adidInfoObject.getClass().getMethod("isLimitAdTrackingEnabled", new Class[0]);
            Method getAdIdMethod = adidInfoObject.getClass().getMethod("getId", new Class[0]);
            String gaid = getAdIdMethod.invoke(adidInfoObject, new Object[0]).toString();
            boolean isLAT = (Boolean)isLimitAdTrackingEnabledMethod.invoke(adidInfoObject, new Object[0]) == false;
            return new AdvertisingIdInfo(gaid, isLAT);
        }
        catch (ClassNotFoundException | NoClassDefFoundError | NoSuchMethodError | NullPointerException ignored) {
            Logger.w("Google Play Services SDK not found. We recommend to add Google Play Service to your project.");
        }
        catch (Throwable e) {
            Logger.e("Error occurred while fetching GAID using GMS.", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdvertisingIdInfo fetchAdIdDirectly(Context context) {
        try {
            context.getPackageManager().getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException error) {
            Logger.w("Google Play is not installed.");
            return null;
        }
        AdvertisingIdServiceConnection connection = new AdvertisingIdServiceConnection();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START").setPackage("com.google.android.gms");
        boolean connected = context.bindService(intent, (ServiceConnection)connection, 1);
        if (!connected) {
            Logger.e("Failed to connect to Google Play Services.");
            return null;
        }
        try {
            IBinder service = connection.waitForServiceConnected();
            AdvertisingIdServiceProxy proxy = new AdvertisingIdServiceProxy(service);
            AdvertisingIdInfo advertisingIdInfo = new AdvertisingIdInfo(proxy.getId(), proxy.isLATEnabled(true));
            return advertisingIdInfo;
        }
        catch (Throwable e) {
            Logger.e("Error occurred while fetching GAID", e);
            AdvertisingIdInfo advertisingIdInfo = null;
            return advertisingIdInfo;
        }
        finally {
            context.unbindService((ServiceConnection)connection);
        }
    }

    @SuppressLint(value={"HardwareIds"})
    private String generateTelephonyUuid(Context context) throws Exception {
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        String tmDevice = tm.getDeviceId();
        String tmSerial = tm.getSimSerialNumber();
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        UUID deviceUuid = new UUID(String.valueOf(androidId).hashCode(), (long)String.valueOf(tmDevice).hashCode() << 32 | (long)String.valueOf(tmSerial).hashCode());
        return deviceUuid.toString();
    }

    private String generateRandomUuid() {
        return UUID.randomUUID().toString();
    }
}

