/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.deviceinfo;

import android.content.Context;
import io.airbridge.Config;
import io.airbridge.internal.StateOwner;
import io.airbridge.internal.log.Logger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class InstallReferrerProvider
extends StateOwner<State> {
    Context context;
    private static InstallReferrerProvider instance;

    public static InstallReferrerProvider getInstance(Context context) {
        if (instance == null) {
            instance = new InstallReferrerProvider(context);
        }
        return instance;
    }

    private InstallReferrerProvider(Context context) {
        this.context = context;
        this.setState(State.VACANT);
    }

    public void getInstalledReferrer() {
        try {
            Class<?> installReferrer = Class.forName("com.android.installreferrer.api.InstallReferrerClient");
            Object builderobject = installReferrer.getMethod("newBuilder", Context.class).invoke(null, this.context);
            final Object installReferObject = builderobject.getClass().getMethod("build", new Class[0]).invoke(builderobject, new Object[0]);
            InvocationHandler invocationHandler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals("onInstallReferrerSetupFinished")) {
                        try {
                            Class<?> referrerDetails = Class.forName("com.android.installreferrer.api.ReferrerDetails");
                            Method getInstallReferrer = installReferObject.getClass().getMethod("getInstallReferrer", new Class[0]);
                            Object ReferrerDetails = getInstallReferrer.invoke(installReferObject, new Object[0]);
                            Method getReferrerClickTimestampSeconds = referrerDetails.getMethod("getReferrerClickTimestampSeconds", new Class[0]);
                            Method getInstallBeginTimestampSeconds = referrerDetails.getMethod("getInstallBeginTimestampSeconds", new Class[0]);
                            Config.getInstance().put("ReferrerClickTimestampSeconds", getReferrerClickTimestampSeconds.invoke(ReferrerDetails, new Object[0]));
                            Config.getInstance().put("InstallBeginTimestampSeconds", getInstallBeginTimestampSeconds.invoke(ReferrerDetails, new Object[0]));
                            Config.getInstance().save();
                            InstallReferrerProvider.this.setFetched();
                        }
                        catch (Exception e) {
                            Logger.w("ReferrerDetails Remote Exception : " + e.toString());
                            InstallReferrerProvider.this.setFetched();
                        }
                    } else if (method.getName().equals("onInstallReferrerServiceDisconnected")) {
                        Logger.w("onInstallReferrerServiceDisonnected");
                        InstallReferrerProvider.this.setFetched();
                    }
                    return null;
                }
            };
            ClassLoader classLoader = Class.forName("com.android.installreferrer.api.InstallReferrerStateListener").getClassLoader();
            Class[] interfaces = new Class[]{Class.forName("com.android.installreferrer.api.InstallReferrerStateListener")};
            Object listenerInterface = Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
            Class<?> listernerClass = Class.forName("com.android.installreferrer.api.InstallReferrerStateListener");
            Method startConnection = installReferrer.getMethod("startConnection", listernerClass);
            startConnection.invoke(installReferObject, listenerInterface);
        }
        catch (ClassNotFoundException e) {
            Logger.w("ClassNotFoundException : " + e.toString());
            this.setFetched();
        }
        catch (NoSuchMethodException e) {
            Logger.w("NoSuchMethodException : " + e.toString());
            this.setFetched();
        }
        catch (IllegalAccessException e) {
            Logger.w("IllegalAccessException : " + e.toString());
            this.setFetched();
        }
        catch (InvocationTargetException e) {
            Logger.w("InvocationTargetException : " + e.toString());
            this.setFetched();
        }
    }

    public void setFetched() {
        this.setState(State.TAKEN);
    }

    public static enum State {
        VACANT,
        TAKEN;

    }
}

