/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.deviceinfo;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.database.Cursor;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import io.airbridge.deviceinfo.UuidProvider;
import io.airbridge.internal.Param;
import io.airbridge.internal.StateOwner;
import io.airbridge.internal.log.Logger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.TimeZone;

public class DeviceInfo
extends StateOwner<State> {
    public static final String ATTRIBUTION_ID_COLUMN_NAME = "aid";
    private static final Uri ATTRIBUTION_ID_CONTENT_URI = Uri.parse((String)"content://com.facebook.katana.provider.AttributionIdProvider");
    private static DeviceInfo instance;
    private Context context;
    @Nullable
    String facebookAttributionId;
    private UuidProvider uuidProvider;
    public String packageName;
    public String appVersion;
    public String appVersionCode;
    public int screenWidth;
    public int screenHeight;
    public int screenDensity;
    public String locale;
    public String timezone;
    public boolean systemAutoTime;
    public String deviceType;

    public DeviceInfo() {
        this.setState(State.NONE);
    }

    public static DeviceInfo getInstance() {
        return instance != null ? instance : (instance = new DeviceInfo());
    }

    @WorkerThread
    public void fetch(Context context) {
        this.context = context.getApplicationContext();
        this.fetchFacebookAttributionId(context);
        this.fetchAutoTimeConfig(context);
        this.fetchScreenSize(context);
        this.uuidProvider = new UuidProvider(context);
        this.uuidProvider.update(context);
        this.locale = Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
        this.timezone = TimeZone.getDefault().getID();
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            this.appVersion = info.versionName;
            this.appVersionCode = String.valueOf(info.versionCode);
            this.packageName = info.packageName;
        }
        catch (Exception e) {
            this.appVersion = "(N/A)";
            this.appVersionCode = "(N/A)";
            this.packageName = context.getPackageName();
        }
        this.setState(State.FETCHED);
    }

    void fetchFacebookAttributionId(Context context) {
        try {
            String[] projection = new String[]{ATTRIBUTION_ID_COLUMN_NAME};
            ContentResolver contentResolver = context.getContentResolver();
            Cursor c = contentResolver.query(ATTRIBUTION_ID_CONTENT_URI, projection, null, null, null);
            if (c == null || !c.moveToFirst()) {
                return;
            }
            this.facebookAttributionId = c.getString(c.getColumnIndex(ATTRIBUTION_ID_COLUMN_NAME));
            if (this.facebookAttributionId == null) {
                this.facebookAttributionId = "";
            }
            c.close();
        }
        catch (Throwable e) {
            Logger.d("Unable to retrieve Facebook Attribution ID.", new Object[0]);
        }
    }

    void fetchScreenSize(Context context) {
        WindowManager w = (WindowManager)context.getSystemService("window");
        Display d = w.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        d.getMetrics(metrics);
        this.screenDensity = metrics.densityDpi;
        if (Build.VERSION.SDK_INT >= 17) {
            Point realSize = new Point();
            d.getRealSize(realSize);
            this.screenWidth = realSize.x;
            this.screenHeight = realSize.y;
            this.deviceType = this.getDevideType(metrics, this.screenWidth, this.screenHeight);
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            try {
                this.screenWidth = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)d, new Object[0]);
                this.screenHeight = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)d, new Object[0]);
                this.deviceType = this.getDevideType(metrics, this.screenWidth, this.screenHeight);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.screenWidth = metrics.widthPixels;
        this.screenHeight = metrics.heightPixels;
        this.deviceType = this.getDevideType(metrics, this.screenWidth, this.screenHeight);
    }

    private void fetchAutoTimeConfig(Context context) {
        String key = Build.VERSION.SDK_INT < 17 ? "auto_time" : "auto_time";
        try {
            this.systemAutoTime = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)key) == 1;
        }
        catch (Settings.SettingNotFoundException e) {
            this.systemAutoTime = false;
        }
    }

    public Param serialize() {
        Param deviceData = new Param().put("deviceModel", Build.MODEL).put("manufacturer", Build.MANUFACTURER).put("osName", "Android").put("osVersion", Build.VERSION.RELEASE).put("locale", this.locale).put("timezone", this.timezone).put("orientation", this.getOrientation()).put("deviceIP", this.getIPAddress()).put("deviceUUID", this.getUUID()).put("gaid", this.getGAID()).put("limitAdTracking", !this.getLimitedAdTracking()).put("facebookAttributionID", this.facebookAttributionId).put("systemAutoTime", this.systemAutoTime);
        Param screenData = new Param().put("width", this.screenWidth).put("height", this.screenHeight).put("density", this.screenDensity);
        deviceData.put("screen", screenData);
        deviceData.put("network", this.getNetworkInfo());
        deviceData.maybePut("deviceType", this.deviceType);
        return deviceData;
    }

    public String getUUID() {
        if (this.uuidProvider == null) {
            return null;
        }
        return this.uuidProvider.uuid;
    }

    public String getGAID() {
        if (this.uuidProvider == null) {
            return null;
        }
        return this.uuidProvider.adIdInfo != null ? this.uuidProvider.adIdInfo.id : null;
    }

    public boolean getLimitedAdTracking() {
        if (this.uuidProvider == null) {
            return false;
        }
        return this.uuidProvider.adIdInfo != null && this.uuidProvider.adIdInfo.isLAT;
    }

    private String getOrientation() {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        return displayMetrics.widthPixels > displayMetrics.heightPixels ? "landscape" : "portrait";
    }

    public String getIPAddress() {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    String sAddr;
                    boolean isIPv4;
                    if (addr.isLoopbackAddress() || !(isIPv4 = (sAddr = addr.getHostAddress()).indexOf(58) < 0)) continue;
                    return sAddr;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @SuppressLint(value={"MissingPermission"})
    public Param getNetworkInfo() {
        ConnectivityManager connectivityManager;
        try {
            connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        }
        catch (Exception e) {
            return new Param();
        }
        boolean wifiOn = false;
        boolean bluetoothOn = false;
        boolean cellularOn = false;
        String carrier = null;
        try {
            NetworkInfo activeInfo = connectivityManager.getActiveNetworkInfo();
            if (activeInfo != null) {
                if (activeInfo.getType() == 1) {
                    wifiOn = true;
                } else if (activeInfo.getType() == 7) {
                    bluetoothOn = true;
                } else {
                    cellularOn = true;
                }
            }
            if (!bluetoothOn && this.hasPermission("android.permission.BLUETOOTH")) {
                BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                bluetoothOn = bluetoothAdapter.isEnabled();
            }
            if (this.hasPermission("android.permission.READ_PHONE_STATE")) {
                TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
                carrier = telephonyManager.getNetworkOperatorName();
            }
        }
        catch (Exception e) {
            Logger.e("Failed to fetch network info", e);
        }
        return new Param().put("wifi", wifiOn).put("bluetooth", bluetoothOn).put("cellular", cellularOn).put("carrier", carrier);
    }

    private boolean hasPermission(String permission2) {
        return Build.VERSION.SDK_INT >= 23 && this.context.checkSelfPermission(permission2) == 0 || this.context.getPackageManager().checkPermission(permission2, this.context.getPackageName()) == 0;
    }

    private String getDevideType(DisplayMetrics metrics, int screenWidth, int screenHeight) {
        double y;
        double wi = (double)screenWidth / (double)metrics.xdpi;
        double hi = (double)screenHeight / (double)metrics.ydpi;
        double x = Math.pow(wi, 2.0);
        double screenInches = Math.sqrt(x + (y = Math.pow(hi, 2.0)));
        if (screenInches > 7.0) {
            return "tablet";
        }
        if (screenInches > 2.0) {
            return "mobile";
        }
        return "wearable";
    }

    public static enum State {
        NONE,
        FETCHED;

    }
}

