/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.deeplink;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import io.airbridge.deeplink.DeepLink;
import io.airbridge.internal.log.Logger;
import java.util.ArrayList;
import java.util.List;

public class Router {
    List<Layer> layerStack = new ArrayList<Layer>();
    List<DeepLink.Filter> filters = new ArrayList<DeepLink.Filter>();
    List<DeepLink.Handler> handlers = new ArrayList<DeepLink.Handler>();
    Object defaultHandler;

    Router() {
    }

    public void addRoute(String url, Object handler) {
        this.layerStack.add(new Layer(url, handler));
    }

    public void filter(DeepLink.Filter filter) {
        this.filters.add(filter);
    }

    public void addHandler(DeepLink.Handler handler) {
        this.handlers.add(handler);
    }

    public void setDefaultHandler(Object defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    Object findMatches(DeepLink link) {
        for (Layer layer : this.layerStack) {
            Object handler = layer.match(link);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    public boolean callHandlers(DeepLink link, Context context) {
        boolean matched = true;
        for (DeepLink.Filter filter : this.filters) {
            if (!filter.filter(context, link)) continue;
            return false;
        }
        for (DeepLink.Handler handler : this.handlers) {
            handler.onLink(context, link);
        }
        Object handler = this.findMatches(link);
        if (handler == null) {
            Logger.i("No match route found with URL : " + link.getUri(), new Object[0]);
            if (this.defaultHandler != null) {
                handler = this.defaultHandler;
            }
            matched = false;
        }
        if (handler instanceof Class) {
            Intent intent = new Intent(context, (Class)handler);
            intent.setAction("android.intent.action.VIEW");
            intent.addCategory("android.intent.category.BROWSABLE");
            intent.putExtras(link.toBundle());
            intent.putExtra("airbridge", true);
            intent.setData(link.getUri());
            if (!(context instanceof Activity)) {
                intent.setFlags(0x10000000);
            }
            context.startActivity(intent);
        } else if (handler instanceof DeepLink.Handler) {
            ((DeepLink.Handler)handler).onLink(context, link);
        }
        return matched;
    }

    static class Layer {
        public List<String> pathSegments;
        public Object handler;

        public Layer(String path, Object handler) {
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            this.pathSegments = Uri.parse((String)path.toLowerCase()).getPathSegments();
            this.handler = handler;
        }

        public Object match(DeepLink link) {
            List splitUrl = link.getUri().getPathSegments();
            if (splitUrl.size() != this.pathSegments.size()) {
                return null;
            }
            Bundle pathParams = new Bundle();
            int i = 0;
            for (String pathSegment : this.pathSegments) {
                String givenPath = ((String)splitUrl.get(i++)).toLowerCase();
                if (pathSegment.startsWith("{{") && pathSegment.endsWith("}}")) {
                    String paramKey = pathSegment.substring(2, pathSegment.length() - 2);
                    pathParams.putString(paramKey, givenPath);
                    continue;
                }
                if (pathSegment.equals("*")) break;
                if (pathSegment.equals(givenPath)) continue;
                return null;
            }
            link.toBundle().putAll(pathParams);
            return this.handler;
        }
    }
}

