/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.deeplink;

import android.net.Uri;
import android.os.Bundle;

class Link {
    private Uri uri;
    protected Bundle bundle;

    protected Link(String uriString) {
        this.uri = Uri.parse((String)uriString);
        this.bundle = this.getQueryParameters(this.uri);
    }

    private Bundle getQueryParameters(Uri uri) {
        int end;
        Bundle params = new Bundle();
        String query = uri.getEncodedQuery();
        if (query == null) {
            return params;
        }
        int start = 0;
        do {
            int next;
            end = (next = query.indexOf(38, start)) == -1 ? query.length() : next;
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            String rawName = query.substring(start, separator);
            String name = Uri.decode((String)rawName);
            params.putString(name, uri.getQueryParameter(name));
        } while ((start = end + 1) < query.length());
        return params;
    }

    public Object get(String key) {
        return this.bundle.get(key);
    }

    public int getInt(String key, int defaultValue) {
        try {
            Object value = this.get(key);
            if (value == null) {
                return defaultValue;
            }
            return value instanceof String ? Integer.valueOf((String)value).intValue() : ((Integer)value).intValue();
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            Object value = this.get(key);
            if (value == null) {
                return defaultValue;
            }
            return value instanceof String ? Boolean.valueOf((String)value).booleanValue() : ((Boolean)value).booleanValue();
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        try {
            Object value = this.get(key);
            if (value == null) {
                return defaultValue;
            }
            return (String)this.get(key);
        }
        catch (Throwable e) {
            return defaultValue;
        }
    }

    public boolean has(String key) {
        return this.bundle.containsKey(key);
    }

    public Uri getUri() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toString();
    }

    public Bundle toBundle() {
        return this.bundle;
    }
}

