/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.deeplink;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.net.Uri;
import android.support.annotation.Nullable;
import io.airbridge.DeepLinkActivity;
import io.airbridge.deeplink.AnnotationScanner;
import io.airbridge.deeplink.Link;
import io.airbridge.deeplink.Router;
import io.airbridge.internal.log.Logger;
import io.airbridge.statistics.events.DeepLinkLaunchEvent;

public class DeepLink
extends Link {
    @Nullable
    static Router router;

    public static void init(Context context) {
        if (DeepLink.hasRouterActivityRegistered(context)) {
            Logger.i("Using Airbridge DeepLink Router.", new Object[0]);
            router = new Router();
            AnnotationScanner.scanAndRegister(context, router);
        }
    }

    private static boolean hasRouterActivityRegistered(Context context) {
        String routerActivityName = DeepLinkActivity.class.getName();
        try {
            ActivityInfo[] activities;
            for (ActivityInfo activity : activities = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)1).activities) {
                if (!activity.name.equals(routerActivityName)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Router getRouter() {
        return router;
    }

    public static Intent createIntent(String deepLinkUri) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.BROWSABLE");
        intent.setData(Uri.parse((String)deepLinkUri));
        return intent;
    }

    public static boolean hadOpened(Activity activity) {
        return activity.getIntent() != null && "android.intent.action.VIEW".equals(activity.getIntent().getAction()) && activity.getIntent().getDataString() != null;
    }

    public static boolean isFromAirbridge(String uri) {
        return uri.contains("airbridge_referrer=") || uri.contains("airbridge=") || uri.contains("udl=");
    }

    public static boolean isFromAirbridge(Intent intent) {
        return intent != null && "android.intent.action.VIEW".equals(intent.getAction()) && intent.getDataString() != null && DeepLink.isFromAirbridge(intent.getDataString());
    }

    public static void trackAirbridgeLinkOnly() {
        DeepLinkLaunchEvent.trackAirbridgeLinkOnly = true;
    }

    public static DeepLink fromActivity(Activity activity) {
        if (!DeepLink.hadOpened(activity)) {
            return null;
        }
        return new DeepLink(activity.getIntent().getData().toString());
    }

    public DeepLink(String uriString) {
        super(uriString);
    }

    public static interface Filter {
        public boolean filter(Context var1, DeepLink var2);
    }

    public static interface Handler {
        public void onLink(Context var1, DeepLink var2);
    }
}

