/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge.deeplink;

import android.content.Context;
import android.content.pm.ActivityInfo;
import io.airbridge.deeplink.DeepLinkDefaultRoute;
import io.airbridge.deeplink.DeepLinkRoute;
import io.airbridge.deeplink.Router;
import io.airbridge.internal.log.Logger;

class AnnotationScanner {
    AnnotationScanner() {
    }

    public static void scanAndRegister(Context context, Router router) {
        try {
            ActivityInfo[] infos;
            for (ActivityInfo info : infos = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)1).activities) {
                DeepLinkDefaultRoute defaultRoute;
                Class<?> activityClass = Class.forName(info.name, false, context.getClassLoader());
                DeepLinkRoute annotation = activityClass.getAnnotation(DeepLinkRoute.class);
                if (annotation != null) {
                    for (String route : annotation.value()) {
                        router.addRoute(route, activityClass);
                        Logger.v("Found @DeepLink activity : %s => %s", route, activityClass.getSimpleName());
                    }
                }
                if ((defaultRoute = activityClass.getAnnotation(DeepLinkDefaultRoute.class)) == null) continue;
                router.setDefaultHandler(activityClass);
            }
        }
        catch (Exception e) {
            Logger.w("Failed to addRoute an activity.", e);
        }
    }
}

