/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import io.airbridge.internal.log.Logger;
import io.airbridge.statistics.Installer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLDecoder;

public class DeferredLinkReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        try {
            String referrer = intent.getExtras().getString("referrer");
            if (referrer == null) {
                Logger.d("Got a install referrer but no referrer.", new Object[0]);
                return;
            }
            referrer = URLDecoder.decode(referrer, "UTF-8");
            Logger.i("Install Referrer : " + referrer, new Object[0]);
            Installer.referrerFuture.complete(referrer);
        }
        catch (Throwable e) {
            Logger.e("Failed to parse referral URL from Play Store.", e);
        }
        this.call3rdPartyReceiver(context, intent);
    }

    void call3rdPartyReceiver(Context context, Intent intent) {
        try {
            PackageManager pm = context.getPackageManager();
            ComponentName name = new ComponentName(context, DeferredLinkReceiver.class);
            ActivityInfo info = pm.getReceiverInfo(name, 128);
            Bundle metaData = info.metaData;
            if (metaData == null) {
                return;
            }
            for (String key : metaData.keySet()) {
                try {
                    String value = metaData.getString(key);
                    Class<?> receiverClass = Class.forName(value);
                    Constructor<?> defaultConstructor = null;
                    for (Constructor<?> constructor : receiverClass.getDeclaredConstructors()) {
                        if (constructor.getGenericParameterTypes().length != 0) continue;
                        defaultConstructor = constructor;
                        break;
                    }
                    if (defaultConstructor == null) continue;
                    defaultConstructor.setAccessible(true);
                    Object instance = defaultConstructor.newInstance(new Object[0]);
                    Method onReceiveMethod = receiverClass.getMethod("onReceive", Context.class, Intent.class);
                    onReceiveMethod.invoke(instance, context, intent);
                }
                catch (ClassNotFoundException | NullPointerException e) {
                    Logger.w(key + " seems not to be a receiver.", e);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

