/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import io.airbridge.internal.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;

public class Config {
    private static final String KEY_INSTALLED = "installed";
    private static final String KEY_SESSION_TIMESTAMP = "session_timestamp";
    private static final String KEY_INSTALL_TIMESTAMP = "install_timestamp";
    private static final String KEY_APP_INFO_TIMESTAMP = "appinfo_update_timestamp";
    private static final String KEY_BACKGROUND_TIMESTAMP = "background_timestamp";
    private static final String KEY_SESSION_ID = "session_id";
    static Config instance;
    static boolean disableOffline;
    private Properties props = new Properties();
    private File preferenceFile;

    public static Config getInstance() {
        return instance != null ? instance : (instance = new Config());
    }

    public void load(Context context) {
        String initialTransactionId;
        boolean hasInitialTransaction;
        File preferenceDir = Build.VERSION.SDK_INT >= 21 ? context.getNoBackupFilesDir() : context.getFilesDir();
        this.preferenceFile = new File(preferenceDir, "ab_session");
        if (this.preferenceFile.exists() && !disableOffline) {
            try {
                this.props.load(new FileInputStream(this.preferenceFile));
            }
            catch (Exception e) {
                Logger.e("Failed to load existing session.", e);
            }
        } else {
            SharedPreferences prefs = context.getSharedPreferences("ab_session", 0);
            if (prefs.contains("initialTransactionId")) {
                Logger.i("Old session file found. Migrating...", new Object[0]);
                Map prefData = prefs.getAll();
                for (String key : prefData.keySet()) {
                    this.put(key, prefData.get(key));
                }
                this.save();
                prefs.edit().clear().apply();
            }
        }
        boolean bl = hasInitialTransaction = (initialTransactionId = this.getString("initialTransactionId", null)) != null && !"".equals(initialTransactionId);
        if (this.isFirstTime() && hasInitialTransaction) {
            Logger.i("Initial transaction migration.", new Object[0]);
            this.put(KEY_INSTALLED, true);
            this.save();
        }
        this.setInstallTime(context);
    }

    public void updateLastSessionDate() {
        this.put(KEY_SESSION_TIMESTAMP, System.currentTimeMillis());
        this.save();
    }

    public String getLastSessionDate() {
        return this.props.getProperty(KEY_SESSION_TIMESTAMP);
    }

    public void updateLastAppInfoUpdateDate() {
        this.put(KEY_APP_INFO_TIMESTAMP, System.currentTimeMillis());
        this.save();
    }

    public long getLastAppInfoUpdateDate() {
        return this.getLong(KEY_APP_INFO_TIMESTAMP, 0L);
    }

    private void setInstallTime(Context context) {
        try {
            PackageManager pm = context.getPackageManager();
            long installTime = pm.getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime;
            this.put(KEY_INSTALL_TIMESTAMP, String.valueOf(installTime));
        }
        catch (PackageManager.NameNotFoundException e) {
            this.put(KEY_INSTALL_TIMESTAMP, String.valueOf(0L));
        }
    }

    public long getInstallTime() {
        return this.getLong(KEY_INSTALL_TIMESTAMP, 0L);
    }

    public void put(String key, Object value) {
        if (value == null || value.equals(this.props.get(key))) {
            return;
        }
        this.props.put(key, value.toString());
    }

    public synchronized void save() {
        if (disableOffline) {
            return;
        }
        try {
            this.props.store(new FileOutputStream(this.preferenceFile), null);
        }
        catch (Throwable e) {
            Logger.e("Failed to save session data.", e);
        }
    }

    public void setInstalled() {
        this.put(KEY_INSTALLED, true);
        this.save();
    }

    public void setBackgroundTimestamp(long timestamp) {
        this.put(KEY_BACKGROUND_TIMESTAMP, timestamp);
        this.save();
    }

    public long getBackgroundTimestamp() {
        return this.getLong(KEY_BACKGROUND_TIMESTAMP, 0L);
    }

    public void setSessionID() {
        this.put(KEY_SESSION_ID, UUID.randomUUID().toString());
        this.save();
    }

    public String getSessionId() {
        return this.getString(KEY_SESSION_ID, "11111111-1111-1111-1111-111111111111");
    }

    public boolean hasActiveSession() {
        return !this.isFirstTime();
    }

    public boolean isFirstTime() {
        return !this.getBoolean(KEY_INSTALLED, false);
    }

    public void delete() {
        this.props.clear();
        try {
            if (!disableOffline) {
                this.preferenceFile.delete();
            }
        }
        catch (Exception e) {
            Logger.e("Failed to remove session data", e);
        }
        this.put(KEY_INSTALLED, false);
        this.save();
    }

    public String getString(String key, String defaults) {
        return this.props.getProperty(key, defaults);
    }

    public int getInt(String key, int defaults) {
        return Integer.valueOf(this.props.getProperty(key, String.valueOf(defaults)));
    }

    public long getLong(String key, long defaults) {
        return Long.valueOf(this.props.getProperty(key, String.valueOf(defaults)));
    }

    public boolean getBoolean(String key, boolean defaults) {
        return Boolean.valueOf(this.props.getProperty(key, String.valueOf(defaults)));
    }

    static {
        disableOffline = false;
    }
}

