/*
 * Decompiled with CFR 0.152.
 */
package io.airbridge;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.support.annotation.IntRange;
import android.support.annotation.VisibleForTesting;
import io.airbridge.Config;
import io.airbridge.deeplink.DeepLink;
import io.airbridge.deviceinfo.DeviceInfo;
import io.airbridge.integration.IntegrationManager;
import io.airbridge.integration.Integrator;
import io.airbridge.internal.log.Logger;
import io.airbridge.internal.tasks.AirBridgeExecutor;
import io.airbridge.statistics.EventQueue;
import io.airbridge.statistics.Tracker;
import io.airbridge.statistics.events.DeepLinkLaunchEvent;
import io.airbridge.statistics.events.inapp.SignInEvent;
import io.airbridge.statistics.events.inapp.SignUpEvent;
import io.airbridge.statistics.page.LifecycleTracker;
import io.airbridge.statistics.page.PageInfoRegistry;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;

public class AirBridge {
    private static final String OLD_APP_ID_PATTERN = "^-?\\d+$";
    public static String appId;
    public static String appToken;
    public static boolean isDebugMode;
    public static boolean isAppDebuggable;
    public static boolean isWifiCollectionMode;
    public static boolean isInstalledAppCollectionMode;
    private static AtomicBoolean isInitialized;
    private static Tracker tracker;
    private static PageInfoRegistry pageInfoRegistry;
    private static LifecycleTracker lifecycleTracker;
    private static long lifecycleTime;

    public static void init(final Context context, String appName, String appToken) {
        if (isInitialized.getAndSet(true)) {
            return;
        }
        if (appName == null) {
            throw new IllegalArgumentException("App Name was not given!");
        }
        if (appToken == null) {
            throw new IllegalArgumentException("App Token was not given!");
        }
        appId = appName;
        AirBridge.appToken = appToken;
        boolean bl = isAppDebuggable = isDebugMode || AirBridge.isApkDebuggable(context);
        if (isAppDebuggable) {
            if (appName.matches(OLD_APP_ID_PATTERN)) {
                throw new IllegalArgumentException("App name must be a sub-domain name of your Airbridge App; Seems like you haven't been migrated from old version.\nPlease migrate according to http://docs.airbridge.io/ko/start/1-3-1.html");
            }
            if (appToken.contains("ey") && appToken.contains(".")) {
                throw new IllegalArgumentException("You're using user token from old version, not app token; Seems like you haven't been migrated from old version.\nPlease migrate according to http://docs.airbridge.io/ko/start/1-3-1.html");
            }
        }
        try {
            Config.getInstance().load(context);
            DeepLink.init(context);
            pageInfoRegistry = new PageInfoRegistry();
            tracker = new Tracker(context, pageInfoRegistry, DeviceInfo.getInstance());
            lifecycleTracker = new LifecycleTracker(context, pageInfoRegistry);
            tracker.setLifecycleTracker(lifecycleTracker);
            lifecycleTracker.setTracker(tracker);
            if (context instanceof Activity) {
                lifecycleTracker.onActivityCreated((Activity)context, null);
                Logger.e("As 1.1.0, you need to initialize Airbridge in your Application class.\nPlease migrate according to https://docs.airbridge.io/ko/advance/2-4-2.html");
            }
            AirBridgeExecutor.run(new Runnable(){

                @Override
                public void run() {
                    DeviceInfo.getInstance().fetch(context);
                }
            });
        }
        catch (Throwable e) {
            Logger.wtf("Error occurred while initializing", e);
        }
    }

    public static Tracker getTracker() {
        return tracker;
    }

    public static PageInfoRegistry getPageInfoRegistry() {
        return pageInfoRegistry;
    }

    public static LifecycleTracker getLifecycleTracker() {
        return lifecycleTracker;
    }

    public static long getLifecycleTime() {
        return lifecycleTime;
    }

    public static void setCustomSessionTimeOut(@IntRange(from=0L, to=604802L) long Time) {
        if (Time > 604800L) {
            Logger.d("lifecyTime is too long, make shorter than 7 days", new Object[0]);
        }
        lifecycleTime = Time * 1000L;
    }

    public static void setWifiInfoEnable(Boolean wifiInfoEnable) {
        isWifiCollectionMode = wifiInfoEnable;
    }

    public static void setInstalledAppEnable(Boolean installedAppEnable) {
        isInstalledAppCollectionMode = installedAppEnable;
    }

    public static void turnOnIntegration(Integrator integrator) {
        IntegrationManager.registerIntegration(integrator);
    }

    public static void deepLinkClicked(String uri) {
        tracker.send(new DeepLinkLaunchEvent(uri));
    }

    public static void userSignup(String value) {
        SignUpEvent event = new SignUpEvent().setUserId(value);
        tracker.send(event);
    }

    public static void userSignin(String value) {
        SignInEvent event = new SignInEvent().setUserId(value);
        tracker.send(event);
    }

    public static void setDebugMode(boolean enabled) {
        isDebugMode = enabled;
    }

    public static void setEnsureRequestMode(boolean enabled) {
        EventQueue.ensureRequestMode = enabled;
    }

    protected static boolean isApkDebuggable(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 64);
            Signature signature = packageInfo.signatures[0];
            ByteArrayInputStream stream = new ByteArrayInputStream(signature.toByteArray());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(stream);
            String certString = cert.getSubjectX500Principal().toString();
            return certString.contains("CN=Android Debug") && certString.contains("O=Android");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @VisibleForTesting
    static void clear() {
        isInitialized.set(false);
        tracker = null;
    }

    static {
        isWifiCollectionMode = false;
        isInstalledAppCollectionMode = true;
        isInitialized = new AtomicBoolean();
        lifecycleTime = 300000L;
    }
}

