/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.stream;

import io.activej.codegen.util.WithInitializer;
import io.activej.serializer.BinaryInput;
import io.activej.serializer.CorruptedDataException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamInput
implements Closeable,
WithInitializer<StreamInput> {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private BinaryInput in;
    private int limit;
    private final InputStream inputStream;
    private char[] charArray = new char[128];

    private StreamInput(InputStream inputStream, int initialBufferSize) {
        this.inputStream = inputStream;
        this.in = new BinaryInput(this.allocate(initialBufferSize));
    }

    public static StreamInput create(InputStream inputStream) {
        return new StreamInput(inputStream, 16384);
    }

    public static StreamInput create(InputStream inputStream, int bufferSize) {
        return new StreamInput(inputStream, bufferSize);
    }

    @Override
    public final void close() throws IOException {
        this.recycle();
        this.inputStream.close();
    }

    private void recycle() {
        if (this.in == null) {
            return;
        }
        this.recycle(this.in.array());
        this.in = null;
    }

    protected byte[] allocate(int size) {
        return new byte[size];
    }

    protected void recycle(byte[] array) {
    }

    public BinaryInput in() {
        return this.in;
    }

    public void in(BinaryInput in) {
        this.in = in;
    }

    public byte[] array() {
        return this.in.array();
    }

    public int pos() {
        return this.in.pos();
    }

    public void pos(int pos) {
        this.in.pos(pos);
    }

    public int limit() {
        return this.limit;
    }

    public int remaining() {
        return this.limit() - this.pos();
    }

    public void ensure(int bytes) throws IOException {
        if (this.remaining() < bytes) {
            this.doEnsureRead(bytes);
        }
    }

    private void doEnsureRead(int size) throws IOException {
        try {
            while (this.remaining() < size) {
                this.ensureWriteRemaining(size);
                int bytesRead = this.inputStream.read(this.in.array(), this.limit, this.in.array().length - this.limit);
                if (bytesRead == -1) {
                    this.close();
                    throw new CorruptedDataException("Unexpected end of data");
                }
                this.limit += bytesRead;
            }
        }
        catch (IOException e) {
            this.recycle();
            throw e;
        }
    }

    private void ensureWriteRemaining(int size) {
        int writeRemaining = this.in.array().length - this.limit;
        if (writeRemaining < size) {
            int readRemaining = this.remaining();
            if (this.in.array.length - readRemaining >= size) {
                System.arraycopy(this.in.array(), this.in.pos(), this.in.array(), 0, readRemaining);
                this.limit = readRemaining;
                this.in.pos = 0;
            } else {
                byte[] bytes = this.allocate(Math.max(this.in.array.length, this.remaining() + size));
                System.arraycopy(this.in.array(), this.in.pos(), bytes, 0, this.remaining());
                this.limit -= this.in.pos();
                this.in = new BinaryInput(bytes);
            }
        }
    }

    public final boolean isEndOfStream() throws IOException {
        if (this.limit == this.in.pos()) {
            this.ensureWriteRemaining(1);
            int bytesRead = this.inputStream.read(this.in.array(), this.limit, this.remaining());
            if (bytesRead == -1) {
                this.recycle();
                return true;
            }
            this.limit += bytesRead;
        }
        return false;
    }

    private char[] ensureCharArray(int length) {
        if (this.charArray.length < length) {
            this.charArray = new char[length + (length >>> 2)];
        }
        return this.charArray;
    }

    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        this.ensure(len);
        this.in.read(b, off, len);
        return len;
    }

    public final byte readByte() throws IOException {
        return this.in.pos < this.limit ? this.in.readByte() : this.readByteImpl();
    }

    private byte readByteImpl() throws IOException {
        this.doEnsureRead(1);
        return this.in.readByte();
    }

    public final boolean readBoolean() throws IOException {
        this.ensure(1);
        return this.in.readBoolean();
    }

    public final short readShort() throws IOException {
        this.ensure(2);
        return this.in.readShort();
    }

    public final int readInt() throws IOException {
        this.ensure(4);
        return this.in.readInt();
    }

    public final long readLong() throws IOException {
        this.ensure(8);
        return this.in.readLong();
    }

    public final int readVarInt() throws IOException {
        int result;
        int b = this.readByte();
        if (b >= 0) {
            result = b;
        } else {
            result = b & 0x7F;
            byte by = this.readByte();
            b = by;
            if (by >= 0) {
                result |= b << 7;
            } else {
                result |= (b & 0x7F) << 7;
                byte by2 = this.readByte();
                b = by2;
                if (by2 >= 0) {
                    result |= b << 14;
                } else {
                    result |= (b & 0x7F) << 14;
                    byte by3 = this.readByte();
                    b = by3;
                    if (by3 >= 0) {
                        result |= b << 21;
                    } else {
                        result |= (b & 0x7F) << 21;
                        byte by4 = this.readByte();
                        b = by4;
                        if (by4 >= 0) {
                            result |= b << 28;
                        } else {
                            this.close();
                            throw new CorruptedDataException("VarInt value takes more than 5 bytes");
                        }
                    }
                }
            }
        }
        return result;
    }

    public final long readVarLong() throws IOException {
        long result = 0L;
        for (int offset = 0; offset < 64; offset += 7) {
            byte b = this.readByte();
            result |= (long)(b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        this.close();
        throw new CorruptedDataException("VarLong value takes more than 10 bytes");
    }

    public final float readFloat() throws IOException {
        this.ensure(4);
        return this.in.readFloat();
    }

    public final double readDouble() throws IOException {
        this.ensure(8);
        return this.in.readDouble();
    }

    public final char readChar() throws IOException {
        this.ensure(2);
        return this.in.readChar();
    }

    @NotNull
    public final String readString() throws IOException {
        return this.readUTF8();
    }

    @NotNull
    public final String readUTF8() throws IOException {
        int length = this.readVarInt();
        if (length == 0) {
            return "";
        }
        this.ensure(length);
        String str = new String(this.in.array(), this.in.pos(), length, StandardCharsets.UTF_8);
        this.in.pos(this.in.pos() + length);
        return str;
    }

    @NotNull
    public final String readIso88591() throws IOException {
        int length = this.readVarInt();
        if (length == 0) {
            return "";
        }
        this.ensure(length);
        char[] chars = this.ensureCharArray(length);
        for (int i = 0; i < length; ++i) {
            int c = this.readByte() & 0xFF;
            chars[i] = (char)c;
        }
        return new String(chars, 0, length);
    }

    @NotNull
    public final String readUTF16() throws IOException {
        int length = this.readVarInt();
        if (length == 0) {
            return "";
        }
        this.ensure(length * 2);
        char[] chars = this.ensureCharArray(length);
        for (int i = 0; i < length; ++i) {
            byte b1 = this.in.array()[this.in.pos];
            byte b2 = this.in.array()[this.in.pos + 1];
            this.in.pos += 2;
            chars[i] = (char)(((b1 & 0xFF) << 8) + (b2 & 0xFF));
        }
        return new String(chars, 0, length);
    }

    @Nullable
    public final String readUTF8Nullable() throws IOException {
        int length = this.readVarInt();
        if (length-- == 0) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        this.ensure(length);
        String str = new String(this.in.array(), this.in.pos(), length, StandardCharsets.UTF_8);
        this.in.pos(this.in.pos() + length);
        return str;
    }

    @Nullable
    public final String readIso88591Nullable() throws IOException {
        int length = this.readVarInt();
        if (length-- == 0) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        this.ensure(length);
        char[] chars = this.ensureCharArray(length);
        for (int i = 0; i < length; ++i) {
            int c = this.readByte() & 0xFF;
            chars[i] = (char)c;
        }
        return new String(chars, 0, length);
    }

    @Nullable
    public final String readUTF16Nullable() throws IOException {
        int length = this.readVarInt();
        if (length-- == 0) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        this.ensure(length * 2);
        char[] chars = this.ensureCharArray(length);
        for (int i = 0; i < length; ++i) {
            byte b1 = this.in.array()[this.in.pos];
            byte b2 = this.in.array()[this.in.pos + 1];
            this.in.pos += 2;
            chars[i] = (char)(((b1 & 0xFF) << 8) + (b2 & 0xFF));
        }
        return new String(chars, 0, length);
    }
}

