/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.impl.SerializerDefRegularMap;
import io.activej.serializer.util.Utils;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class SerializerDefMap
extends SerializerDefRegularMap {
    public SerializerDefMap(SerializerDef keySerializer, SerializerDef valueSerializer) {
        this(keySerializer, valueSerializer, false);
    }

    private SerializerDefMap(SerializerDef keySerializer, SerializerDef valueSerializer, boolean nullable) {
        super(keySerializer, valueSerializer, Map.class, Map.class, Object.class, Object.class, nullable);
    }

    @Override
    @NotNull
    protected SerializerDef doEnsureNullable(CompatibilityLevel compatibilityLevel) {
        return new SerializerDefMap(this.keySerializer, this.valueSerializer, true);
    }

    @Override
    @NotNull
    protected Expression doDecode(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel, Expression length) {
        return Expressions.ifThenElse((Expression)Expressions.cmpEq((Expression)length, (Expression)Expressions.value((Object)0)), (Expression)Expressions.staticCall(Collections.class, (String)"emptyMap", (Expression[])new Expression[0]), (Expression)Expressions.ifThenElse((Expression)Expressions.cmpEq((Expression)length, (Expression)Expressions.value((Object)1)), (Expression)Expressions.staticCall(Collections.class, (String)"singletonMap", (Expression[])new Expression[]{this.keySerializer.defineDecoder(staticDecoders, in, version, compatibilityLevel), this.valueSerializer.defineDecoder(staticDecoders, in, version, compatibilityLevel)}), (Expression)super.doDecode(staticDecoders, in, version, compatibilityLevel, length)));
    }

    @Override
    @NotNull
    protected Expression createBuilder(Expression length) {
        Class<?> rawType = this.keySerializer.getDecodeType();
        if (rawType.isEnum()) {
            return Expressions.constructor(EnumMap.class, (Expression[])new Expression[]{Expressions.value(rawType)});
        }
        return Expressions.constructor(HashMap.class, (Expression[])new Expression[]{Utils.hashInitialSize(length)});
    }
}

