/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.ClassBuilder;
import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.StoreDef;
import io.activej.codegen.expression.Variable;
import io.activej.serializer.AbstractSerializerDef;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.util.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;

public final class SerializerDefClass
extends AbstractSerializerDef {
    private final Class<?> encodeType;
    private final Class<?> decodeType;
    private final LinkedHashMap<String, FieldDef> fields = new LinkedHashMap();
    private Constructor<?> constructor;
    private List<String> constructorParams;
    private Method factory;
    private List<String> factoryParams;
    private final Map<Method, List<String>> setters = new LinkedHashMap<Method, List<String>>();

    private SerializerDefClass(Class<?> encodeType, Class<?> decodeType) {
        this.encodeType = encodeType;
        this.decodeType = decodeType;
    }

    public static SerializerDefClass create(@NotNull Class<?> type) {
        return new SerializerDefClass(type, type);
    }

    public static SerializerDefClass create(@NotNull Class<?> encodeType, @NotNull Class<?> decodeType) {
        if (!encodeType.isAssignableFrom(decodeType)) {
            throw new IllegalArgumentException(String.format("Class should be assignable from %s", decodeType));
        }
        return new SerializerDefClass(encodeType, decodeType);
    }

    public void addSetter(@NotNull Method method, @NotNull List<String> fields) {
        if (this.decodeType.isInterface()) {
            throw new IllegalStateException("Class should either implement an interface or be an interface");
        }
        if (Modifier.isPrivate(method.getModifiers())) {
            throw new IllegalArgumentException(String.format("Setter cannot be private: %s", method));
        }
        if (method.getGenericParameterTypes().length != fields.size()) {
            throw new IllegalArgumentException("Number of arguments of a method should match a size of list of fields");
        }
        if (this.setters.containsKey(method)) {
            throw new IllegalArgumentException("Setter has already been added");
        }
        this.setters.put(method, fields);
    }

    public void setFactory(@NotNull Method methodFactory, @NotNull List<String> fields) {
        if (this.decodeType.isInterface()) {
            throw new IllegalStateException("Class should either implement an interface or be an interface");
        }
        if (this.factory != null) {
            throw new IllegalArgumentException(String.format("Factory is already set: %s", this.factory));
        }
        if (Modifier.isPrivate(methodFactory.getModifiers())) {
            throw new IllegalArgumentException(String.format("Factory cannot be private: %s", methodFactory));
        }
        if (!Modifier.isStatic(methodFactory.getModifiers())) {
            throw new IllegalArgumentException(String.format("Factory must be static: %s", methodFactory));
        }
        if (methodFactory.getGenericParameterTypes().length != fields.size()) {
            throw new IllegalArgumentException("Number of arguments of a method should match a size of list of fields");
        }
        this.factory = methodFactory;
        this.factoryParams = fields;
    }

    public void setConstructor(@NotNull Constructor<?> constructor, @NotNull List<String> fields) {
        if (this.decodeType.isInterface()) {
            throw new IllegalStateException("Class should either implement an interface or be an interface");
        }
        if (this.constructor != null) {
            throw new IllegalArgumentException(String.format("Constructor is already set: %s", this.constructor));
        }
        if (Modifier.isPrivate(constructor.getModifiers())) {
            throw new IllegalArgumentException(String.format("Constructor cannot be private: %s", constructor));
        }
        if (constructor.getGenericParameterTypes().length != fields.size()) {
            throw new IllegalArgumentException("Number of arguments of a constructor should match a size of list of fields");
        }
        this.constructor = constructor;
        this.constructorParams = fields;
    }

    public void addField(Field field, SerializerDef serializer, int added, int removed) {
        if (this.decodeType.isInterface()) {
            throw new IllegalStateException("Class should either implement an interface or be an interface");
        }
        if (!Modifier.isPublic(field.getModifiers())) {
            throw new IllegalArgumentException("Method should be public");
        }
        String fieldName = field.getName();
        if (this.fields.containsKey(fieldName)) {
            throw new IllegalArgumentException(String.format("Duplicate field '%s'", field));
        }
        FieldDef fieldDef = new FieldDef();
        fieldDef.field = field;
        fieldDef.serializer = serializer;
        fieldDef.versionAdded = added;
        fieldDef.versionDeleted = removed;
        this.fields.put(fieldName, fieldDef);
    }

    public void addGetter(Method method, SerializerDef serializer, int added, int removed) {
        if (method.getGenericParameterTypes().length != 0) {
            throw new IllegalArgumentException("Method should have 0 generic parameter types");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("Method should be public");
        }
        String fieldName = SerializerDefClass.stripGet(method.getName(), method.getReturnType());
        if (this.fields.containsKey(fieldName)) {
            throw new IllegalArgumentException(String.format("Duplicate field '%s'", method));
        }
        FieldDef fieldDef = new FieldDef();
        fieldDef.method = method;
        fieldDef.serializer = serializer;
        fieldDef.versionAdded = added;
        fieldDef.versionDeleted = removed;
        this.fields.put(fieldName, fieldDef);
    }

    public void addMatchingSetters() {
        if (this.decodeType.isInterface()) {
            throw new IllegalArgumentException("Class should either implement an interface or be an interface");
        }
        HashSet<String> usedFields = new HashSet<String>();
        if (this.constructorParams != null) {
            usedFields.addAll(this.constructorParams);
        }
        if (this.factoryParams != null) {
            usedFields.addAll(this.factoryParams);
        }
        for (List<String> list : this.setters.values()) {
            usedFields.addAll(list);
        }
        for (Map.Entry entry : this.fields.entrySet()) {
            String fieldName = (String)entry.getKey();
            Method getter = ((FieldDef)entry.getValue()).method;
            if (getter == null || usedFields.contains(fieldName)) continue;
            String setterName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            try {
                Method setter = this.decodeType.getMethod(setterName, getter.getReturnType());
                if (Modifier.isPrivate(setter.getModifiers())) continue;
                this.addSetter(setter, Collections.singletonList(fieldName));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void accept(SerializerDef.Visitor visitor) {
        for (Map.Entry<String, FieldDef> entry : this.fields.entrySet()) {
            visitor.visit(entry.getKey(), entry.getValue().serializer);
        }
    }

    @Override
    public Set<Integer> getVersions() {
        HashSet<Integer> versions = new HashSet<Integer>();
        for (FieldDef fieldDef : this.fields.values()) {
            if (fieldDef.versionAdded != -1) {
                versions.add(fieldDef.versionAdded);
            }
            if (fieldDef.versionDeleted == -1) continue;
            versions.add(fieldDef.versionDeleted);
        }
        return versions;
    }

    @Override
    public boolean isInline(int version, CompatibilityLevel compatibilityLevel) {
        return false;
    }

    @Override
    public Class<?> getEncodeType() {
        return this.encodeType;
    }

    @Override
    public Class<?> getDecodeType() {
        return this.decodeType;
    }

    private static String stripGet(String getterName, Class<?> type) {
        if ((type == Boolean.TYPE || type == Boolean.class) && getterName.startsWith("is") && getterName.length() > 2) {
            return Character.toLowerCase(getterName.charAt(2)) + getterName.substring(3);
        }
        if (getterName.startsWith("get") && getterName.length() > 3) {
            return Character.toLowerCase(getterName.charAt(3)) + getterName.substring(4);
        }
        return getterName;
    }

    @Override
    public Expression encoder(SerializerDef.StaticEncoders staticEncoders, Expression buf, Variable pos, Expression value, int version, CompatibilityLevel compatibilityLevel) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (Map.Entry<String, FieldDef> entry : this.fields.entrySet()) {
            String fieldName = entry.getKey();
            FieldDef fieldDef = entry.getValue();
            if (!fieldDef.hasVersion(version)) continue;
            Class<?> fieldType = fieldDef.serializer.getEncodeType();
            if (fieldDef.field != null) {
                list.add(fieldDef.serializer.defineEncoder(staticEncoders, buf, pos, Expressions.cast((Expression)Expressions.property((Expression)value, (String)fieldName), fieldType), version, compatibilityLevel));
                continue;
            }
            if (fieldDef.method != null) {
                list.add(fieldDef.serializer.defineEncoder(staticEncoders, buf, pos, Expressions.cast((Expression)Expressions.call((Expression)value, (String)fieldDef.method.getName(), (Expression[])new Expression[0]), fieldType), version, compatibilityLevel));
                continue;
            }
            throw new AssertionError();
        }
        return Expressions.sequence(list);
    }

    @Override
    public Expression decoder(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel) {
        return this.decoder(staticDecoders, in, version, compatibilityLevel, value -> Expressions.sequence((Expression[])new Expression[0]));
    }

    public Expression decoder(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel, UnaryOperator<Expression> instanceInitializer) {
        if (this.decodeType.isInterface()) {
            return this.deserializeInterface(staticDecoders, in, version, compatibilityLevel);
        }
        if (this.constructor == null && this.factory == null && this.setters.isEmpty()) {
            return this.deserializeClassSimple(staticDecoders, in, version, compatibilityLevel, instanceInitializer);
        }
        return Expressions.let((List)Utils.get(() -> {
            ArrayList<Expression> fieldDeserializers = new ArrayList<Expression>();
            for (FieldDef fieldDef : this.fields.values()) {
                if (!fieldDef.hasVersion(version)) continue;
                fieldDeserializers.add(fieldDef.serializer.defineDecoder(staticDecoders, in, version, compatibilityLevel));
            }
            return fieldDeserializers;
        }), fieldValues -> {
            HashMap<String, Expression> map = new HashMap<String, Expression>();
            int i = 0;
            for (Map.Entry<String, FieldDef> entry : this.fields.entrySet()) {
                FieldDef fieldDef = entry.getValue();
                if (!fieldDef.hasVersion(version)) continue;
                map.put(entry.getKey(), (Expression)fieldValues.get(i++));
            }
            return Expressions.let((Expression)(this.factory == null ? this.callConstructor(this.decodeType, map, version) : this.callFactoryMethod(map, version)), instance -> Expressions.sequence(seq -> {
                seq.add((Expression)instanceInitializer.apply((Expression)instance));
                for (Map.Entry<Method, List<String>> entry : this.setters.entrySet()) {
                    Method method = entry.getKey();
                    List<String> fieldNames = entry.getValue();
                    boolean found = false;
                    for (String fieldName : fieldNames) {
                        FieldDef fieldDef = this.fields.get(fieldName);
                        if (fieldDef == null) {
                            throw new NullPointerException(String.format("Field '%s' is not found in '%s'", fieldName, method));
                        }
                        if (!fieldDef.hasVersion(version)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    Expression[] temp = new Expression[parameterTypes.length];
                    for (int j = 0; j < fieldNames.size(); ++j) {
                        String fieldName = fieldNames.get(j);
                        FieldDef fieldDef = this.fields.get(fieldName);
                        assert (fieldDef != null);
                        temp[j] = fieldDef.hasVersion(version) ? Expressions.cast((Expression)((Expression)map.get(fieldName)), parameterTypes[j]) : Expressions.cast((Expression)this.pushDefaultValue(fieldDef.getAsmType()), parameterTypes[j]);
                    }
                    seq.add(Expressions.call((Expression)instance, (String)method.getName(), (Expression[])temp));
                }
                for (Map.Entry<Object, Object> entry : this.fields.entrySet()) {
                    String fieldName = (String)entry.getKey();
                    FieldDef fieldDef = (FieldDef)entry.getValue();
                    if (!fieldDef.hasVersion(version) || fieldDef.field == null || Modifier.isFinal(fieldDef.field.getModifiers())) continue;
                    Variable property = Expressions.property((Expression)instance, (String)fieldName);
                    seq.add(Expressions.set((StoreDef)property, (Expression)Expressions.cast((Expression)((Expression)map.get(fieldName)), fieldDef.getRawType())));
                }
                return instance;
            }));
        });
    }

    private Expression callFactoryMethod(Map<String, Expression> map, int version) {
        Expression[] param = new Expression[this.factoryParams.size()];
        Class<?>[] parameterTypes = this.factory.getParameterTypes();
        for (int i = 0; i < this.factoryParams.size(); ++i) {
            String fieldName = this.factoryParams.get(i);
            FieldDef fieldDef = this.fields.get(fieldName);
            if (fieldDef == null) {
                throw new NullPointerException(String.format("Field '%s' is not found in '%s'", fieldName, this.factory));
            }
            param[i] = fieldDef.hasVersion(version) ? Expressions.cast((Expression)map.get(fieldName), parameterTypes[i]) : Expressions.cast((Expression)this.pushDefaultValue(fieldDef.getAsmType()), parameterTypes[i]);
        }
        return Expressions.staticCall(this.factory.getDeclaringClass(), (String)this.factory.getName(), (Expression[])param);
    }

    private Expression callConstructor(Class<?> targetType, Map<String, Expression> map, int version) {
        if (this.constructorParams == null) {
            Expression[] param = new Expression[]{};
            return Expressions.constructor(targetType, (Expression[])param);
        }
        Expression[] param = new Expression[this.constructorParams.size()];
        Class<?>[] parameterTypes = this.constructor.getParameterTypes();
        for (int i = 0; i < this.constructorParams.size(); ++i) {
            String fieldName = this.constructorParams.get(i);
            FieldDef fieldDef = this.fields.get(fieldName);
            if (fieldDef == null) {
                throw new NullPointerException(String.format("Field '%s' is not found in '%s'", fieldName, this.constructor));
            }
            param[i] = fieldDef.hasVersion(version) ? Expressions.cast((Expression)map.get(fieldName), parameterTypes[i]) : Expressions.cast((Expression)this.pushDefaultValue(fieldDef.getAsmType()), parameterTypes[i]);
        }
        return Expressions.constructor(targetType, (Expression[])param);
    }

    private Expression deserializeInterface(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel) {
        if (this.fields.values().stream().anyMatch(fieldDef -> ((FieldDef)fieldDef).method == null)) {
            throw new NullPointerException();
        }
        ClassBuilder classBuilder = ClassBuilder.create(this.decodeType, (Class[])new Class[0]);
        for (Map.Entry<String, FieldDef> entry : this.fields.entrySet()) {
            String fieldName = entry.getKey();
            Method method = entry.getValue().method;
            classBuilder.withField(fieldName, method.getReturnType()).withMethod(method.getName(), (Expression)Expressions.property((Expression)Expressions.self(), (String)fieldName));
        }
        Class newClass = staticDecoders.buildClass(classBuilder);
        return Expressions.let((Expression)Expressions.constructor(newClass, (Expression[])new Expression[0]), instance -> Expressions.sequence(seq -> {
            for (Map.Entry<String, FieldDef> entry : this.fields.entrySet()) {
                FieldDef fieldDef = entry.getValue();
                if (!fieldDef.hasVersion(version)) continue;
                Variable property = Expressions.property((Expression)instance, (String)entry.getKey());
                Expression expression = fieldDef.serializer.defineDecoder(staticDecoders, in, version, compatibilityLevel);
                seq.add(Expressions.set((StoreDef)property, (Expression)expression));
            }
            return instance;
        }));
    }

    private Expression deserializeClassSimple(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel, UnaryOperator<Expression> instanceInitializer) {
        return Expressions.let((Expression)Expressions.constructor(this.decodeType, (Expression[])new Expression[0]), instance -> Expressions.sequence(seq -> {
            seq.add((Expression)instanceInitializer.apply((Expression)instance));
            for (Map.Entry<String, FieldDef> entry : this.fields.entrySet()) {
                FieldDef fieldDef = entry.getValue();
                if (!fieldDef.hasVersion(version)) continue;
                seq.add(Expressions.set((StoreDef)Expressions.property((Expression)instance, (String)entry.getKey()), (Expression)fieldDef.serializer.defineDecoder(staticDecoders, in, version, compatibilityLevel)));
            }
            return instance;
        }));
    }

    private Expression pushDefaultValue(Type type) {
        switch (type.getSort()) {
            case 1: {
                return Expressions.value((Object)false);
            }
            case 2: {
                return Expressions.value((Object)Character.valueOf('\u0000'));
            }
            case 3: {
                return Expressions.value((Object)0);
            }
            case 4: {
                return Expressions.value((Object)0);
            }
            case 5: {
                return Expressions.value((Object)0);
            }
            case 7: {
                return Expressions.value((Object)0L);
            }
            case 6: {
                return Expressions.value((Object)Float.valueOf(0.0f));
            }
            case 8: {
                return Expressions.value((Object)0.0);
            }
            case 9: 
            case 10: {
                return Expressions.nullRef((Type)type);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    public String toString() {
        return "SerializerDefClass{" + this.encodeType.getSimpleName() + '}';
    }

    private static final class FieldDef {
        private Field field;
        private Method method;
        private int versionAdded = -1;
        private int versionDeleted = -1;
        private SerializerDef serializer;

        private FieldDef() {
        }

        public boolean hasVersion(int version) {
            if (this.versionAdded == -1 && this.versionDeleted == -1) {
                return true;
            }
            if (this.versionAdded != -1 && this.versionDeleted == -1) {
                return version >= this.versionAdded;
            }
            if (this.versionAdded == -1) {
                return version < this.versionDeleted;
            }
            if (this.versionAdded > this.versionDeleted) {
                return version < this.versionDeleted || version >= this.versionAdded;
            }
            if (this.versionAdded < this.versionDeleted) {
                return version >= this.versionAdded && version < this.versionDeleted;
            }
            throw new IllegalStateException("Added and deleted versions are equal");
        }

        public Class<?> getRawType() {
            if (this.field != null) {
                return this.field.getType();
            }
            if (this.method != null) {
                return this.method.getReturnType();
            }
            throw new AssertionError();
        }

        public Type getAsmType() {
            return Type.getType(this.getRawType());
        }
    }
}

