/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer.impl;

import io.activej.codegen.expression.Expression;
import io.activej.codegen.expression.Expressions;
import io.activej.codegen.expression.Variable;
import io.activej.serializer.AbstractSerializerDef;
import io.activej.serializer.CompatibilityLevel;
import io.activej.serializer.SerializerDef;
import io.activej.serializer.impl.SerializerDefNullable;
import io.activej.serializer.impl.SerializerDefWithNullable;
import io.activej.serializer.impl.SerializerExpressions;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;

public final class SerializerDefByteBuffer
extends AbstractSerializerDef
implements SerializerDefWithNullable {
    private final boolean wrapped;
    private final boolean nullable;

    public SerializerDefByteBuffer() {
        this(false);
    }

    public SerializerDefByteBuffer(boolean wrapped) {
        this.wrapped = wrapped;
        this.nullable = false;
    }

    private SerializerDefByteBuffer(boolean wrapped, boolean nullable) {
        this.wrapped = wrapped;
        this.nullable = nullable;
    }

    @Override
    public void accept(SerializerDef.Visitor visitor) {
    }

    @Override
    public Set<Integer> getVersions() {
        return Collections.emptySet();
    }

    @Override
    public Class<?> getEncodeType() {
        return ByteBuffer.class;
    }

    @Override
    public Expression encoder(SerializerDef.StaticEncoders staticEncoders, Expression buf, Variable pos, Expression value, int version, CompatibilityLevel compatibilityLevel) {
        return Expressions.let((Expression)Expressions.cast((Expression)value, ByteBuffer.class), buffer -> {
            if (!this.nullable) {
                return Expressions.let((Expression)Expressions.call((Expression)buffer, (String)"remaining", (Expression[])new Expression[0]), remaining -> Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.writeVarInt(buf, pos, (Expression)remaining), SerializerExpressions.writeBytes(buf, pos, Expressions.call((Expression)buffer, (String)"array", (Expression[])new Expression[0]), Expressions.call((Expression)buffer, (String)"position", (Expression[])new Expression[0]), (Expression)remaining)}));
            }
            return Expressions.ifThenElse((Expression)Expressions.isNull((Expression)buffer), (Expression)SerializerExpressions.writeByte(buf, pos, Expressions.value((Object)0)), (Expression)Expressions.let((Expression)Expressions.call((Expression)buffer, (String)"remaining", (Expression[])new Expression[0]), remaining -> Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.writeVarInt(buf, pos, Expressions.inc((Expression)remaining)), SerializerExpressions.writeBytes(buf, pos, Expressions.call((Expression)buffer, (String)"array", (Expression[])new Expression[0]), Expressions.call((Expression)buffer, (String)"position", (Expression[])new Expression[0]), (Expression)remaining)})));
        });
    }

    @Override
    public Expression decoder(SerializerDef.StaticDecoders staticDecoders, Expression in, int version, CompatibilityLevel compatibilityLevel) {
        return !this.wrapped ? Expressions.let((Expression)SerializerExpressions.readVarInt(in), length -> {
            if (!this.nullable) {
                return Expressions.let((Expression)Expressions.arrayNew(byte[].class, (Expression)length), array -> Expressions.sequence((Expression[])new Expression[]{length, SerializerExpressions.readBytes(in, (Expression)array), Expressions.staticCall(ByteBuffer.class, (String)"wrap", (Expression[])new Expression[]{array})}));
            }
            return Expressions.ifThenElse((Expression)Expressions.cmpEq((Expression)length, (Expression)Expressions.value((Object)0)), (Expression)Expressions.nullRef(ByteBuffer.class), (Expression)Expressions.let((Expression)Expressions.arrayNew(byte[].class, (Expression)Expressions.dec((Expression)length)), array -> Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.readBytes(in, (Expression)array), Expressions.staticCall(ByteBuffer.class, (String)"wrap", (Expression[])new Expression[]{array})})));
        }) : Expressions.let((Expression)SerializerExpressions.readVarInt(in), length -> {
            if (!this.nullable) {
                return Expressions.let((Expression)Expressions.staticCall(ByteBuffer.class, (String)"wrap", (Expression[])new Expression[]{SerializerExpressions.array(in), SerializerExpressions.pos(in), length}), buf -> Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.move(in, (Expression)length), buf}));
            }
            return Expressions.ifThenElse((Expression)Expressions.cmpEq((Expression)length, (Expression)Expressions.value((Object)0)), (Expression)Expressions.nullRef(ByteBuffer.class), (Expression)Expressions.let((Expression)Expressions.staticCall(ByteBuffer.class, (String)"wrap", (Expression[])new Expression[]{SerializerExpressions.array(in), SerializerExpressions.pos(in), Expressions.dec((Expression)length)}), result -> Expressions.sequence((Expression[])new Expression[]{SerializerExpressions.move(in, (Expression)length), result})));
        });
    }

    @Override
    public SerializerDef ensureNullable(CompatibilityLevel compatibilityLevel) {
        if (compatibilityLevel.getLevel() < CompatibilityLevel.LEVEL_3.getLevel()) {
            return new SerializerDefNullable(this);
        }
        return new SerializerDefByteBuffer(this.wrapped, true);
    }
}

