/*
 * Decompiled with CFR 0.152.
 */
package io.activej.serializer;

import io.activej.serializer.util.BinaryOutputUtils;

public final class BinaryOutput {
    private final byte[] array;
    private int pos;

    public BinaryOutput(byte[] array) {
        this.array = array;
    }

    public BinaryOutput(byte[] array, int pos) {
        this.array = array;
        this.pos = pos;
    }

    public byte[] array() {
        return this.array;
    }

    public int pos() {
        return this.pos;
    }

    public void pos(int pos) {
        this.pos = pos;
    }

    public void move(int delta) {
        this.pos += delta;
    }

    public void write(byte[] bytes) {
        this.pos = BinaryOutputUtils.write(this.array, this.pos, bytes);
    }

    public void write(byte[] bytes, int bytesOff, int len) {
        this.pos = BinaryOutputUtils.write(this.array, this.pos, bytes, bytesOff, len);
    }

    public void writeBoolean(boolean v) {
        this.pos = BinaryOutputUtils.writeBoolean(this.array, this.pos, v);
    }

    public void writeByte(byte v) {
        this.pos = BinaryOutputUtils.writeByte(this.array, this.pos, v);
    }

    public void writeShort(short v) {
        this.pos = BinaryOutputUtils.writeShort(this.array, this.pos, v);
    }

    public void writeChar(char v) {
        this.pos = BinaryOutputUtils.writeChar(this.array, this.pos, v);
    }

    public void writeInt(int v) {
        this.pos = BinaryOutputUtils.writeInt(this.array, this.pos, v);
    }

    public void writeLong(long v) {
        this.pos = BinaryOutputUtils.writeLong(this.array, this.pos, v);
    }

    public void writeVarInt(int v) {
        this.pos = BinaryOutputUtils.writeVarInt(this.array, this.pos, v);
    }

    public void writeVarLong(long v) {
        this.pos = BinaryOutputUtils.writeVarLong(this.array, this.pos, v);
    }

    public void writeFloat(float v) {
        this.pos = BinaryOutputUtils.writeFloat(this.array, this.pos, v);
    }

    public void writeDouble(double v) {
        this.pos = BinaryOutputUtils.writeDouble(this.array, this.pos, v);
    }

    public void writeIso88591(String s) {
        this.pos = BinaryOutputUtils.writeIso88591(this.array, this.pos, s);
    }

    public void writeIso88591Nullable(String s) {
        this.pos = BinaryOutputUtils.writeIso88591Nullable(this.array, this.pos, s);
    }

    public void writeUTF8(String s) {
        this.pos = BinaryOutputUtils.writeUTF8(this.array, this.pos, s);
    }

    public void writeUTF8Nullable(String s) {
        this.pos = BinaryOutputUtils.writeUTF8Nullable(this.array, this.pos, s);
    }

    public void writeUTF8mb3(String s) {
        this.pos = BinaryOutputUtils.writeUTF8mb3(this.array, this.pos, s);
    }

    public void writeUTF8mb3Nullable(String s) {
        this.pos = BinaryOutputUtils.writeUTF8mb3Nullable(this.array, this.pos, s);
    }

    public void writeUTF16(String s) {
        this.pos = BinaryOutputUtils.writeUTF16(this.array, this.pos, s);
    }

    public void writeUTF16LE(String s) {
        this.pos = BinaryOutputUtils.writeUTF16LE(this.array, this.pos, s);
    }

    public void writeUTF16Nullable(String s) {
        this.pos = BinaryOutputUtils.writeUTF16Nullable(this.array, this.pos, s);
    }

    public void writeUTF16NullableLE(String s) {
        this.pos = BinaryOutputUtils.writeUTF16NullableLE(this.array, this.pos, s);
    }
}

