/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.types.Summary;
import io.ably.lib.util.Log;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class MessageAnnotations {
    private static final String TAG = MessageAnnotations.class.getName();
    private static final String SUMMARY = "summary";
    public Summary summary;

    public MessageAnnotations() {
        this.summary = new Summary(new HashMap<String, JsonObject>());
    }

    public MessageAnnotations(Summary summary) {
        this.summary = summary != null ? summary : new Summary(new HashMap<String, JsonObject>());
    }

    void writeMsgpack(MessagePacker packer) throws IOException {
        int fieldCount = 0;
        if (this.summary != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        if (this.summary != null) {
            packer.packString(SUMMARY);
            this.summary.write(packer);
        }
    }

    static MessageAnnotations read(MessageUnpacker unpacker) throws IOException {
        MessageAnnotations annotations = new MessageAnnotations();
        int fieldCount = unpacker.unpackMapHeader();
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            if (fieldName.equals(SUMMARY)) {
                annotations.summary = Summary.read(unpacker);
                continue;
            }
            Log.v(TAG, "Unexpected field: " + fieldName);
            unpacker.skipValue();
        }
        return annotations;
    }

    static MessageAnnotations read(JsonElement json) throws MessageDecodeException {
        if (!json.isJsonObject()) {
            throw MessageDecodeException.fromDescription("Message annotations is of type \"" + json.getClass() + "\" when expected a JSON object.");
        }
        MessageAnnotations annotations = new MessageAnnotations();
        JsonElement summaryElement = json.getAsJsonObject().get(SUMMARY);
        if (summaryElement != null) {
            if (!summaryElement.isJsonObject()) {
                throw MessageDecodeException.fromDescription("MessageAnnotations summary is of type \"" + summaryElement.getClass() + "\" when expected a JSON object.");
            }
            annotations.summary = Summary.read((JsonElement)summaryElement.getAsJsonObject());
        }
        return annotations;
    }

    JsonElement toJsonTree() {
        JsonObject json = new JsonObject();
        if (this.summary != null) {
            json.add(SUMMARY, this.summary.toJsonTree());
        }
        return json;
    }

    public String toString() {
        return "{MessageAnnotations summary=" + this.summary + "}";
    }

    public static class Serializer
    implements JsonSerializer<MessageAnnotations>,
    JsonDeserializer<MessageAnnotations> {
        public JsonElement serialize(MessageAnnotations annotations, Type typeOfMessage, JsonSerializationContext ctx) {
            return annotations.toJsonTree();
        }

        public MessageAnnotations deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return MessageAnnotations.read(json);
            }
            catch (MessageDecodeException e) {
                Log.e(TAG, e.getMessage(), e);
                throw new JsonParseException("Failed to deserialize MessageAnnotations from JSON.", (Throwable)e);
            }
        }
    }
}

