/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import io.ably.lib.objects.ObjectsHelper;
import io.ably.lib.objects.ObjectsJsonSerializer;
import io.ably.lib.objects.ObjectsSerializer;
import io.ably.lib.types.Annotation;
import io.ably.lib.types.AnnotationSerializer;
import io.ably.lib.types.ConnectionDetails;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.PresenceMessage;
import io.ably.lib.types.PresenceSerializer;
import io.ably.lib.util.Log;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class ProtocolMessage {
    public Action action;
    public int flags;
    public int count;
    public ErrorInfo error;
    public String id;
    public String channel;
    public String channelSerial;
    public String connectionId;
    public Long msgSerial;
    public long timestamp;
    public Message[] messages;
    public PresenceMessage[] presence;
    public ConnectionDetails connectionDetails;
    public AuthDetails auth;
    public Map<String, String> params;
    public Annotation[] annotations;
    @JsonAdapter(value=ObjectsJsonSerializer.class)
    @Nullable
    public Object[] state;
    private static final String TAG = ProtocolMessage.class.getName();

    public static boolean ackRequired(ProtocolMessage msg) {
        return msg.action == Action.message || msg.action == Action.presence || msg.action == Action.object || msg.action == Action.annotation;
    }

    public ProtocolMessage() {
    }

    public ProtocolMessage(Action action) {
        this.action = action;
    }

    public ProtocolMessage(Action action, String channel) {
        this.action = action;
        this.channel = channel;
    }

    public boolean hasFlag(Flag flag) {
        return (this.flags & flag.getMask()) == flag.getMask();
    }

    public void setFlag(Flag flag) {
        this.flags |= flag.getMask();
    }

    public void setFlags(int flags) {
        this.flags |= flags;
    }

    void writeMsgpack(MessagePacker packer) throws IOException {
        int fieldCount = 1;
        if (this.channel != null) {
            ++fieldCount;
        }
        if (this.msgSerial != null) {
            ++fieldCount;
        }
        if (this.messages != null) {
            ++fieldCount;
        }
        if (this.presence != null) {
            ++fieldCount;
        }
        if (this.auth != null) {
            ++fieldCount;
        }
        if (this.flags != 0) {
            ++fieldCount;
        }
        if (this.params != null) {
            ++fieldCount;
        }
        if (this.channelSerial != null) {
            ++fieldCount;
        }
        if (this.annotations != null) {
            ++fieldCount;
        }
        if (this.state != null && ObjectsHelper.getSerializer() != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        packer.packString("action");
        packer.packInt(this.action.getValue());
        if (this.channel != null) {
            packer.packString("channel");
            packer.packString(this.channel);
        }
        if (this.msgSerial != null) {
            packer.packString("msgSerial");
            packer.packLong(this.msgSerial.longValue());
        }
        if (this.messages != null) {
            packer.packString("messages");
            MessageSerializer.writeMsgpackArray(this.messages, packer);
        }
        if (this.presence != null) {
            packer.packString("presence");
            PresenceSerializer.writeMsgpackArray(this.presence, packer);
        }
        if (this.auth != null) {
            packer.packString("auth");
            this.auth.writeMsgpack(packer);
        }
        if (this.flags != 0) {
            packer.packString("flags");
            packer.packInt(this.flags);
        }
        if (this.params != null) {
            packer.packString("params");
            MessageSerializer.write(this.params, packer);
        }
        if (this.channelSerial != null) {
            packer.packString("channelSerial");
            packer.packString(this.channelSerial);
        }
        if (this.annotations != null) {
            packer.packString("annotations");
            AnnotationSerializer.writeMsgpackArray(this.annotations, packer);
        }
        if (this.state != null) {
            ObjectsSerializer objectsSerializer = ObjectsHelper.getSerializer();
            if (objectsSerializer != null) {
                packer.packString("state");
                objectsSerializer.writeMsgpackArray(this.state, packer);
            } else {
                Log.w(TAG, "Skipping 'state' field msgpack serialization because ObjectsSerializer not found");
            }
        }
    }

    ProtocolMessage readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        block40: for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            switch (fieldName) {
                case "action": {
                    this.action = Action.findByValue(unpacker.unpackInt());
                    continue block40;
                }
                case "flags": {
                    this.flags = unpacker.unpackInt();
                    continue block40;
                }
                case "count": {
                    this.count = unpacker.unpackInt();
                    continue block40;
                }
                case "error": {
                    this.error = ErrorInfo.fromMsgpack(unpacker);
                    continue block40;
                }
                case "id": {
                    this.id = unpacker.unpackString();
                    continue block40;
                }
                case "channel": {
                    this.channel = unpacker.unpackString();
                    continue block40;
                }
                case "channelSerial": {
                    this.channelSerial = unpacker.unpackString();
                    continue block40;
                }
                case "connectionId": {
                    this.connectionId = unpacker.unpackString();
                    continue block40;
                }
                case "msgSerial": {
                    this.msgSerial = unpacker.unpackLong();
                    continue block40;
                }
                case "timestamp": {
                    this.timestamp = unpacker.unpackLong();
                    continue block40;
                }
                case "messages": {
                    this.messages = MessageSerializer.readMsgpackArray(unpacker);
                    continue block40;
                }
                case "presence": {
                    this.presence = PresenceSerializer.readMsgpackArray(unpacker);
                    continue block40;
                }
                case "connectionDetails": {
                    this.connectionDetails = ConnectionDetails.fromMsgpack(unpacker);
                    continue block40;
                }
                case "auth": {
                    this.auth = AuthDetails.fromMsgpack(unpacker);
                    continue block40;
                }
                case "connectionKey": {
                    unpacker.unpackString();
                    continue block40;
                }
                case "params": {
                    this.params = MessageSerializer.readStringMap(unpacker);
                    continue block40;
                }
                case "annotations": {
                    this.annotations = AnnotationSerializer.readMsgpackArray(unpacker);
                    continue block40;
                }
                case "state": {
                    ObjectsSerializer objectsSerializer = ObjectsHelper.getSerializer();
                    if (objectsSerializer != null) {
                        this.state = objectsSerializer.readMsgpackArray(unpacker);
                        continue block40;
                    }
                    Log.w(TAG, "Skipping 'state' field msgpack deserialization because ObjectsSerializer not found");
                    unpacker.skipValue();
                    continue block40;
                }
                default: {
                    Log.v(TAG, "Unexpected field: " + fieldName);
                    unpacker.skipValue();
                }
            }
        }
        return this;
    }

    static ProtocolMessage fromMsgpack(MessageUnpacker unpacker) throws IOException {
        return new ProtocolMessage().readMsgpack(unpacker);
    }

    public static enum Action {
        heartbeat,
        ack,
        nack,
        connect,
        connected,
        disconnect,
        disconnected,
        close,
        closed,
        error,
        attach,
        attached,
        detach,
        detached,
        presence,
        message,
        sync,
        auth,
        activate,
        object,
        object_sync,
        annotation;


        public int getValue() {
            return this.ordinal();
        }

        public static Action findByValue(int value) {
            return Action.values()[value];
        }
    }

    public static enum Flag {
        has_presence(0),
        has_backlog(1),
        resumed(2),
        attach_resume(5),
        has_objects(7),
        presence(16),
        publish(17),
        subscribe(18),
        presence_subscribe(19),
        annotation_publish(21),
        annotation_subscribe(22),
        object_subscribe(24),
        object_publish(25);

        private final int mask;

        private Flag(int offset) {
            this.mask = 1 << offset;
        }

        public int getMask() {
            return this.mask;
        }
    }

    public static class AuthDetails {
        public String accessToken;

        private AuthDetails() {
        }

        public AuthDetails(String s) {
            this.accessToken = s;
        }

        AuthDetails readMsgpack(MessageUnpacker unpacker) throws IOException {
            int fieldCount = unpacker.unpackMapHeader();
            block6: for (int i = 0; i < fieldCount; ++i) {
                String fieldName = unpacker.unpackString().intern();
                MessageFormat fieldFormat = unpacker.getNextFormat();
                if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                    unpacker.unpackNil();
                    continue;
                }
                switch (fieldName) {
                    case "accessToken": {
                        this.accessToken = unpacker.unpackString();
                        continue block6;
                    }
                    default: {
                        Log.v(TAG, "Unexpected field: " + fieldName);
                        unpacker.skipValue();
                    }
                }
            }
            return this;
        }

        static AuthDetails fromMsgpack(MessageUnpacker unpacker) throws IOException {
            return new AuthDetails().readMsgpack(unpacker);
        }

        void writeMsgpack(MessagePacker packer) throws IOException {
            int fieldCount = 0;
            if (this.accessToken != null) {
                ++fieldCount;
            }
            packer.packMapHeader(fieldCount);
            if (this.accessToken != null) {
                packer.packString("accessToken");
                packer.packString(this.accessToken);
            }
        }
    }

    public static class ActionSerializer
    implements JsonSerializer<Action>,
    JsonDeserializer<Action> {
        public Action deserialize(JsonElement json, Type t, JsonDeserializationContext ctx) throws JsonParseException {
            return Action.findByValue(json.getAsInt());
        }

        public JsonElement serialize(Action action, Type t, JsonSerializationContext ctx) {
            return new JsonPrimitive((Number)action.getValue());
        }
    }
}

