/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.ably.lib.types.BaseMessage;
import io.ably.lib.types.ChannelOptions;
import io.ably.lib.types.MessageAction;
import io.ably.lib.types.MessageAnnotations;
import io.ably.lib.types.MessageDecodeException;
import io.ably.lib.types.MessageExtras;
import io.ably.lib.types.MessageSerializer;
import io.ably.lib.types.MessageVersion;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class Message
extends BaseMessage {
    public String name;
    public MessageExtras extras;
    public String connectionKey;
    public String serial;
    public MessageVersion version;
    public MessageAction action;
    public MessageAnnotations annotations;
    private static final String NAME = "name";
    private static final String EXTRAS = "extras";
    private static final String CONNECTION_KEY = "connectionKey";
    private static final String SERIAL = "serial";
    private static final String VERSION = "version";
    private static final String ACTION = "action";
    private static final String ANNOTATIONS = "annotations";
    private static final String TAG = Message.class.getName();

    public Message() {
    }

    public Message(String name, Object data) {
        this(name, data, null, null);
    }

    public Message(String name, Object data, String clientId) {
        this(name, data, clientId, null);
    }

    public Message(String name, Object data, MessageExtras extras) {
        this(name, data, null, extras);
    }

    public Message(String name, Object data, String clientId, MessageExtras extras) {
        this.name = name;
        this.clientId = clientId;
        this.data = data;
        this.extras = extras;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{Message");
        super.getDetails(result);
        if (this.name != null) {
            result.append(" name=").append(this.name);
        }
        result.append('}');
        return result.toString();
    }

    void writeMsgpack(MessagePacker packer) throws IOException {
        int fieldCount = super.countFields();
        if (this.name != null) {
            ++fieldCount;
        }
        if (this.extras != null) {
            ++fieldCount;
        }
        if (this.connectionKey != null) {
            ++fieldCount;
        }
        if (this.serial != null) {
            ++fieldCount;
        }
        if (this.version != null) {
            ++fieldCount;
        }
        if (this.action != null) {
            ++fieldCount;
        }
        if (this.annotations != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        super.writeFields(packer);
        if (this.name != null) {
            packer.packString(NAME);
            packer.packString(this.name);
        }
        if (this.extras != null) {
            packer.packString(EXTRAS);
            this.extras.write(packer);
        }
        if (this.connectionKey != null) {
            packer.packString(CONNECTION_KEY);
            packer.packString(this.connectionKey);
        }
        if (this.serial != null) {
            packer.packString(SERIAL);
            packer.packString(this.serial);
        }
        if (this.version != null) {
            packer.packString(VERSION);
            this.version.writeMsgpack(packer);
        }
        if (this.action != null) {
            packer.packString(ACTION);
            packer.packInt(this.action.ordinal());
        }
        if (this.annotations != null) {
            packer.packString(ANNOTATIONS);
            this.annotations.writeMsgpack(packer);
        }
    }

    Message readMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString().intern();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            if (super.readField(unpacker, fieldName, fieldFormat)) continue;
            if (fieldName.equals(NAME)) {
                this.name = unpacker.unpackString();
                continue;
            }
            if (fieldName.equals(EXTRAS)) {
                this.extras = MessageExtras.read(unpacker);
                continue;
            }
            if (fieldName.equals(CONNECTION_KEY)) {
                this.connectionKey = unpacker.unpackString();
                continue;
            }
            if (fieldName.equals(SERIAL)) {
                this.serial = unpacker.unpackString();
                continue;
            }
            if (fieldName.equals(VERSION)) {
                this.version = MessageVersion.read(unpacker);
                continue;
            }
            if (fieldName.equals(ACTION)) {
                this.action = MessageAction.tryFindByOrdinal(unpacker.unpackInt());
                continue;
            }
            if (fieldName.equals(ANNOTATIONS)) {
                this.annotations = MessageAnnotations.read(unpacker);
                continue;
            }
            Log.v(TAG, "Unexpected field: " + fieldName);
            unpacker.skipValue();
        }
        return this;
    }

    static Message fromMsgpack(MessageUnpacker unpacker) throws IOException {
        return new Message().readMsgpack(unpacker);
    }

    public static Message fromEncoded(JsonObject messageJson, ChannelOptions channelOptions) throws MessageDecodeException {
        try {
            Message message = (Message)Serialisation.gson.fromJson((JsonElement)messageJson, Message.class);
            message.decode(channelOptions);
            return message;
        }
        catch (Exception e) {
            Log.e(Message.class.getName(), e.getMessage(), e);
            throw MessageDecodeException.fromDescription(e.getMessage());
        }
    }

    public static Message fromEncoded(String messageJson, ChannelOptions channelOptions) throws MessageDecodeException {
        try {
            JsonObject jsonObject = (JsonObject)Serialisation.gson.fromJson(messageJson, JsonObject.class);
            return Message.fromEncoded(jsonObject.getAsJsonObject(), channelOptions);
        }
        catch (Exception e) {
            Log.e(Message.class.getName(), e.getMessage(), e);
            throw MessageDecodeException.fromDescription(e.getMessage());
        }
    }

    public static Message[] fromEncodedArray(JsonArray messageArray, ChannelOptions channelOptions) throws MessageDecodeException {
        try {
            Message[] messages = new Message[messageArray.size()];
            for (int index = 0; index < messageArray.size(); ++index) {
                JsonElement jsonElement = messageArray.get(index);
                if (!jsonElement.isJsonObject()) {
                    throw new JsonParseException("Not all JSON elements are of type JSON Object.");
                }
                messages[index] = Message.fromEncoded(jsonElement.getAsJsonObject(), channelOptions);
            }
            return messages;
        }
        catch (Exception e) {
            Log.e(Message.class.getName(), e.getMessage(), e);
            throw MessageDecodeException.fromDescription(e.getMessage());
        }
    }

    public static Message[] fromEncodedArray(String messagesArray, ChannelOptions channelOptions) throws MessageDecodeException {
        try {
            JsonArray jsonArray = (JsonArray)Serialisation.gson.fromJson(messagesArray, JsonArray.class);
            return Message.fromEncodedArray(jsonArray, channelOptions);
        }
        catch (Exception e) {
            Log.e(Message.class.getName(), e.getMessage(), e);
            throw MessageDecodeException.fromDescription(e.getMessage());
        }
    }

    @Override
    protected void read(JsonObject map) throws MessageDecodeException {
        Integer actionOrdinal;
        super.read(map);
        this.name = this.readString(map, NAME);
        JsonElement extrasElement = map.get(EXTRAS);
        if (null != extrasElement) {
            if (!(extrasElement instanceof JsonObject)) {
                throw MessageDecodeException.fromDescription("Message extras is of type \"" + extrasElement.getClass() + "\" when expected a JSON object.");
            }
            this.extras = MessageExtras.read((JsonObject)extrasElement);
        }
        this.connectionKey = this.readString(map, CONNECTION_KEY);
        this.serial = this.readString(map, SERIAL);
        JsonElement versionElement = map.get(VERSION);
        if (versionElement != null) {
            this.version = MessageVersion.read(versionElement);
        }
        this.action = (actionOrdinal = this.readInt(map, ACTION)) == null ? null : MessageAction.tryFindByOrdinal(actionOrdinal);
        JsonElement annotationsElement = map.get(ANNOTATIONS);
        if (annotationsElement != null) {
            this.annotations = MessageAnnotations.read(annotationsElement);
        }
    }

    public static class Serializer
    implements JsonSerializer<Message>,
    JsonDeserializer<Message> {
        public JsonElement serialize(Message message, Type typeOfMessage, JsonSerializationContext ctx) {
            JsonObject json = BaseMessage.toJsonObject(message);
            if (message.name != null) {
                json.addProperty(Message.NAME, message.name);
            }
            if (message.extras != null) {
                json.add(Message.EXTRAS, Serialisation.gson.toJsonTree((Object)message.extras));
            }
            if (message.connectionKey != null) {
                json.addProperty(Message.CONNECTION_KEY, message.connectionKey);
            }
            if (message.serial != null) {
                json.addProperty(Message.SERIAL, message.serial);
            }
            if (message.version != null) {
                json.add(Message.VERSION, message.version.toJsonTree());
            }
            if (message.action != null) {
                json.addProperty(Message.ACTION, (Number)message.action.ordinal());
            }
            if (message.annotations != null) {
                json.add(Message.ANNOTATIONS, message.annotations.toJsonTree());
            }
            return json;
        }

        public Message deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!(json instanceof JsonObject)) {
                throw new JsonParseException("Expected an object but got \"" + json.getClass() + "\".");
            }
            Message message = new Message();
            try {
                message.read((JsonObject)json);
            }
            catch (MessageDecodeException e) {
                Log.e(Message.class.getName(), e.getMessage(), e);
                throw new JsonParseException("Failed to deserialize Message from JSON.", (Throwable)e);
            }
            return message;
        }
    }

    public static class Batch {
        public String[] channels;
        public Message[] messages;

        public Batch(String channel, Message[] messages) {
            if (channel == null || channel.isEmpty()) {
                throw new IllegalArgumentException("A Batch spec cannot have an empty set of channels");
            }
            if (messages == null || messages.length == 0) {
                throw new IllegalArgumentException("A Batch spec cannot have an empty set of messages");
            }
            this.channels = new String[]{channel};
            this.messages = messages;
        }

        public Batch(String[] channels, Message[] messages) {
            if (channels == null || channels.length == 0) {
                throw new IllegalArgumentException("A Batch spec cannot have an empty set of channels");
            }
            if (messages == null || messages.length == 0) {
                throw new IllegalArgumentException("A Batch spec cannot have an empty set of messages");
            }
            this.channels = channels;
            this.messages = messages;
        }

        public Batch(Collection<String> channels, Collection<Message> messages) {
            this(channels.toArray(new String[0]), messages.toArray(new Message[0]));
        }

        public void writeMsgpack(MessagePacker packer) throws IOException {
            packer.packMapHeader(2);
            packer.packString("channels");
            packer.packArrayHeader(this.channels.length);
            for (String ch : this.channels) {
                packer.packString(ch);
            }
            packer.packString("messages");
            MessageSerializer.writeMsgpackArray(this.messages, packer);
        }
    }
}

