/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class Stats {
    private static String[] intervalFormatString = new String[]{"yyyy-MM-dd:hh:mm", "yyyy-MM-dd:hh", "yyyy-MM-dd", "yyyy-MM"};
    public String intervalId;
    public String unit;
    public MessageTypes all;
    public MessageTraffic inbound;
    public MessageTraffic outbound;
    public MessageTypes persisted;
    public ConnectionTypes connections;
    public ResourceCount channels;
    public RequestCount apiRequests;
    public RequestCount tokenRequests;
    public ProcessedMessages processed;

    public static String toIntervalId(long timestamp, Granularity granularity) {
        String formatString = intervalFormatString[granularity.ordinal()];
        return new SimpleDateFormat(formatString).format(new Date(timestamp));
    }

    public static long fromIntervalId(String intervalId) {
        try {
            String formatString = intervalFormatString[0].substring(0, intervalId.length());
            return new SimpleDateFormat(formatString).parse(intervalId).getTime();
        }
        catch (ParseException e) {
            return 0L;
        }
    }

    public static enum Granularity {
        minute,
        hour,
        day,
        month;

    }

    public static class ProcessedMessages {
        public Map<String, ProcessedCount> delta;
    }

    public static class ProcessedCount {
        public double succeeded;
        public double skipped;
        public double failed;
    }

    public static class ResourceCount {
        public double opened;
        public double peak;
        public double mean;
        public double min;
        public double refused;
    }

    public static class RequestCount {
        public double succeeded;
        public double failed;
        public double refused;
    }

    public static class MessageTraffic {
        public MessageTypes all;
        public MessageTypes realtime;
        public MessageTypes rest;
        public MessageTypes webhook;
    }

    public static class MessageTypes {
        public MessageCategory all;
        public MessageCategory messages;
        public MessageCategory presence;
    }

    public static class MessageCategory
    extends MessageCount {
        public Map<String, MessageCount> category;
    }

    public static class MessageCount {
        public double count;
        public double data;
        public double uncompressedData;
    }

    public static class ConnectionTypes {
        public ResourceCount all;
        public ResourceCount plain;
        public ResourceCount tls;
    }
}

