/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.util;

import io.ably.lib.types.AblyException;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import io.ably.lib.util.Base64Coder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    public static final String DEFAULT_ALGORITHM = "aes";
    public static final int DEFAULT_KEYLENGTH = Crypto.is256BitsSupported() ? 256 : 128;
    public static final int DEFAULT_BLOCKLENGTH = 16;
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final String TAG = Crypto.class.getName();

    public static CipherParams getDefaultParams() {
        return Crypto.getParams(DEFAULT_ALGORITHM, DEFAULT_KEYLENGTH);
    }

    public static CipherParams getDefaultParams(byte[] key) {
        try {
            return Crypto.getParams(DEFAULT_ALGORITHM, key);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    static CipherParams getDefaultParams(byte[] key, byte[] iv) throws NoSuchAlgorithmException {
        return new CipherParams(DEFAULT_ALGORITHM, key, iv);
    }

    public static CipherParams getDefaultParams(String base64Key) {
        return Crypto.getDefaultParams(Base64Coder.decode(base64Key));
    }

    static CipherParams getDefaultParams(String base64Key, byte[] iv) throws NoSuchAlgorithmException {
        return new CipherParams(null, Base64Coder.decode(base64Key), iv);
    }

    public static CipherParams getParams(String algorithm, int keyLength) {
        if (algorithm == null) {
            algorithm = DEFAULT_ALGORITHM;
        }
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(algorithm.toUpperCase(Locale.ROOT));
            keygen.init(keyLength);
            byte[] key = keygen.generateKey().getEncoded();
            return Crypto.getParams(algorithm, key);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static CipherParams getParams(String algorithm, byte[] key) throws NoSuchAlgorithmException {
        byte[] ivBytes = new byte[16];
        secureRandom.nextBytes(ivBytes);
        return Crypto.getParams(algorithm, key, ivBytes);
    }

    public static CipherParams getParams(String algorithm, byte[] key, byte[] iv) throws NoSuchAlgorithmException {
        return new CipherParams(algorithm, key, iv);
    }

    public static byte[] generateRandomKey(int keyLength) {
        byte[] result = new byte[(keyLength + 7) / 8];
        secureRandom.nextBytes(result);
        return result;
    }

    public static byte[] generateRandomKey() {
        return Crypto.generateRandomKey(DEFAULT_KEYLENGTH);
    }

    public static EncryptingChannelCipher createChannelEncipher(CipherParams cipherParams) throws AblyException {
        return new EncryptingCBCCipher(cipherParams);
    }

    public static DecryptingChannelCipher createChannelDecipher(CipherParams cipherParams) throws AblyException {
        return new DecryptingCBCCipher(cipherParams);
    }

    public static CipherParams checkCipherParams(Object cipherParams) throws AblyException {
        if (null == cipherParams) {
            return Crypto.getDefaultParams();
        }
        if (cipherParams instanceof CipherParams) {
            return (CipherParams)cipherParams;
        }
        throw AblyException.fromErrorInfo(new ErrorInfo("ChannelOptions not supported", 400, 40000));
    }

    public static String getRandomId() {
        byte[] entropy = new byte[9];
        secureRandom.nextBytes(entropy);
        return Base64Coder.encodeToString(entropy);
    }

    public static Param generateRandomRequestId() {
        return new Param("request_id", Crypto.getRandomId());
    }

    private static boolean is256BitsSupported() {
        try {
            return Cipher.getMaxAllowedKeyLength(DEFAULT_ALGORITHM) >= 256;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public static class CipherParams {
        private final String algorithm;
        private final int keyLength;
        private final SecretKeySpec keySpec;
        private final IvParameterSpec ivSpec;

        CipherParams(String algorithm, byte[] key, byte[] iv) throws NoSuchAlgorithmException {
            this.algorithm = null == algorithm ? Crypto.DEFAULT_ALGORITHM : algorithm;
            this.keyLength = key.length * 8;
            this.keySpec = new SecretKeySpec(key, this.algorithm.toUpperCase(Locale.ROOT));
            this.ivSpec = new IvParameterSpec(iv);
        }

        int getKeyLength() {
            return this.keyLength;
        }

        String getAlgorithm() {
            return this.algorithm;
        }
    }

    private static class EncryptingCBCCipher
    extends CBCCipher
    implements EncryptingChannelCipher {
        private byte[] iv;
        private static final byte[] emptyBlock = new byte[16];
        private static final byte[][] pkcs5Padding = new byte[][]{{16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16}, {1}, {2, 2}, {3, 3, 3}, {4, 4, 4, 4}, {5, 5, 5, 5, 5}, {6, 6, 6, 6, 6, 6}, {7, 7, 7, 7, 7, 7, 7}, {8, 8, 8, 8, 8, 8, 8, 8}, {9, 9, 9, 9, 9, 9, 9, 9, 9}, {10, 10, 10, 10, 10, 10, 10, 10, 10, 10}, {11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11}, {12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12}, {13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13}, {14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15}, {16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16}};

        EncryptingCBCCipher(CipherParams params) throws AblyException {
            super(params);
            try {
                this.cipher.init(1, (Key)this.keySpec, this.ivSpec);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
                throw AblyException.fromThrowable(e);
            }
            this.iv = params.ivSpec.getIV();
        }

        @Override
        public String getAlgorithm() {
            return this.algorithm;
        }

        private static int getPaddedLength(int plaintextLength) {
            return plaintextLength + 16 & 0xFFFFFFF0;
        }

        private byte[] getNextIv() {
            if (this.iv == null) {
                return this.cipher.update(emptyBlock);
            }
            byte[] result = this.iv;
            this.iv = null;
            return result;
        }

        @Override
        public byte[] encrypt(byte[] plaintext) {
            if (plaintext == null) {
                return null;
            }
            int plaintextLength = plaintext.length;
            int paddedLength = EncryptingCBCCipher.getPaddedLength(plaintextLength);
            byte[] cipherIn = new byte[paddedLength];
            byte[] ciphertext = new byte[paddedLength + this.blockLength];
            int padding = paddedLength - plaintextLength;
            System.arraycopy(plaintext, 0, cipherIn, 0, plaintextLength);
            System.arraycopy(pkcs5Padding[padding], 0, cipherIn, plaintextLength, padding);
            System.arraycopy(this.getNextIv(), 0, ciphertext, 0, this.blockLength);
            byte[] cipherOut = this.cipher.update(cipherIn);
            System.arraycopy(cipherOut, 0, ciphertext, this.blockLength, paddedLength);
            return ciphertext;
        }
    }

    private static class DecryptingCBCCipher
    extends CBCCipher
    implements DecryptingChannelCipher {
        DecryptingCBCCipher(CipherParams params) throws AblyException {
            super(params);
        }

        @Override
        public byte[] decrypt(byte[] ciphertext) throws AblyException {
            if (ciphertext == null) {
                return null;
            }
            try {
                this.cipher.init(2, (Key)this.keySpec, new IvParameterSpec(ciphertext, 0, this.blockLength));
                return this.cipher.doFinal(ciphertext, this.blockLength, ciphertext.length - this.blockLength);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
                throw AblyException.fromThrowable(e);
            }
        }
    }

    private static class CBCCipher {
        protected final SecretKeySpec keySpec;
        protected final IvParameterSpec ivSpec;
        protected final Cipher cipher;
        protected final int blockLength;
        protected final String algorithm;

        protected CBCCipher(CipherParams params) throws AblyException {
            String cipherAlgorithm = params.getAlgorithm();
            String transformation = cipherAlgorithm.toUpperCase(Locale.ROOT) + "/CBC/PKCS5Padding";
            try {
                this.algorithm = cipherAlgorithm + '-' + params.getKeyLength() + "-cbc";
                this.keySpec = params.keySpec;
                this.ivSpec = params.ivSpec;
                this.blockLength = this.ivSpec.getIV().length;
                this.cipher = Cipher.getInstance(transformation);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw AblyException.fromThrowable(e);
            }
        }
    }

    public static interface DecryptingChannelCipher {
        public byte[] decrypt(byte[] var1) throws AblyException;
    }

    public static interface EncryptingChannelCipher {
        public byte[] encrypt(byte[] var1) throws AblyException;

        public String getAlgorithm();
    }
}

