/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.util;

import io.ably.lib.transport.Defaults;
import io.ably.lib.util.PlatformAgentProvider;
import java.util.Map;

public class AgentHeaderCreator {
    private static final String AGENT_ENTRY_SEPARATOR = " ";
    public static final String AGENT_DIVIDER = "/";

    public static String create(Map<String, String> additionalAgents, PlatformAgentProvider platformAgentProvider) {
        String platformAgent;
        StringBuilder agentStringBuilder = new StringBuilder();
        agentStringBuilder.append(Defaults.ABLY_AGENT_VERSION);
        if (additionalAgents != null && !additionalAgents.isEmpty()) {
            agentStringBuilder.append(AGENT_ENTRY_SEPARATOR);
            agentStringBuilder.append(AgentHeaderCreator.getAdditionalAgentEntries(additionalAgents));
        }
        if ((platformAgent = platformAgentProvider.createPlatformAgent()) != null) {
            agentStringBuilder.append(AGENT_ENTRY_SEPARATOR);
            agentStringBuilder.append(platformAgent);
        }
        return agentStringBuilder.toString();
    }

    private static String getAdditionalAgentEntries(Map<String, String> additionalAgents) {
        StringBuilder additionalAgentsBuilder = new StringBuilder();
        for (String additionalAgentName : additionalAgents.keySet()) {
            String additionalAgentVersion = additionalAgents.get(additionalAgentName);
            additionalAgentsBuilder.append(additionalAgentName);
            if (additionalAgentVersion != null) {
                additionalAgentsBuilder.append(AGENT_DIVIDER);
                additionalAgentsBuilder.append(additionalAgentVersion);
            }
            additionalAgentsBuilder.append(AGENT_ENTRY_SEPARATOR);
        }
        return additionalAgentsBuilder.toString().trim();
    }
}

