/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.types.AblyException;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.util.Base64Coder;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class HttpAuth {
    private static final String HEX_LOOKUP = "0123456789abcdef";
    private static MessageDigest md5 = null;
    private String realm;
    private String nonce;
    private String[] qops;
    private String opaque;
    private Type type;
    private int ncCounter = 1;
    private String HA1;
    private final String username;
    private final String password;
    private final Type prefType;

    HttpAuth(String username, String password, Type prefType) {
        this.username = username;
        this.password = password;
        this.prefType = prefType;
    }

    boolean hasChallenge() {
        return this.type != null;
    }

    public static Map<Type, String> sortAuthenticateHeaders(Collection<String> authenticateHeaders) throws AblyException {
        HashMap<Type, String> sortedHeaders = new HashMap<Type, String>();
        for (String header : authenticateHeaders) {
            int delimiterIdx = header.indexOf(32);
            if (delimiterIdx == -1) {
                throw AblyException.fromErrorInfo(new ErrorInfo("Invalid authenticate header (no delimiter)", 40000, 400));
            }
            String authType = header.substring(0, delimiterIdx).trim();
            String authDetails = header.substring(delimiterIdx + 1).trim();
            sortedHeaders.put(Type.valueOf(authType.toUpperCase().replace('-', '_')), authDetails);
        }
        return sortedHeaders;
    }

    public String getAuthorizationHeader(String method, String uri, byte[] requestBody) throws AblyException {
        switch (this.type) {
            case BASIC: {
                return "Basic " + Base64Coder.encodeString(this.username + ':' + this.password);
            }
            case DIGEST: {
                return this.getDigestHeader(method, uri, requestBody);
            }
        }
        return null;
    }

    public void processAuthenticateHeaders(Map<Type, String> authenticateHeaders) throws AblyException {
        this.type = this.prefType;
        String authDetails = authenticateHeaders.get((Object)this.type);
        if (authDetails == null) {
            Map.Entry<Type, String> firstEntry = authenticateHeaders.entrySet().iterator().next();
            if (firstEntry == null) {
                throw AblyException.fromErrorInfo(new ErrorInfo("Invalid authenticate header (no entries)", 40000, 400));
            }
            this.type = firstEntry.getKey();
            authDetails = firstEntry.getValue();
        }
        if (this.type == Type.DIGEST) {
            this.processDigestHeader(authDetails);
        }
    }

    private synchronized void processDigestHeader(String detailsString) throws AblyException {
        HashMap<String, String> authFields = HttpAuth.splitAuthFields(detailsString);
        this.realm = authFields.get("realm");
        this.nonce = authFields.get("nonce");
        this.opaque = authFields.get("opaque");
        this.HA1 = HttpAuth.digestString(this.username + ':' + this.realm + ':' + this.password);
        String qopStr = authFields.get("qop");
        if (qopStr != null) {
            this.qops = qopStr.split(",");
        }
    }

    private String getDigestHeader(String method, String uri, byte[] requestBody) throws AblyException {
        String HA3;
        String HA2;
        String qop = null;
        if (this.qops != null) {
            for (String candidateQop : this.qops) {
                if (requestBody != null && candidateQop.trim().equals("auth-int")) {
                    qop = "auth-int";
                    break;
                }
                if (!candidateQop.trim().equals("auth")) continue;
                qop = "auth";
                break;
            }
        }
        String nc = null;
        String cnonce = null;
        if (qop == null) {
            HA2 = HttpAuth.digestString(method + ':' + uri);
            HA3 = HttpAuth.digestString(this.HA1 + ':' + this.nonce + ':' + HA2);
        } else if (qop.equals("auth")) {
            nc = String.format("%08X", this.ncCounter++);
            cnonce = HttpAuth.getClientNonce();
            HA2 = HttpAuth.digestString(method + ':' + uri);
            HA3 = HttpAuth.digestString(this.HA1 + ':' + this.nonce + ':' + nc + ':' + cnonce + ':' + qop + ':' + HA2);
        } else {
            nc = String.format("%08X", this.ncCounter++);
            cnonce = HttpAuth.getClientNonce();
            HA2 = HttpAuth.digestString(method + ':' + uri + ':' + HttpAuth.digestBytes(requestBody));
            HA3 = HttpAuth.digestString(this.HA1 + ':' + this.nonce + ':' + nc + ':' + cnonce + ':' + qop + ':' + HA2);
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("Digest ");
        sb.append("username").append("=\"").append(this.username).append("\",");
        sb.append("realm").append("=\"").append(this.realm).append("\",");
        sb.append("nonce").append("=\"").append(this.nonce).append("\",");
        sb.append("uri").append("=\"").append(uri).append("\",");
        sb.append("algorithm").append("=\"").append("MD5").append("\",");
        if (qop != null) {
            sb.append("qop").append("=\"").append(qop).append("\",");
            sb.append("nc").append("=").append(nc).append(",");
            sb.append("cnonce").append("=\"").append(cnonce).append("\",");
        }
        if (this.opaque != null) {
            sb.append("response").append("=\"").append(HA3).append("\",");
            sb.append("opaque").append("=\"").append(this.opaque).append("\"");
        } else {
            sb.append("response").append("=\"").append(HA3).append("\"");
        }
        return sb.toString();
    }

    private static HashMap<String, String> splitAuthFields(String detailsString) {
        String[] keyValueArray;
        HashMap<String, String> values = new HashMap<String, String>();
        for (String keyval : keyValueArray = detailsString.split(",")) {
            if (!keyval.contains("=")) continue;
            String key = keyval.substring(0, keyval.indexOf("="));
            String value = keyval.substring(keyval.indexOf("=") + 1);
            values.put(key.trim(), value.replaceAll("\"", "").trim());
        }
        return values;
    }

    private static String digestBytes(byte[] buf) {
        md5.reset();
        md5.update(buf);
        byte[] ha1bytes = md5.digest();
        return HttpAuth.bytesToHexString(ha1bytes);
    }

    private static String digestString(String text) {
        try {
            return HttpAuth.digestBytes(text.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(HEX_LOOKUP.charAt((bytes[i] & 0xF0) >> 4));
            sb.append(HEX_LOOKUP.charAt((bytes[i] & 0xF) >> 0));
        }
        return sb.toString();
    }

    private static String getClientNonce() {
        String fmtDate = new SimpleDateFormat("yyyy:MM:dd:hh:mm:ss").format(new Date());
        Integer randomInt = new Random(100000L).nextInt();
        return HttpAuth.digestString(fmtDate + randomInt.toString()).substring(0, 8);
    }

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public static enum Type {
        BASIC,
        DIGEST,
        X_ABLY_TOKEN;

    }
}

