/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.types;

import com.google.gson.JsonElement;
import io.ably.lib.types.DeltaExtras;
import io.ably.lib.util.Log;
import io.ably.lib.util.Serialisation;
import java.io.IOException;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public final class MessageExtras {
    private static final String TAG = MessageExtras.class.getName();
    private final DeltaExtras delta;

    public MessageExtras(DeltaExtras delta) {
        this.delta = delta;
    }

    public DeltaExtras getDelta() {
        return this.delta;
    }

    JsonElement toJsonElement() {
        return Serialisation.gson.toJsonTree((Object)this);
    }

    void writeMsgpack(MessagePacker packer) throws IOException {
        int fieldCount = 0;
        if (this.delta != null) {
            ++fieldCount;
        }
        packer.packMapHeader(fieldCount);
        if (this.delta != null) {
            packer.packString("delta");
            this.delta.writeMsgpack(packer);
        }
    }

    static MessageExtras fromMsgpack(MessageUnpacker unpacker) throws IOException {
        int fieldCount = unpacker.unpackMapHeader();
        DeltaExtras delta = null;
        for (int i = 0; i < fieldCount; ++i) {
            String fieldName = unpacker.unpackString();
            MessageFormat fieldFormat = unpacker.getNextFormat();
            if (fieldFormat.equals((Object)MessageFormat.NIL)) {
                unpacker.unpackNil();
                continue;
            }
            if (fieldName.equals("delta")) {
                delta = DeltaExtras.fromMsgpack(unpacker);
                continue;
            }
            Log.w(TAG, "Unexpected field: " + fieldName);
            unpacker.skipValue();
        }
        return new MessageExtras(delta);
    }
}

