/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.http.HttpCore;
import io.ably.lib.http.HttpScheduler;
import io.ably.lib.types.ClientOptions;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncHttpScheduler
extends HttpScheduler<ThreadPoolExecutor> {
    private static final long KEEP_ALIVE_TIME = 2000L;
    private static final long SHUTDOWN_TIME = 5000L;
    protected static final String TAG = AsyncHttpScheduler.class.getName();

    public AsyncHttpScheduler(HttpCore httpCore, ClientOptions options) {
        super(httpCore, new ThreadPoolExecutor(options.asyncHttpThreadpoolSize, options.asyncHttpThreadpoolSize, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
        ((ThreadPoolExecutor)this.executor).allowsCoreThreadTimeOut();
    }

    public void dispose() {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executor;
        threadPoolExecutor.shutdown();
        try {
            threadPoolExecutor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            threadPoolExecutor.shutdownNow();
        }
    }
}

