/*
 * Decompiled with CFR 0.152.
 */
package info.vividcode.android.cra.components;

import android.support.v7.widget.RecyclerView;
import info.vividcode.android.cra.Component;
import info.vividcode.android.cra.ComponentsRecyclerAdapter;
import info.vividcode.android.cra.components.ChildComponentItemCallback;
import info.vividcode.android.cra.components.ChildComponentItemCallbacks;
import info.vividcode.android.cra.components.OffsettingBypassObserver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ComponentSeries
implements Component {
    private final ComponentsRecyclerAdapter.ComponentObservable mObservable = new ComponentsRecyclerAdapter.ComponentObservable(this);
    private final List<Component<?>> mComponents = new ArrayList();
    private final ComponentsRecyclerAdapter.ComponentObserver mChildComponentsObserver = new OffsettingBypassObserver(this.mObservable){

        @Override
        protected int calcOffsetCount(Component dc) {
            Component component;
            int offsetCount = 0;
            Iterator iterator = ComponentSeries.this.mComponents.iterator();
            while (iterator.hasNext() && dc != (component = (Component)iterator.next())) {
                offsetCount += component.getItemCount();
            }
            return offsetCount;
        }
    };

    public static ComponentSeries createWithChildComponents(List<? extends Component<?>> components) {
        ComponentSeries cs = new ComponentSeries();
        for (Component<?> c : components) {
            cs.addChildComponent(c);
        }
        return cs;
    }

    public int numberOfChildComponents() {
        return this.mComponents.size();
    }

    public void addChildComponent(Component<?> dc) {
        int insertedPosition = this.getItemCount();
        int insertedCount = dc.getItemCount();
        this.mComponents.add(dc);
        this.mObservable.notifyItemRangeInserted(insertedPosition, insertedCount);
        dc.getObservable().registerObserver(this.mChildComponentsObserver);
    }

    @Override
    public ComponentsRecyclerAdapter.ComponentObservable getObservable() {
        return this.mObservable;
    }

    <A, R> R callBackForChildComponentItem(int positionInThisComponent, ChildComponentItemCallback<A, R> c, A arg) {
        if (positionInThisComponent < 0) {
            throw new IndexOutOfBoundsException("Position must be greater than or equal to zero. (Specified position: " + positionInThisComponent + ")");
        }
        int filteredPos = positionInThisComponent;
        for (Component<?> dc : this.mComponents) {
            int count = dc.getItemCount();
            if (filteredPos < count) {
                return c.onChildComponentAndPositionFound(dc, filteredPos, arg);
            }
            filteredPos -= count;
        }
        throw new IndexOutOfBoundsException("Position must be smaller than " + this.getItemCount() + ". " + "(Specified position: " + positionInThisComponent + ")");
    }

    @Override
    public int getItemCount() {
        int itemCount = 0;
        for (Component<?> dc : this.mComponents) {
            itemCount += dc.getItemCount();
        }
        return itemCount;
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int positionInThisComponent) {
        this.callBackForChildComponentItem(positionInThisComponent, ChildComponentItemCallbacks.CC_ON_BIND_VIEW_HOLDER, holder);
    }

    @Override
    public int getItemViewType(int positionInThisComponent) {
        return this.callBackForChildComponentItem(positionInThisComponent, ChildComponentItemCallbacks.CC_GET_ITEM_VIEW_TYPE, ChildComponentItemCallbacks.VOID);
    }

    public Object getItem(int positionInThisComponent) {
        return this.callBackForChildComponentItem(positionInThisComponent, ChildComponentItemCallbacks.CC_GET_ITEM, ChildComponentItemCallbacks.VOID);
    }
}

