/*
 * Decompiled with CFR 0.152.
 */
package info.vividcode.android.cra;

import android.database.Observable;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import info.vividcode.android.cra.Component;
import info.vividcode.android.cra.ViewHolderFactory;
import info.vividcode.android.cra.ViewHolderFactoryRegistry;

public class ComponentsRecyclerAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final ViewHolderFactoryRegistry mViewHolderFactoryRegistry;
    private Component<?> mComponent;

    public ComponentsRecyclerAdapter(ViewHolderFactoryRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("ViewHolderFactoryRegistry must not be null.");
        }
        this.mViewHolderFactoryRegistry = registry;
    }

    public Component<?> getComponent() {
        return this.mComponent;
    }

    public void setComponent(Component<?> dc) {
        if (this.mComponent != null) {
            int oldCount = this.mComponent.getItemCount();
            this.mComponent = null;
            this.notifyItemRangeRemoved(0, oldCount);
        }
        this.mComponent = dc;
        this.notifyItemRangeInserted(0, this.mComponent.getItemCount());
        this.mComponent.getObservable().registerObserver(new ComponentObserver(){

            @Override
            public void onChanged(Component dc) {
                ComponentsRecyclerAdapter.this.notifyDataSetChanged();
            }

            @Override
            public void onItemRangeChanged(Component dc, int positionStart, int itemCount) {
                ComponentsRecyclerAdapter.this.notifyItemRangeChanged(positionStart, itemCount);
            }

            @Override
            public void onItemRangeInserted(Component dc, int positionStart, int itemCount) {
                ComponentsRecyclerAdapter.this.notifyItemRangeInserted(positionStart, itemCount);
            }

            @Override
            public void onItemRangeRemoved(Component dc, int positionStart, int itemCount) {
                ComponentsRecyclerAdapter.this.notifyItemRangeRemoved(positionStart, itemCount);
            }

            @Override
            public void onItemMoved(Component dc, int fromPosition, int toPosition) {
                ComponentsRecyclerAdapter.this.notifyItemMoved(fromPosition, toPosition);
            }
        });
    }

    public final RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ViewHolderFactory<?> factory = this.mViewHolderFactoryRegistry.getFactory(viewType);
        return factory.createViewHolder(parent);
    }

    public final void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (this.mComponent == null) {
            throw new RuntimeException("`onBindViewHolder` cannot be called when there is no component.");
        }
        this.mComponent.onBindViewHolder(holder, position);
    }

    public final int getItemCount() {
        return this.mComponent != null ? this.mComponent.getItemCount() : 0;
    }

    public final int getItemViewType(int position) {
        if (this.mComponent == null) {
            throw new RuntimeException("`getItemViewType` cannot be called when there is no component.");
        }
        return this.mComponent.getItemViewType(position);
    }

    public static class ComponentObservable
    extends Observable<ComponentObserver> {
        private final Component mOwner;

        public ComponentObservable(Component owner) {
            this.mOwner = owner;
        }

        public void notifyChanged() {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((ComponentObserver)this.mObservers.get(i)).onChanged(this.mOwner);
            }
        }

        public void notifyItemRangeChanged(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((ComponentObserver)this.mObservers.get(i)).onItemRangeChanged(this.mOwner, positionStart, itemCount);
            }
        }

        public void notifyItemRangeInserted(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((ComponentObserver)this.mObservers.get(i)).onItemRangeInserted(this.mOwner, positionStart, itemCount);
            }
        }

        public void notifyItemRangeRemoved(int positionStart, int itemCount) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((ComponentObserver)this.mObservers.get(i)).onItemRangeRemoved(this.mOwner, positionStart, itemCount);
            }
        }

        public void notifyItemMoved(int fromPosition, int toPosition) {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((ComponentObserver)this.mObservers.get(i)).onItemMoved(this.mOwner, fromPosition, toPosition);
            }
        }
    }

    public static interface ComponentObserver {
        public void onChanged(Component var1);

        public void onItemRangeChanged(Component var1, int var2, int var3);

        public void onItemRangeInserted(Component var1, int var2, int var3);

        public void onItemRangeRemoved(Component var1, int var2, int var3);

        public void onItemMoved(Component var1, int var2, int var3);
    }
}

