/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.aot.graalvm;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import picocli.codegen.aot.graalvm.OutputFileMixin;
import picocli.codegen.aot.graalvm.ReflectionConfigGenerator;

public class JniConfigGenerator {
    public static void main(String ... args) {
        App app = new App();
        int exitCode = new CommandLine((Object)app).execute(args);
        if (app.exit) {
            System.exit(exitCode);
        }
    }

    private static StringBuilder generateJniConfig(Class<?>[] classes) {
        List<ReflectionConfigGenerator.ReflectedClass> visited = JniConfigGenerator.visit(classes);
        StringBuilder result = new StringBuilder(1024);
        String prefix = String.format("[%n", new Object[0]);
        String suffix = String.format("%n]%n", new Object[0]);
        for (ReflectionConfigGenerator.ReflectedClass cls : visited) {
            result.append(prefix).append(cls);
            prefix = String.format(",%n", new Object[0]);
        }
        return result.append(suffix);
    }

    private static List<ReflectionConfigGenerator.ReflectedClass> visit(Class<?>[] classes) {
        ArrayList<ReflectionConfigGenerator.ReflectedClass> result = new ArrayList<ReflectionConfigGenerator.ReflectedClass>();
        for (Class<?> cls : classes) {
            JniConfigGenerator.visit(cls, result);
        }
        return result;
    }

    private static void visit(Class<?> cls, List<ReflectionConfigGenerator.ReflectedClass> result) {
        ReflectionConfigGenerator.ReflectedClass reflected = new ReflectionConfigGenerator.ReflectedClass(cls.getName());
        result.add(reflected);
        for (Method method : cls.getDeclaredMethods()) {
            reflected.addMethod(method);
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
            reflected.addField((Field)accessibleObject);
        }
        for (AnnotatedElement annotatedElement : cls.getDeclaredClasses()) {
            JniConfigGenerator.visit(annotatedElement, result);
        }
    }

    @CommandLine.Command(name="gen-jni-config", showAtFileInUsageHelp=true, description={"Generates a JSON file with the program elements that will be accessed reflectively from native code.", "The generated JSON file can be passed to the `-H:JNIConfigurationFiles=/path/to/jni-config.json` option of the `native-image` GraalVM utility.", "See https://www.graalvm.org/reference-manual/native-image/JNI/"}, exitCodeListHeading="%nExit Codes (if enabled with `--exit`)%n", exitCodeList={"0:Successful program execution.", "1:A runtime exception occurred while generating man pages.", "2:Usage error: user input for the command was incorrect, e.g., the wrong number of arguments, a bad flag, a bad syntax in a parameter, etc."}, footerHeading="%nExample%n", footer={"  java -cp \"myapp.jar;picocli-4.7.3-SNAPSHOT.jar;picocli-codegen-4.7.3-SNAPSHOT.jar\" picocli.codegen.aot.graalvm.JniConfigGenerator my.pkg.MyClass"}, mixinStandardHelpOptions=true, sortOptions=false, version={"picocli-codegen ${COMMAND-NAME} 4.7.3-SNAPSHOT"})
    private static class App
    implements Callable<Integer> {
        @CommandLine.Parameters(arity="1..*", description={"One or more classes to generate a GraalVM JNI configuration for."})
        Class<?>[] classes = new Class[0];
        @CommandLine.Mixin
        OutputFileMixin outputFile = new OutputFileMixin();
        @CommandLine.Option(names={"--exit"}, negatable=true, description={"Specify `--exit` if you want the application to call `System.exit` when finished. By default, `System.exit` is not called."})
        boolean exit;

        private App() {
        }

        @Override
        public Integer call() throws Exception {
            String result = JniConfigGenerator.generateJniConfig(this.classes).toString();
            this.outputFile.write(result);
            return 0;
        }
    }
}

