/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.aot.graalvm;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import picocli.codegen.aot.graalvm.OutputFileMixin;
import picocli.codegen.aot.graalvm.ReflectionConfigGenerator;

public class JniConfigGenerator {
    public static void main(String ... args) {
        new CommandLine((Object)new App()).execute(args);
    }

    private static StringBuilder generateReflectionConfig(Class<?>[] classes) {
        List<ReflectionConfigGenerator.ReflectedClass> visited = JniConfigGenerator.visit(classes);
        StringBuilder result = new StringBuilder(1024);
        String prefix = String.format("[%n", new Object[0]);
        String suffix = String.format("%n]%n", new Object[0]);
        for (ReflectionConfigGenerator.ReflectedClass cls : visited) {
            result.append(prefix).append(cls);
            prefix = String.format(",%n", new Object[0]);
        }
        return result.append(suffix);
    }

    private static List<ReflectionConfigGenerator.ReflectedClass> visit(Class<?>[] classes) {
        ArrayList<ReflectionConfigGenerator.ReflectedClass> result = new ArrayList<ReflectionConfigGenerator.ReflectedClass>();
        for (Class<?> cls : classes) {
            JniConfigGenerator.visit(cls, result);
        }
        return result;
    }

    private static void visit(Class<?> cls, List<ReflectionConfigGenerator.ReflectedClass> result) {
        ReflectionConfigGenerator.ReflectedClass reflected = new ReflectionConfigGenerator.ReflectedClass(cls.getName());
        result.add(reflected);
        for (Method method : cls.getDeclaredMethods()) {
            reflected.addMethod(method);
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
            reflected.addField((Field)accessibleObject);
        }
        for (AnnotatedElement annotatedElement : cls.getDeclaredClasses()) {
            JniConfigGenerator.visit(annotatedElement, result);
        }
    }

    @CommandLine.Command(name="gen-jni-config", description={"Generates a JSON file with the program elements that will be accessed reflectively from native code. The generated JSON file can be passed to the -H:JNIConfigurationFiles=/path/to/jni-config.json option of the `native-image` GraalVM utility.", "See https://github.com/oracle/graal/blob/master/substratevm/JNI.md"}, mixinStandardHelpOptions=true, version={"picocli-codegen ${COMMAND-NAME} 4.1.4"})
    private static class App
    implements Callable<Integer> {
        @CommandLine.Parameters(arity="1..*", description={"One or more classes to generate a GraalVM JNI configuration for."})
        Class<?>[] classes = new Class[0];
        @CommandLine.Mixin
        OutputFileMixin outputFile = new OutputFileMixin();

        private App() {
        }

        @Override
        public Integer call() throws Exception {
            String result = JniConfigGenerator.generateReflectionConfig(this.classes).toString();
            this.outputFile.write(result);
            return 0;
        }
    }
}

