/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.annotation.processing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor6;
import picocli.CommandLine;

class CompileTimeTypeInfo
implements CommandLine.Model.ITypeInfo {
    private static Logger logger = Logger.getLogger(CompileTimeTypeInfo.class.getName());
    private static final EnumSet<TypeKind> PRIMITIVES = EnumSet.of(TypeKind.BYTE, new TypeKind[]{TypeKind.BOOLEAN, TypeKind.CHAR, TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT});
    final TypeMirror typeMirror;
    final List<? extends TypeMirror> auxTypeMirrors;
    final List<String> actualGenericTypeArguments;
    final TypeElement typeElement;
    final boolean isCollection;
    final boolean isMap;

    public CompileTimeTypeInfo(TypeMirror asType) {
        this.typeMirror = asType;
        List<TypeMirror> aux = Arrays.asList(this.typeMirror);
        TypeElement tempTypeElement = null;
        boolean collection = false;
        boolean map = false;
        if (this.typeMirror.getKind() == TypeKind.DECLARED) {
            logger.finest("CompileTimeTypeInfo DECLARED typeMirror " + this.typeMirror);
            Element element = ((DeclaredType)this.typeMirror).asElement();
            if (element.getKind().isClass() || element.getKind().isInterface()) {
                tempTypeElement = (TypeElement)element;
                logger.finest("element is class or interface " + tempTypeElement);
                map = CompileTimeTypeInfo.find("java.util.Map", tempTypeElement);
                collection = !map && CompileTimeTypeInfo.find("java.util.Collection", tempTypeElement);
            }
            aux = ((DeclaredType)this.typeMirror).getTypeArguments();
            this.actualGenericTypeArguments = new ArrayList<String>();
            for (TypeMirror typeMirror : aux) {
                this.actualGenericTypeArguments.add(typeMirror.toString());
            }
            logger.finest("aux (type args): " + aux);
            if (aux.isEmpty()) {
                if (map || collection) {
                    aux = Arrays.asList(this.createStringTypeMirror(), this.createStringTypeMirror());
                    logger.finest("fixed aux (for multi type): " + aux);
                } else {
                    aux = Arrays.asList(this.typeMirror);
                    logger.finest("fixed aux (for single type): " + aux);
                }
            }
        } else if (this.typeMirror.getKind() == TypeKind.ARRAY) {
            aux = Arrays.asList(((ArrayType)this.typeMirror).getComponentType());
            this.actualGenericTypeArguments = Arrays.asList(aux.get(0).toString());
        } else {
            this.actualGenericTypeArguments = Collections.emptyList();
        }
        this.auxTypeMirrors = aux;
        this.typeElement = tempTypeElement;
        this.isCollection = collection;
        this.isMap = map;
    }

    private TypeMirror createStringTypeMirror() {
        TypeElement element = this.typeElement;
        while (element.getSuperclass().getKind() != TypeKind.NONE) {
            logger.finest("finding toString in " + element);
            element = (TypeElement)((DeclaredType)element.getSuperclass()).asElement();
        }
        for (Element element2 : this.typeElement.getEnclosedElements()) {
            ExecutableElement method;
            if (element2.getKind() != ElementKind.METHOD || !(method = (ExecutableElement)element2).getSimpleName().contentEquals("toString")) continue;
            return method.getReturnType();
        }
        throw new IllegalStateException("Cannot find toString method in Object");
    }

    private static boolean find(String interfaceName, TypeElement typeElement) {
        return CompileTimeTypeInfo.find(interfaceName, typeElement, new HashSet<Element>());
    }

    private static boolean find(String interfaceName, TypeElement typeElement, Set<Element> visited) {
        if (visited.contains(typeElement)) {
            return false;
        }
        visited.add(typeElement);
        if (typeElement.getQualifiedName().contentEquals(interfaceName)) {
            return true;
        }
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            if (!CompileTimeTypeInfo.find(interfaceName, (TypeElement)((DeclaredType)typeMirror).asElement())) continue;
            return true;
        }
        while (typeElement.getSuperclass().getKind() != TypeKind.NONE) {
            if (!CompileTimeTypeInfo.find(interfaceName, typeElement = (TypeElement)((DeclaredType)typeElement.getSuperclass()).asElement())) continue;
            return true;
        }
        return false;
    }

    public List<CommandLine.Model.ITypeInfo> getAuxiliaryTypeInfos() {
        if (!this.isMultiValue()) {
            logger.fine("getAuxiliaryTypeInfos (non-multi) returning new list with this");
            return Arrays.asList(this);
        }
        ArrayList<CommandLine.Model.ITypeInfo> result = new ArrayList<CommandLine.Model.ITypeInfo>();
        for (TypeMirror typeMirror : this.auxTypeMirrors) {
            result.add(new CompileTimeTypeInfo(typeMirror));
        }
        logger.fine("getAuxiliaryTypeInfos (multi) returning list " + result);
        return result;
    }

    public List<String> getActualGenericTypeArguments() {
        return this.actualGenericTypeArguments;
    }

    public boolean isBoolean() {
        TypeMirror type = this.auxTypeMirrors.get(0);
        return CompileTimeTypeInfo.isBooleanType(type);
    }

    static boolean isBooleanType(TypeMirror type) {
        return type.getKind() == TypeKind.BOOLEAN || "java.lang.Boolean".equals(type.toString());
    }

    public boolean isMultiValue() {
        return this.isArray() || this.isCollection() || this.isMap();
    }

    public boolean isArray() {
        return this.typeMirror.getKind() == TypeKind.ARRAY;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public boolean isEnum() {
        TypeMirror type = this.auxTypeMirrors.get(0);
        return type.getKind() == TypeKind.DECLARED && ((DeclaredType)type).asElement().getKind() == ElementKind.ENUM;
    }

    public List<String> getEnumConstantNames() {
        if (!this.isEnum()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        TypeMirror type = this.auxTypeMirrors.get(0);
        List<? extends Element> enclosed = ((DeclaredType)type).asElement().getEnclosedElements();
        for (Element element : enclosed) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            result.add(element.toString());
        }
        return result;
    }

    public String getClassName() {
        if (this.typeElement == null) {
            return this.typeMirror.toString();
        }
        TypeElement segment = this.typeElement;
        return segment.accept(new SimpleElementVisitor6<StringBuilder, StringBuilder>(){

            @Override
            public StringBuilder visitPackage(PackageElement e, StringBuilder sb) {
                sb.insert(0, e.getQualifiedName() + (sb.length() > 0 ? "." : ""));
                return sb;
            }

            @Override
            public StringBuilder visitType(TypeElement e, StringBuilder sb) {
                if (e.getNestingKind() == NestingKind.MEMBER) {
                    sb.insert(0, "$" + e.getSimpleName());
                } else {
                    sb.insert(0, e.getSimpleName());
                }
                return (StringBuilder)this.visit(e.getEnclosingElement(), sb);
            }
        }, new StringBuilder()).toString();
    }

    public String getClassSimpleName() {
        return this.typeElement == null ? this.typeMirror.toString() : this.typeElement.getSimpleName().toString();
    }

    public Class<?> getType() {
        return null;
    }

    public Class<?>[] getAuxiliaryTypes() {
        return new Class[0];
    }

    public String toString() {
        return String.format("CompileTimeTypeInfo(%s, aux=%s, collection=%s, map=%s)", this.typeMirror, Arrays.toString(this.auxTypeMirrors.toArray()), this.isCollection, this.isMap);
    }
}

