/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import picocli.CommandLine;
import picocli.codegen.annotation.processing.ITypeMetaData;
import picocli.codegen.util.Assert;
import picocli.codegen.util.TypeImporter;

public class AnnotatedCommandSourceGenerator {
    private static final String INDENT_INCREMENT = "    ";
    private static final String[] EMPTY_ARRAY = new String[0];
    private final CommandLine.Model.CommandSpec commandSpec;
    private TypeImporter importer;
    private String outputPackage;

    public AnnotatedCommandSourceGenerator(CommandLine.Model.CommandSpec commandSpec) {
        this(commandSpec, AnnotatedCommandSourceGenerator.extractPackageName(commandSpec.userObject()));
    }

    public AnnotatedCommandSourceGenerator(CommandLine.Model.CommandSpec commandSpec, String outputPackage) {
        this.commandSpec = Assert.notNull(commandSpec, "commandSpec");
        this.outputPackage = Assert.notNull(outputPackage, "outputPackage");
        this.importer = new TypeImporter(outputPackage);
    }

    private static String extractPackageName(Object userObject) {
        if (userObject instanceof ExecutableElement) {
            return AnnotatedCommandSourceGenerator.extractPackageName((TypeElement)((ExecutableElement)userObject).getEnclosingElement());
        }
        if (userObject instanceof TypeElement) {
            return AnnotatedCommandSourceGenerator.extractPackageName((TypeElement)userObject);
        }
        if (userObject instanceof Method) {
            return AnnotatedCommandSourceGenerator.extractPackageName(((Method)userObject).getDeclaringClass());
        }
        if (userObject instanceof Class) {
            return AnnotatedCommandSourceGenerator.extractPackageName((Class)userObject);
        }
        return AnnotatedCommandSourceGenerator.extractPackageName(userObject.getClass());
    }

    private static String extractPackageName(Class<?> cls) {
        return cls.getPackage().getName();
    }

    private static String extractPackageName(TypeElement typeElement) {
        for (Element enclosing = typeElement.getEnclosingElement(); enclosing != null; enclosing = enclosing.getEnclosingElement()) {
            if (!(enclosing instanceof PackageElement)) continue;
            PackageElement pkg = (PackageElement)enclosing;
            if (pkg.isUnnamed()) {
                return "";
            }
            String fqcn = pkg.getQualifiedName().toString();
            return fqcn;
        }
        return "";
    }

    public String getOutputPackage() {
        return this.outputPackage;
    }

    public void setOutputPackage(String outputPackage) {
        this.outputPackage = Assert.notNull(outputPackage, "outputPackage");
        this.importer = new TypeImporter(outputPackage);
    }

    public String generate() {
        StringWriter result = new StringWriter();
        this.writeTo(new PrintWriter(result), "");
        return result.toString();
    }

    public void writeTo(PrintWriter pw, String indent) {
        StringWriter result = new StringWriter();
        PrintWriter tmp = new PrintWriter(result);
        this.printCommand(tmp, this.commandSpec, indent, new HashSet<Object>());
        pw.println("package " + this.outputPackage + ";");
        pw.println(this.importer.createImportDeclaration());
        pw.println();
        pw.print(result);
        pw.flush();
    }

    private void printCommand(PrintWriter pw, CommandLine.Model.CommandSpec spec, String indent, Set<Object> visited) {
        Stack<String> after = new Stack<String>();
        Stack<Object> surroundingElements = new Stack<Object>();
        indent = this.printSurroundingElements(pw, spec.userObject(), indent, surroundingElements, after, visited);
        this.printCommandAnnotation(pw, spec, indent);
        pw.println();
        this.printCommandElementDefOpen(pw, spec.userObject(), indent);
        boolean isCommandMethod = AnnotatedCommandSourceGenerator.isCommandMethod(spec);
        String indent2 = indent + INDENT_INCREMENT;
        for (Iterator<Object> mixinName : spec.mixins().keySet()) {
            CommandLine.Model.CommandSpec mixin = (CommandLine.Model.CommandSpec)spec.mixins().get(mixinName);
            if ("picocli.CommandLine.AutoHelpMixin".equals(mixin.userObject().getClass().getCanonicalName())) continue;
            pw.println();
            pw.printf("%s@%s ", indent2, this.importer.getImportedName(CommandLine.Mixin.class.getCanonicalName()));
            pw.print(this.importer.getImportedName(this.extractClassName(mixin.userObject())));
            pw.println(" " + mixinName + ";");
        }
        String sep = "";
        for (CommandLine.Model.OptionSpec option : spec.options()) {
            if (AnnotatedCommandSourceGenerator.isMixedIn(option, spec)) continue;
            pw.printf(sep, new Object[0]);
            pw.println();
            this.printOptionAnnotation(pw, option, indent2);
            pw.printf(isCommandMethod ? " " : "%n" + indent2, new Object[0]);
            sep = this.printArgElementDef(pw, option.userObject(), isCommandMethod, indent2);
        }
        for (CommandLine.Model.PositionalParamSpec param : spec.positionalParameters()) {
            if (AnnotatedCommandSourceGenerator.isMixedIn(param, spec)) continue;
            pw.printf(sep, new Object[0]);
            pw.println();
            this.printParametersAnnotation(pw, param, indent2);
            pw.printf(isCommandMethod ? " " : "%n" + indent2, new Object[0]);
            sep = this.printArgElementDef(pw, param.userObject(), isCommandMethod, indent2);
        }
        if (!isCommandMethod) {
            pw.printf(sep, new Object[0]);
        }
        for (String mixinName : spec.mixins().keySet()) {
            CommandLine.Model.CommandSpec mixin = (CommandLine.Model.CommandSpec)spec.mixins().get(mixinName);
            if (!AnnotatedCommandSourceGenerator.isNestedCommand(mixin, spec) || AnnotatedCommandSourceGenerator.isBuiltInMixin(mixin)) continue;
            pw.println();
            this.printCommand(pw, mixin, indent + INDENT_INCREMENT, visited);
        }
        for (String subcommandName : spec.subcommands().keySet()) {
            CommandLine.Model.CommandSpec subcommand = ((CommandLine)spec.subcommands().get(subcommandName)).getCommandSpec();
            if (!AnnotatedCommandSourceGenerator.isNestedCommand(subcommand, spec) || AnnotatedCommandSourceGenerator.isBuiltInSubcommand(subcommand)) continue;
            pw.println();
            this.printCommand(pw, subcommand, indent + INDENT_INCREMENT, visited);
        }
        AnnotatedCommandSourceGenerator.printCommandElementDefClose(pw, spec.userObject(), indent);
        while (!after.isEmpty()) {
            Object surroundingElement = surroundingElements.pop();
            for (String mixinName : spec.mixins().keySet()) {
                CommandLine.Model.CommandSpec mixin = (CommandLine.Model.CommandSpec)spec.mixins().get(mixinName);
                if (!AnnotatedCommandSourceGenerator.isNested(mixin.userObject(), surroundingElement) || AnnotatedCommandSourceGenerator.isBuiltInMixin(mixin)) continue;
                pw.println();
                this.printCommand(pw, mixin, indent, visited);
            }
            for (String subcommandName : spec.subcommands().keySet()) {
                CommandLine.Model.CommandSpec subcommand = ((CommandLine)spec.subcommands().get(subcommandName)).getCommandSpec();
                if (!AnnotatedCommandSourceGenerator.isNested(subcommand.userObject(), surroundingElement) || AnnotatedCommandSourceGenerator.isBuiltInSubcommand(subcommand)) continue;
                pw.println();
                this.printCommand(pw, subcommand, indent, visited);
            }
            pw.print(after.pop());
        }
    }

    public static boolean isBuiltInMixin(CommandLine.Model.CommandSpec mixin) {
        String str = mixin.userObject().toString();
        return "picocli.CommandLine.AutoHelpMixin".equals(str) || "picocli.CommandLine$AutoHelpMixin".equals(str);
    }

    public static boolean isBuiltInSubcommand(CommandLine.Model.CommandSpec subcommand) {
        String str = subcommand.userObject().toString();
        return "picocli.CommandLine.HelpCommand".equals(str) || "picocli.CommandLine$HelpCommand".equals(str);
    }

    private String printSurroundingElements(PrintWriter pw, Object userObject, String indent, Stack<Object> surrounding, Stack<String> after, Set<Object> visited) {
        this.collectEnclosingElements(userObject, surrounding, visited);
        Stack enclosing = (Stack)surrounding.clone();
        LinkedList<String> indents = new LinkedList<String>();
        for (int i = 0; i < enclosing.size(); ++i) {
            indents.add(indent);
            indent = indent + INDENT_INCREMENT;
        }
        String currentIndent = indent;
        Stack<String> before = new Stack<String>();
        while (!enclosing.isEmpty()) {
            Object obj = enclosing.pop();
            currentIndent = (String)indents.poll();
            if (obj == userObject) break;
            StringWriter sw = new StringWriter();
            if (obj instanceof Method || obj instanceof ExecutableElement) {
                this.printArgElementDef(new PrintWriter(sw), obj, true, currentIndent);
                String definition = sw.toString();
                definition = definition.substring(0, definition.indexOf("{") + 1);
                before.push(String.format("%s%n", definition));
                after.push(String.format("%s}%n", currentIndent));
                continue;
            }
            this.printCommandElementDefOpen(new PrintWriter(sw), obj, currentIndent);
            before.push(String.format("%s%n", sw.toString()));
            sw.getBuffer().setLength(0);
            AnnotatedCommandSourceGenerator.printCommandElementDefClose(new PrintWriter(sw), obj, currentIndent);
            after.push(sw.toString());
        }
        while (!before.isEmpty()) {
            pw.print((String)before.pop());
        }
        return currentIndent;
    }

    private void collectEnclosingElements(Object userObject, Stack<Object> enclosing, Set<Object> visited) {
        Element enclosingElement;
        if (visited.contains(userObject)) {
            return;
        }
        visited.add(userObject);
        enclosing.add(userObject);
        if (userObject instanceof Method) {
            this.collectEnclosingElements(((Method)userObject).getDeclaringClass(), enclosing, visited);
        } else if (userObject instanceof ExecutableElement) {
            this.collectEnclosingElements(((ExecutableElement)userObject).getEnclosingElement(), enclosing, visited);
        } else if (userObject instanceof Class) {
            Class type = (Class)userObject;
            if (type.getEnclosingMethod() != null) {
                this.collectEnclosingElements(type.getEnclosingMethod(), enclosing, visited);
            } else if (type.getDeclaringClass() != null) {
                this.collectEnclosingElements(type.getDeclaringClass(), enclosing, visited);
            }
        } else if (userObject instanceof TypeElement && ((enclosingElement = ((TypeElement)userObject).getEnclosingElement()) instanceof TypeElement || enclosingElement instanceof ExecutableElement)) {
            this.collectEnclosingElements(enclosingElement, enclosing, visited);
        }
    }

    public static boolean isNestedCommand(CommandLine.Model.CommandSpec inner, CommandLine.Model.CommandSpec outer) {
        Object innerUserObject = inner.userObject();
        Object outerUserObject = outer.userObject();
        return AnnotatedCommandSourceGenerator.isNested(innerUserObject, outerUserObject);
    }

    private static boolean isNested(Object innerUserObject, Object outerUserObject) {
        if (innerUserObject instanceof Method) {
            Class<?> cls = ((Method)innerUserObject).getDeclaringClass();
            if (cls.equals(outerUserObject) || cls.equals(outerUserObject.getClass())) {
                return true;
            }
        } else {
            Class cls;
            if (innerUserObject instanceof Element) {
                for (Element enclosingElement = ((Element)innerUserObject).getEnclosingElement(); enclosingElement != null; enclosingElement = enclosingElement.getEnclosingElement()) {
                    if (!enclosingElement.equals(outerUserObject)) continue;
                    return true;
                }
                return false;
            }
            if (innerUserObject instanceof Class ? (cls = (Class)innerUserObject).isMemberClass() && (cls.getEnclosingClass().equals(outerUserObject) || cls.getEnclosingClass().equals(outerUserObject.getClass())) : (cls = innerUserObject.getClass()).isMemberClass() && (cls.getEnclosingClass().equals(outerUserObject) || cls.getEnclosingClass().equals(outerUserObject.getClass()))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isMixedIn(CommandLine.Model.OptionSpec option, CommandLine.Model.CommandSpec spec) {
        for (CommandLine.Model.CommandSpec mixin : spec.mixins().values()) {
            if (mixin.findOption(option.longestName()) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isMixedIn(CommandLine.Model.PositionalParamSpec positional, CommandLine.Model.CommandSpec spec) {
        for (CommandLine.Model.CommandSpec mixin : spec.mixins().values()) {
            for (CommandLine.Model.PositionalParamSpec mixedIn : mixin.positionalParameters()) {
                if (!mixedIn.equals((Object)positional)) continue;
                return true;
            }
        }
        return false;
    }

    private static String argElementName(CommandLine.Model.ArgSpec argSpec) {
        Object userObject = argSpec.userObject();
        if (userObject instanceof Field) {
            return ((Field)userObject).getName();
        }
        if (userObject instanceof CommandLine.Model.MethodParam) {
            return ((CommandLine.Model.MethodParam)userObject).getName();
        }
        if (userObject instanceof Method) {
            return AnnotatedCommandSourceGenerator.propertyName(((Method)userObject).getName());
        }
        if (userObject instanceof VariableElement) {
            return ((VariableElement)userObject).getSimpleName().toString();
        }
        if (userObject instanceof ExecutableElement) {
            return AnnotatedCommandSourceGenerator.propertyName(((ExecutableElement)userObject).getSimpleName().toString());
        }
        return userObject + "";
    }

    static String propertyName(String methodName) {
        if (methodName.length() > 3 && (methodName.startsWith("get") || methodName.startsWith("set"))) {
            return AnnotatedCommandSourceGenerator.decapitalize(methodName.substring(3));
        }
        return AnnotatedCommandSourceGenerator.decapitalize(methodName);
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private String printArgElementDef(PrintWriter pw, Object userObject, boolean enclosedInCommandMethod, String indent) {
        if (userObject instanceof Field) {
            Field f = (Field)userObject;
            String result = this.typeName(f.getGenericType()) + " " + f.getName();
            if (f.getModifiers() != 0 && !enclosedInCommandMethod) {
                pw.print(Modifier.toString(f.getModifiers()) + " " + result);
            } else {
                pw.print(result);
            }
        } else if (userObject instanceof CommandLine.Model.MethodParam) {
            CommandLine.Model.MethodParam param = (CommandLine.Model.MethodParam)userObject;
            String result = this.typeName(param.getParameterizedType()) + " " + param.getName();
            pw.print(result);
        } else {
            if (userObject instanceof Method) {
                Method m = (Method)userObject;
                StringBuilder sb = new StringBuilder(128);
                sb.append(this.typeName(m.getGenericReturnType())).append(" ").append(m.getName());
                sb.append('(');
                Type[] params = m.getGenericParameterTypes();
                for (int j = 0; j < params.length; ++j) {
                    String param = this.typeName(params[j]);
                    if (m.isVarArgs() && j == params.length - 1) {
                        param = param.replaceFirst("\\[\\]$", "...");
                    }
                    sb.append(param);
                    sb.append(" ").append(AnnotatedCommandSourceGenerator.parameterName(m, j));
                    if (j >= params.length - 1) continue;
                    sb.append(',');
                }
                sb.append(')');
                Type[] exceptions = m.getGenericExceptionTypes();
                if (exceptions.length > 0) {
                    sb.append(" throws ");
                    for (int k = 0; k < exceptions.length; ++k) {
                        sb.append(exceptions[k] instanceof Class ? this.importer.getImportedName(((Class)exceptions[k]).getCanonicalName()) : this.importer.getImportedName(exceptions[k].toString()));
                        if (k >= exceptions.length - 1) continue;
                        sb.append(',');
                    }
                }
                String result = sb.toString();
                if (m.getModifiers() != 0 && !enclosedInCommandMethod) {
                    pw.print(Modifier.toString(m.getModifiers()) + " " + result);
                } else {
                    pw.print(result);
                }
                if (m.getDeclaringClass().isInterface()) {
                    pw.print(";");
                } else {
                    pw.println(" {");
                    pw.println(indent + "    // TODO replace the stored value with the new value");
                    pw.println(indent + "}");
                }
                return "";
            }
            if (userObject instanceof VariableElement) {
                VariableElement f = (VariableElement)userObject;
                String result = this.typeName(f.asType()) + " " + f.getSimpleName();
                if (!f.getModifiers().isEmpty() && !enclosedInCommandMethod) {
                    pw.print(AnnotatedCommandSourceGenerator.modifierString(f.getModifiers()) + "" + result);
                } else {
                    pw.print(result);
                }
            } else {
                if (userObject instanceof ExecutableElement) {
                    ExecutableElement m = (ExecutableElement)userObject;
                    StringBuilder sb = new StringBuilder(128);
                    sb.append(this.typeName(m.getReturnType())).append(" ").append(m.getSimpleName());
                    sb.append('(');
                    List<? extends VariableElement> parameters = m.getParameters();
                    for (int j = 0; j < parameters.size(); ++j) {
                        String param = this.typeName(parameters.get(j).asType());
                        if (m.isVarArgs() && j == parameters.size() - 1) {
                            param = param.replaceFirst("\\[\\]$", "...");
                        }
                        sb.append(param);
                        sb.append(" ").append(parameters.get(j).getSimpleName());
                        if (j >= parameters.size() - 1) continue;
                        sb.append(',');
                    }
                    sb.append(')');
                    List<? extends TypeMirror> exceptions = m.getThrownTypes();
                    if (!exceptions.isEmpty()) {
                        sb.append(" throws ");
                        for (int k = 0; k < exceptions.size(); ++k) {
                            sb.append(this.importer.getImportedName(exceptions.get(k).toString()));
                            if (k >= exceptions.size() - 1) continue;
                            sb.append(',');
                        }
                    }
                    String result = sb.toString();
                    if (!m.getModifiers().isEmpty() && !enclosedInCommandMethod) {
                        pw.print(AnnotatedCommandSourceGenerator.modifierString(m.getModifiers()) + "" + result);
                    } else {
                        pw.print(result);
                    }
                    if (m.getEnclosingElement().getKind() == ElementKind.INTERFACE) {
                        pw.print(";");
                    } else {
                        pw.println(" {");
                        pw.println(indent + "    // TODO replace the stored value with the new value");
                        pw.println(indent + "}");
                    }
                    return "";
                }
                pw.print("CANNOT RENDER " + userObject);
            }
        }
        return enclosedInCommandMethod ? "," : ";%n";
    }

    private String typeName(Type type) {
        if (type instanceof Class) {
            return this.importer.getImportedName(((Class)type).getCanonicalName());
        }
        return this.importer.getImportedName(type.toString());
    }

    private String typeName(TypeMirror type) {
        return this.importer.getImportedName(type.toString());
    }

    private static String parameterName(Method m, int j) {
        try {
            Object parameterArray = Method.class.getDeclaredMethod("getParameters", new Class[0]).invoke((Object)m, new Object[0]);
            Object parameter = Array.get(parameterArray, j);
            return (String)Class.forName("java.lang.reflect.Parameter").getDeclaredMethod("getName", new Class[0]).invoke(parameter, new Object[0]);
        }
        catch (Exception exception) {
            return "arg" + j;
        }
    }

    private static boolean isCommandMethod(CommandLine.Model.CommandSpec spec) {
        Object userObject = spec.userObject();
        return userObject instanceof Method || userObject instanceof ExecutableElement;
    }

    private void printCommandElementDefOpen(PrintWriter pw, Object userObject, String indent) {
        if (userObject instanceof Method) {
            Method m = (Method)userObject;
            pw.print(indent);
            if (m.getModifiers() != 0) {
                pw.print(Modifier.toString(m.getModifiers()));
            }
            pw.print(this.typeName(m.getGenericReturnType()));
            pw.print(" ");
            pw.print(m.getName());
            pw.print("(");
        } else if (userObject instanceof ExecutableElement) {
            ExecutableElement m = (ExecutableElement)userObject;
            pw.print(indent);
            if (!m.getModifiers().isEmpty()) {
                pw.print(AnnotatedCommandSourceGenerator.modifierString(m.getModifiers()));
            }
            pw.print(this.typeName(m.getReturnType()));
            pw.print(" ");
            pw.print(m.getSimpleName());
            pw.print("(");
        } else if (userObject instanceof TypeElement) {
            TypeElement type = (TypeElement)userObject;
            String modifiers = AnnotatedCommandSourceGenerator.modifierString(type.getModifiers());
            String name = type.getSimpleName().toString();
            pw.printf("%s%sclass %s {", indent, modifiers, name);
        } else {
            Class<?> cls = userObject.getClass();
            String modifiers = cls.getModifiers() == 0 ? "" : Modifier.toString(cls.getModifiers()) + " ";
            String name = this.importer.getImportedName(userObject.getClass().getCanonicalName());
            pw.printf("%s%sclass %s {", indent, modifiers, name);
        }
    }

    private static String modifierString(Set<javax.lang.model.element.Modifier> modifiers) {
        return AnnotatedCommandSourceGenerator.modifierString(modifiers, new StringBuilder()).toString();
    }

    private static StringBuilder modifierString(Set<javax.lang.model.element.Modifier> modifiers, StringBuilder sb) {
        for (javax.lang.model.element.Modifier mod : modifiers) {
            sb.append(mod.toString());
            sb.append(" ");
        }
        return sb;
    }

    private static void printCommandElementDefClose(PrintWriter pw, Object userObject, String indent) {
        if (userObject instanceof Method || userObject instanceof ExecutableElement) {
            String full = userObject.toString();
            pw.print(full.substring(full.indexOf(41)));
            pw.println(" {");
            pw.println(indent + "    // TODO implement commandSpec");
            pw.println(indent + "}");
        } else {
            pw.printf("%s}%n", indent);
        }
    }

    private void printParametersAnnotation(PrintWriter pw, CommandLine.Model.PositionalParamSpec spec, String indent) {
        pw.printf("%s@%s", indent, this.importer.getImportedName(CommandLine.Parameters.class.getCanonicalName()));
        indent = String.format(",%n%s            ", indent);
        String sep = "(";
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "index = \"%s\"", spec.index().toString(), spec.index().isUnspecified());
        sep = AnnotatedCommandSourceGenerator.appendStringArray(pw, sep, indent, "description = %s", spec.description(), EMPTY_ARRAY);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "arity = \"%s\"", spec.arity().toString(), spec.arity().isUnspecified() ? spec.arity().toString() : "");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "paramLabel = \"%s\"", spec.paramLabel(), "<" + AnnotatedCommandSourceGenerator.argElementName((CommandLine.Model.ArgSpec)spec) + ">");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "hideParamSyntax = %s", spec.hideParamSyntax(), false);
        sep = this.appendTypeInfo(pw, sep, indent, spec.typeInfo());
        sep = this.appendTypeConverter(pw, sep, indent, spec.converters());
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "split = \"%s\"", spec.splitRegex(), "");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "hidden = %s", spec.hidden(), false);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "defaultValue = \"%s\"", spec.defaultValue() == null ? "__no_default_value__" : spec.defaultValue(), "__no_default_value__");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "showDefaultValue = %s", spec.showDefaultValue(), CommandLine.Help.Visibility.ON_DEMAND);
        sep = this.appendCompletionCandidates(pw, sep, indent, (CommandLine.Model.ArgSpec)spec);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "interactive = %s", spec.interactive(), false);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "descriptionKey = \"%s\"", spec.descriptionKey(), "");
        if (!"(".equals(sep)) {
            pw.print(")");
        }
    }

    private void printOptionAnnotation(PrintWriter pw, CommandLine.Model.OptionSpec spec, String indent) {
        pw.printf("%s@%s", indent, this.importer.getImportedName(CommandLine.Option.class.getCanonicalName()));
        indent = String.format(",%n%s        ", indent);
        String sep = "(";
        sep = AnnotatedCommandSourceGenerator.appendStringArray(pw, sep, indent, "names = %s", spec.names(), EMPTY_ARRAY);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "required = %s", spec.required(), false);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "help = %s", spec.help(), false);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "usageHelp = %s", spec.usageHelp(), false);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "versionHelp = %s", spec.versionHelp(), false);
        sep = AnnotatedCommandSourceGenerator.appendStringArray(pw, sep, indent, "description = %s", spec.description(), EMPTY_ARRAY);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "arity = \"%s\"", spec.arity().toString(), spec.arity().isUnspecified() ? spec.arity().toString() : "");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "paramLabel = \"%s\"", spec.paramLabel(), "<" + AnnotatedCommandSourceGenerator.argElementName((CommandLine.Model.ArgSpec)spec) + ">");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "hideParamSyntax = %s", spec.hideParamSyntax(), false);
        sep = this.appendTypeInfo(pw, sep, indent, spec.typeInfo());
        sep = this.appendTypeConverter(pw, sep, indent, spec.converters());
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "split = \"%s\"", spec.splitRegex(), "");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "hidden = %s", spec.hidden(), false);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "defaultValue = %s", spec.defaultValue() == null ? "__no_default_value__" : spec.defaultValue(), "__no_default_value__");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "showDefaultValue = \"%s\"", spec.showDefaultValue(), CommandLine.Help.Visibility.ON_DEMAND);
        sep = this.appendCompletionCandidates(pw, sep, indent, (CommandLine.Model.ArgSpec)spec);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "interactive = %s", spec.interactive(), false);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "descriptionKey = \"%s\"", spec.descriptionKey(), "");
        if (!"(".equals(sep)) {
            pw.print(")");
        }
    }

    private void printCommandAnnotation(PrintWriter pw, CommandLine.Model.CommandSpec spec, String indent) {
        pw.printf("%s@%s", indent, this.importer.getImportedName(CommandLine.Command.class.getCanonicalName()));
        indent = String.format(",%n%s         ", indent);
        String sep = "(";
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "name = \"%s\"", spec.name(), "<main class>");
        sep = AnnotatedCommandSourceGenerator.appendStringArray(pw, sep, indent, "aliases = %s", spec.aliases(), EMPTY_ARRAY);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "mixinStandardHelpOptions = %s", spec.mixinStandardHelpOptions(), false);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "headerHeading = \"%s\"", spec.usageMessage().headerHeading(), "");
        sep = AnnotatedCommandSourceGenerator.appendStringArray(pw, sep, indent, "header = %s", spec.usageMessage().header(), EMPTY_ARRAY);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "descriptionHeading = \"%s\"", spec.usageMessage().descriptionHeading(), "");
        sep = AnnotatedCommandSourceGenerator.appendStringArray(pw, sep, indent, "description = %s", spec.usageMessage().description(), EMPTY_ARRAY);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "synopsisHeading = \"%s\"", spec.usageMessage().synopsisHeading(), "Usage: ");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "abbreviateSynopsis = %s", spec.usageMessage().abbreviateSynopsis(), false);
        sep = AnnotatedCommandSourceGenerator.appendStringArray(pw, sep, indent, "customSynopsis = %s", spec.usageMessage().customSynopsis(), EMPTY_ARRAY);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "optionListHeading = \"%s\"", spec.usageMessage().optionListHeading(), "");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "parameterListHeading = \"%s\"", spec.usageMessage().parameterListHeading(), "");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "commandListHeading = \"%s\"", spec.usageMessage().commandListHeading(), "Commands:%n");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "footerHeading = \"%s\"", spec.usageMessage().footerHeading(), "");
        sep = AnnotatedCommandSourceGenerator.appendStringArray(pw, sep, indent, "footer = %s", spec.usageMessage().footer(), EMPTY_ARRAY);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "requiredOptionMarker = '%s'", Character.valueOf(spec.usageMessage().requiredOptionMarker()), Character.valueOf(' '));
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "addMethodSubcommands = %s", spec.isAddMethodSubcommands(), !AnnotatedCommandSourceGenerator.isCommandMethod(spec));
        sep = this.appendSubcommandClasses(pw, sep, indent, spec.subcommands());
        sep = AnnotatedCommandSourceGenerator.appendStringArray(pw, sep, indent, "version = %s", spec.version(), EMPTY_ARRAY);
        sep = this.appendClassName(pw, sep, indent, "versionProvider = %s", spec.versionProvider());
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "showDefaultValues = %s", spec.usageMessage().showDefaultValues(), false);
        sep = this.appendClassName(pw, sep, indent, "defaultValueProvider = %s", spec.defaultValueProvider());
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "resourceBundle = \"%s\"", spec.resourceBundleBaseName(), "null");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "sortOptions = %s", spec.usageMessage().sortOptions(), true);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "hidden = %s", spec.usageMessage().hidden(), false);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "helpCommand = %s", spec.helpCommand(), false);
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "separator = \"%s\"", spec.parser().separator(), "=");
        sep = AnnotatedCommandSourceGenerator.append(pw, sep, indent, "usageHelpWidth = %s", spec.usageMessage().width(), 80);
        if (!"(".equals(sep)) {
            pw.print(")");
        }
    }

    private static String append(PrintWriter pw, String prefix, String newPrefix, String template, Object value, Object defaultValue) {
        if (defaultValue.equals(value) || "null".equals(defaultValue) && value == null) {
            return prefix;
        }
        pw.print(prefix);
        pw.printf(template, value);
        return newPrefix;
    }

    private static String appendStringArray(PrintWriter pw, String prefix, String newPrefix, String template, String[] values, String[] defaultValues) {
        if (values == null || Arrays.equals(values, defaultValues)) {
            return prefix;
        }
        ArrayList<String> quoted = new ArrayList<String>();
        for (String value : values) {
            quoted.add('\"' + value + '\"');
        }
        pw.print(prefix);
        pw.printf(template, AnnotatedCommandSourceGenerator.listToString(quoted));
        return newPrefix;
    }

    private String appendSubcommandClasses(PrintWriter pw, String prefix, String newPrefix, Map<String, CommandLine> subcommands) {
        ArrayList<String> subcommandClasses = new ArrayList<String>();
        for (CommandLine cmd : subcommands.values()) {
            Object obj = cmd.getCommand();
            if (obj instanceof Method || obj instanceof ExecutableElement) continue;
            if (obj instanceof Element) {
                subcommandClasses.add(this.importer.getImportedName(obj.toString()) + ".class");
                continue;
            }
            subcommandClasses.add(this.importer.getImportedName(obj.getClass().getCanonicalName()) + ".class");
        }
        if (subcommandClasses.isEmpty()) {
            return prefix;
        }
        pw.print(prefix);
        pw.printf("subcommands = %s", AnnotatedCommandSourceGenerator.listToString(subcommandClasses));
        return newPrefix;
    }

    private String appendClassName(PrintWriter pw, String prefix, String newPrefix, String template, Object object) {
        if (object == null || AnnotatedCommandSourceGenerator.isDefault(object)) {
            return prefix;
        }
        pw.print(prefix);
        pw.printf(template, this.extractClassName(object) + ".class");
        return newPrefix;
    }

    private String appendTypeInfo(PrintWriter pw, String prefix, String newPrefix, CommandLine.Model.ITypeInfo typeInfo) {
        if (typeInfo.isCollection() || typeInfo.isMap()) {
            List aux = typeInfo.getAuxiliaryTypeInfos();
            pw.print(prefix);
            pw.printf("type = %s", AnnotatedCommandSourceGenerator.listToString(this.extractClassNames(aux)));
            return newPrefix;
        }
        return prefix;
    }

    private List<String> extractClassNames(List<CommandLine.Model.ITypeInfo> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (CommandLine.Model.ITypeInfo typeInfo : list) {
            result.add(this.importer.getImportedName(typeInfo.getClassName()) + ".class");
        }
        return result;
    }

    private String appendTypeConverter(PrintWriter pw, String prefix, String newPrefix, CommandLine.ITypeConverter<?>[] typeConverters) {
        if (typeConverters == null) {
            return prefix;
        }
        ArrayList<String> classNames = new ArrayList<String>();
        for (CommandLine.ITypeConverter<?> converter : typeConverters) {
            if (AnnotatedCommandSourceGenerator.isDefault(converter)) continue;
            classNames.add(this.extractClassName(converter) + ".class");
        }
        if (classNames.isEmpty()) {
            return prefix;
        }
        pw.print(prefix);
        pw.printf("converter = %s", AnnotatedCommandSourceGenerator.listToString(classNames));
        return newPrefix;
    }

    private String appendCompletionCandidates(PrintWriter pw, String prefix, String newPrefix, CommandLine.Model.ArgSpec argSpec) {
        Iterable completionCandidates = argSpec.completionCandidates();
        if (completionCandidates == null || AnnotatedCommandSourceGenerator.isDefault(completionCandidates) || argSpec.typeInfo().isEnum()) {
            return prefix;
        }
        pw.print(prefix);
        pw.printf("completionCandidates = %s.class", this.extractClassName(completionCandidates));
        return newPrefix;
    }

    private static String listToString(List<String> values) {
        if (values.isEmpty()) {
            return "{}";
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        return values.toString().replace('[', '{').replace(']', '}');
    }

    private static boolean isDefault(Object typeMetaData) {
        return typeMetaData instanceof ITypeMetaData && ((ITypeMetaData)typeMetaData).isDefault();
    }

    private String extractClassName(Object object) {
        if (object instanceof ITypeMetaData) {
            ITypeMetaData metaData = (ITypeMetaData)object;
            return this.importer.getImportedName(metaData.getTypeMirror().toString());
        }
        if (object instanceof Element) {
            TypeElement typeElement = (TypeElement)object;
            return this.importer.getImportedName(typeElement.getQualifiedName().toString());
        }
        return this.importer.getImportedName(object.getClass().getCanonicalName());
    }

    @CommandLine.Command(name="<main class>", aliases={}, mixinStandardHelpOptions=false, headerHeading="", header={}, descriptionHeading="", description={}, synopsisHeading="Usage: ", abbreviateSynopsis=false, customSynopsis={}, optionListHeading="", parameterListHeading="", commandListHeading="Commands:%n", footerHeading="", footer={}, requiredOptionMarker=32, addMethodSubcommands=true, subcommands={}, version={}, showDefaultValues=false, resourceBundle="", sortOptions=true, hidden=false, helpCommand=false, separator="=", usageHelpWidth=80)
    class App {
        @CommandLine.ParentCommand
        Object parent;
        @CommandLine.Spec
        CommandLine.Model.CommandSpec spec;
        @CommandLine.Unmatched
        List<String> unmatched;
        @CommandLine.Mixin
        Object mixin;
        @CommandLine.Option(names={}, required=false, help=false, usageHelp=false, versionHelp=false, description={}, arity="", paramLabel="", hideParamSyntax=false, type={}, converter={}, split="", hidden=false, defaultValue="__no_default_value__", showDefaultValue=CommandLine.Help.Visibility.ON_DEMAND, interactive=false, descriptionKey="")
        Object option;
        @CommandLine.Parameters(index="", description={}, arity="", paramLabel="", hideParamSyntax=false, type={}, converter={}, split="", hidden=false, defaultValue="__no_default_value__", showDefaultValue=CommandLine.Help.Visibility.ON_DEMAND, interactive=false, descriptionKey="")
        Object parameter;

        App() {
        }
    }
}

