/*
 * Decompiled with CFR 0.152.
 */
package info.hoang8f.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import info.hoang8f.fbutton.R;

public class FButton
extends Button
implements View.OnTouchListener {
    private boolean isShadowEnabled = true;
    private int mButtonColor;
    private int mShadowColor;
    private int mShadowHeight;
    private int mCornerRadius;
    private int mPaddingLeft;
    private int mPaddingRight;
    private int mPaddingTop;
    private int mPaddingBottom;
    private Drawable pressedDrawable;
    private Drawable unpressedDrawable;
    boolean isShadowColorDefined = false;

    public FButton(Context context) {
        super(context);
        this.init();
        this.setOnTouchListener(this);
    }

    public FButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
        this.parseAttrs(context, attrs);
        this.setOnTouchListener(this);
    }

    public FButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
        this.parseAttrs(context, attrs);
        this.setOnTouchListener(this);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.refresh();
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                this.updateBackground(this.pressedDrawable);
                this.setPadding(this.mPaddingLeft, this.mPaddingTop + this.mShadowHeight, this.mPaddingRight, this.mPaddingBottom);
                break;
            }
            case 2: {
                Rect r = new Rect();
                view.getLocalVisibleRect(r);
                if (r.contains((int)motionEvent.getX(), (int)motionEvent.getY())) break;
                this.updateBackground(this.pressedDrawable);
                this.setPadding(this.mPaddingLeft, this.mPaddingTop + this.mShadowHeight, this.mPaddingRight, this.mPaddingBottom + this.mShadowHeight);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                this.updateBackground(this.unpressedDrawable);
                this.setPadding(this.mPaddingLeft, this.mPaddingTop + this.mShadowHeight, this.mPaddingRight, this.mPaddingBottom + this.mShadowHeight);
            }
        }
        return false;
    }

    private void init() {
        this.isShadowEnabled = true;
        Resources resources = this.getResources();
        if (resources == null) {
            return;
        }
        this.mButtonColor = resources.getColor(R.color.fbutton_default_color);
        this.mShadowColor = resources.getColor(R.color.fbutton_default_shadow_color);
        this.mShadowHeight = resources.getDimensionPixelSize(R.dimen.fbutton_default_shadow_height);
        this.mCornerRadius = resources.getDimensionPixelSize(R.dimen.fbutton_default_conner_radius);
    }

    private void parseAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.FButton);
        if (typedArray == null) {
            return;
        }
        for (int i = 0; i < typedArray.getIndexCount(); ++i) {
            int attr = typedArray.getIndex(i);
            if (attr == 0) {
                this.isShadowEnabled = typedArray.getBoolean(attr, true);
                continue;
            }
            if (attr == 1) {
                this.mButtonColor = typedArray.getColor(attr, R.color.fbutton_default_color);
                continue;
            }
            if (attr == 2) {
                this.mShadowColor = typedArray.getColor(attr, R.color.fbutton_default_shadow_color);
                this.isShadowColorDefined = true;
                continue;
            }
            if (attr == 3) {
                this.mShadowHeight = typedArray.getDimensionPixelSize(attr, R.dimen.fbutton_default_shadow_height);
                continue;
            }
            if (attr != 4) continue;
            this.mCornerRadius = typedArray.getDimensionPixelSize(attr, R.dimen.fbutton_default_conner_radius);
        }
        typedArray.recycle();
        int[] attrsArray = new int[]{16842966, 16842968};
        TypedArray ta = context.obtainStyledAttributes(attrs, attrsArray);
        if (ta == null) {
            return;
        }
        this.mPaddingLeft = ta.getDimensionPixelSize(0, 0);
        this.mPaddingRight = ta.getDimensionPixelSize(1, 0);
        ta.recycle();
        int[] attrsArray2 = new int[]{16842967, 16842969};
        TypedArray ta1 = context.obtainStyledAttributes(attrs, attrsArray2);
        if (ta1 == null) {
            return;
        }
        this.mPaddingTop = ta.getDimensionPixelSize(0, 0);
        this.mPaddingBottom = ta.getDimensionPixelSize(1, 0);
        ta1.recycle();
    }

    public void refresh() {
        float[] hsv = new float[3];
        Color.colorToHSV((int)this.mButtonColor, (float[])hsv);
        hsv[2] = hsv[2] * 0.8f;
        if (!this.isShadowColorDefined) {
            this.mShadowColor = Color.HSVToColor((float[])hsv);
        }
        if (this.isShadowEnabled) {
            this.pressedDrawable = this.createDrawable(this.mCornerRadius, 0, this.mButtonColor);
            this.unpressedDrawable = this.createDrawable(this.mCornerRadius, this.mButtonColor, this.mShadowColor);
        } else {
            this.mShadowHeight = 0;
            this.pressedDrawable = this.createDrawable(this.mCornerRadius, this.mShadowColor, 0);
            this.unpressedDrawable = this.createDrawable(this.mCornerRadius, this.mButtonColor, 0);
        }
        this.updateBackground(this.unpressedDrawable);
        this.setPadding(this.mPaddingLeft, this.mPaddingTop + this.mShadowHeight, this.mPaddingRight, this.mPaddingBottom + this.mShadowHeight);
    }

    private void updateBackground(Drawable background) {
        if (background == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(background);
        } else {
            this.setBackgroundDrawable(background);
        }
    }

    private LayerDrawable createDrawable(int radius, int topColor, int bottomColor) {
        float[] outerRadius = new float[]{radius, radius, radius, radius, radius, radius, radius, radius};
        RoundRectShape topRoundRect = new RoundRectShape(outerRadius, null, null);
        ShapeDrawable topShapeDrawable = new ShapeDrawable((Shape)topRoundRect);
        topShapeDrawable.getPaint().setColor(topColor);
        RoundRectShape roundRectShape = new RoundRectShape(outerRadius, null, null);
        ShapeDrawable bottomShapeDrawable = new ShapeDrawable((Shape)roundRectShape);
        bottomShapeDrawable.getPaint().setColor(bottomColor);
        Drawable[] drawArray = new Drawable[]{bottomShapeDrawable, topShapeDrawable};
        LayerDrawable layerDrawable = new LayerDrawable(drawArray);
        if (this.isShadowEnabled && topColor != 0) {
            layerDrawable.setLayerInset(0, 0, 0, 0, 0);
        } else {
            layerDrawable.setLayerInset(0, 0, this.mShadowHeight, 0, 0);
        }
        layerDrawable.setLayerInset(1, 0, 0, 0, this.mShadowHeight);
        return layerDrawable;
    }

    public void setShadowEnabled(boolean isShadowEnabled) {
        this.isShadowEnabled = isShadowEnabled;
        this.setShadowHeight(0);
        this.refresh();
    }

    public void setButtonColor(int buttonColor) {
        this.mButtonColor = buttonColor;
        this.refresh();
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowColor = shadowColor;
        this.isShadowColorDefined = true;
        this.refresh();
    }

    public void setShadowHeight(int shadowHeight) {
        this.mShadowHeight = shadowHeight;
        this.refresh();
    }

    public void setCornerRadius(int cornerRadius) {
        this.mCornerRadius = cornerRadius;
        this.refresh();
    }

    public void setFButtonPadding(int left, int top, int right, int bottom) {
        this.mPaddingLeft = left;
        this.mPaddingRight = right;
        this.mPaddingTop = top;
        this.mPaddingBottom = bottom;
        this.refresh();
    }

    public boolean isShadowEnabled() {
        return this.isShadowEnabled;
    }

    public int getButtonColor() {
        return this.mButtonColor;
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public int getShadowHeight() {
        return this.mShadowHeight;
    }

    public int getCornerRadius() {
        return this.mCornerRadius;
    }
}

