/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.flexmojos.utilities;

import eu.cedarsoft.utils.ZipExtractor;
import info.flexmojos.utilities.ApplicationHandler;
import info.flexmojos.utilities.Namespace;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Build;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenUtils {
    private static final String WINDOWS_OS = "windows";
    private static final String MAC_OS = "mac os x";
    private static final String MAC_OS_DARWIN = "darwin";
    private static final String LINUX_OS = "linux";
    private static final String SOLARIS_OS = "sunos";
    private static final String VISTA = "vista";
    private static final Properties flexmojosProperties = new Properties();

    private MavenUtils() {
    }

    public static boolean isApplicationFile(File file) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.getXMLReader().setFeature("http://xml.org/sax/features/namespaces", true);
            parser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            ApplicationHandler h = new ApplicationHandler();
            parser.parse(file, (DefaultHandler)h);
            return h.isApplicationFile();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static File resolveSourceFile(MavenProject project, String sourceFileName) {
        List sourceRoots = project.getCompileSourceRoots();
        for (String sourceRoot : sourceRoots) {
            File sourceDirectory = new File(sourceRoot);
            if (sourceFileName != null) {
                File sourceFile = new File(sourceDirectory, sourceFileName);
                if (!sourceFile.exists()) continue;
                return sourceFile;
            }
            File[] files = sourceDirectory.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isFile() && (pathname.getName().endsWith(".mxml") || pathname.getName().endsWith(".as"));
                }
            });
            if (files.length == 1) {
                return files[0];
            }
            if (files.length <= 1) continue;
            for (File file : files) {
                if (!file.getName().equalsIgnoreCase("Main.mxml") && !file.getName().equalsIgnoreCase("Main.as")) continue;
                return file;
            }
            for (File file : files) {
                if (!file.getName().equalsIgnoreCase("Index.mxml") && !file.getName().equalsIgnoreCase("Index.as")) continue;
                return file;
            }
            ArrayList<File> appFiles = new ArrayList<File>();
            for (File file : files) {
                if (!file.getName().endsWith(".mxml") || !MavenUtils.isApplicationFile(file)) continue;
                appFiles.add(file);
            }
            if (appFiles.size() != 1) continue;
            File file = (File)appFiles.get(0);
            return file;
        }
        return null;
    }

    public static File resolveResourceFile(MavenProject project, String fileName) throws MojoFailureException {
        File file = new File(fileName);
        if (file.exists()) {
            return file;
        }
        if (file.isAbsolute()) {
            throw new MojoFailureException("File " + fileName + " not found");
        }
        List resources = project.getBuild().getResources();
        for (Resource resourceFolder : resources) {
            File resource = new File(resourceFolder.getDirectory(), fileName);
            if (!resource.exists()) continue;
            return resource;
        }
        throw new MojoFailureException("File " + fileName + " not found");
    }

    public static Set<Artifact> getDependencyArtifacts(MavenProject project, ArtifactResolver resolver, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource artifactMetadataSource) throws MojoExecutionException {
        ArtifactResolutionResult arr;
        try {
            arr = resolver.resolveTransitively(project.getDependencyArtifacts(), project.getArtifact(), remoteRepositories, localRepository, artifactMetadataSource);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        Set result = arr.getArtifacts();
        return result;
    }

    public static File getArtifactFile(Artifact a, Build build) throws MojoExecutionException {
        File dest = new File(build.getOutputDirectory(), "libraries/" + a.getArtifactId() + ".swc");
        if (!dest.exists()) {
            try {
                FileUtils.copyFile((File)a.getFile(), (File)dest);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        return dest;
    }

    public static void resolveArtifact(Artifact artifact, ArtifactResolver resolver, ArtifactRepository localRepository, List remoteRepositories) throws MojoExecutionException {
        try {
            resolver.resolve(artifact, remoteRepositories, localRepository);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public static File getConfigFile(Build build) throws MojoExecutionException {
        URL url = MavenUtils.class.getResource("/configs/config.xml");
        File configFile = new File(build.getOutputDirectory(), "config.xml");
        try {
            FileUtils.copyURLToFile((URL)url, (File)configFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating config file.", (Exception)e);
        }
        return configFile;
    }

    public static File getFontsFile(Build build) throws MojoExecutionException {
        URL url = MavenUtils.isMac() ? MavenUtils.class.getResource("/fonts/macFonts.ser") : MavenUtils.class.getResource("/fonts/winFonts.ser");
        File fontsSer = new File(build.getOutputDirectory(), "fonts.ser");
        try {
            FileUtils.copyURLToFile((URL)url, (File)fontsSer);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying fonts file.", (Exception)e);
        }
        return fontsSer;
    }

    public static File getLocaleResourcePath(String resourceBundlePath, String locale) throws MojoExecutionException {
        String path = resourceBundlePath.replace("{locale}", locale);
        File localePath = new File(path);
        if (!localePath.exists()) {
            throw new MojoExecutionException("Unable to find locales folder for : " + locale + "\n" + localePath.getAbsolutePath() + " does not exists.");
        }
        return localePath;
    }

    public static String osString() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isWindows() {
        return MavenUtils.osString().startsWith(WINDOWS_OS);
    }

    public static boolean isLinux() {
        return MavenUtils.osString().startsWith(LINUX_OS);
    }

    public static boolean isSolaris() {
        return MavenUtils.osString().startsWith(SOLARIS_OS);
    }

    public static boolean isUnixBased() {
        return MavenUtils.isLinux() || MavenUtils.isSolaris();
    }

    public static boolean isMac() {
        return MavenUtils.osString().startsWith(MAC_OS) || MavenUtils.osString().startsWith(MAC_OS_DARWIN);
    }

    public static boolean isWindowsVista() {
        return MavenUtils.osString().startsWith(WINDOWS_OS) && MavenUtils.osString().contains(VISTA);
    }

    public static Artifact searchFor(Collection<Artifact> artifacts, String groupId, String artifactId, String version, String type, String classifier) {
        for (Artifact artifact : artifacts) {
            if (!MavenUtils.equals(artifact.getGroupId(), groupId) || !MavenUtils.equals(artifact.getArtifactId(), artifactId) || !MavenUtils.equals(artifact.getVersion(), version) || !MavenUtils.equals(artifact.getType(), type) || !MavenUtils.equals(artifact.getClassifier(), classifier)) continue;
            return artifact;
        }
        return null;
    }

    private static boolean equals(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return true;
        }
        return str1.equals(str2);
    }

    private static Map<String, File> getFDKNamespaces(File configZip, Build build) throws MojoExecutionException {
        Document document;
        File outputFolder = new File(build.getOutputDirectory(), "configs");
        outputFolder.mkdirs();
        try {
            ZipExtractor ze = new ZipExtractor(configZip);
            ze.extract(outputFolder);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to extract configurations", (Exception)e);
        }
        File configFile = new File(outputFolder, "flex-config.xml");
        if (!configFile.isFile()) {
            return new HashMap<String, File>();
        }
        try {
            SAXBuilder parser = new SAXBuilder();
            document = parser.build(configFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error parsing config.xml", e);
        }
        return MavenUtils.readNamespaces(outputFolder, document);
    }

    static Map<String, File> readNamespaces(File outputFolder, Document document) {
        HashMap<String, File> namespaces = new HashMap<String, File>();
        Element node = document.getRootElement();
        if ((node = node.getChild("compiler")) == null) {
            return namespaces;
        }
        if ((node = node.getChild("namespaces")) == null) {
            return namespaces;
        }
        List namespacesNodes = node.getChildren();
        for (Element element : namespacesNodes) {
            Element uriNode = element.getChild("uri");
            Element manifestNode = element.getChild("manifest");
            String uri = uriNode.getValue();
            File manifest = new File(outputFolder, manifestNode.getValue());
            namespaces.put(uri, manifest);
        }
        return namespaces;
    }

    public static List<Namespace> getFdkNamespaces(Collection<Artifact> dependencies, Build build) throws MojoExecutionException {
        Artifact configArtifact = MavenUtils.searchFor(dependencies, "com.adobe.flex.framework", "framework", null, "zip", "configs");
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        if (configArtifact == null) {
            return namespaces;
        }
        File configZip = configArtifact.getFile();
        Map<String, File> configNamespaces = MavenUtils.getFDKNamespaces(configZip, build);
        Set<String> uris = configNamespaces.keySet();
        for (String uri : uris) {
            namespaces.add(new Namespace(uri, configNamespaces.get(uri)));
        }
        return namespaces;
    }

    public static String getFlexMojosVersion() {
        return flexmojosProperties.getProperty("version");
    }

    static {
        try {
            flexmojosProperties.load(MavenUtils.class.getResourceAsStream("/flexmojos.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load flexmojos.properties", e);
        }
    }
}

