/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.mojo.flexmojo.compiler;

import flex2.tools.oem.Builder;
import flex2.tools.oem.Configuration;
import flex2.tools.oem.Logger;
import flex2.tools.oem.PathResolver;
import flex2.tools.oem.Report;
import info.flexmojos.compatibilitykit.FlexCompatibility;
import info.flexmojos.compatibilitykit.FlexCompatibilityAspect;
import info.flexmojos.compatibilitykit.FlexMojo;
import info.flexmojos.utilities.Namespace;
import info.rvin.flexmojos.utilities.MavenUtils;
import info.rvin.mojo.flexmojo.AbstractIrvinMojo;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo$AjcClosure1;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo$AjcClosure11;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo$AjcClosure13;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo$AjcClosure15;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo$AjcClosure17;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo$AjcClosure19;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo$AjcClosure3;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo$AjcClosure5;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo$AjcClosure7;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo$AjcClosure9;
import info.rvin.mojo.flexmojo.compiler.CompileLogger;
import info.rvin.mojo.flexmojo.compiler.Font;
import info.rvin.mojo.flexmojo.compiler.FrameLabel;
import info.rvin.mojo.flexmojo.compiler.MavenArtifact;
import info.rvin.mojo.flexmojo.compiler.MavenPathResolver;
import info.rvin.mojo.flexmojo.compiler.Metadata;
import info.rvin.mojo.flexmojo.compiler.Warning;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.project.MavenProject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlexCompilerMojo<E extends Builder>
extends AbstractIrvinMojo
implements FlexMojo {
    private static final String COMPATIBILITY_2_0_0 = "2.0.0";
    private static final String COMPATIBILITY_2_0_1 = "2.0.1";
    private static final String COMPATIBILITY_3_0_0 = "3.0.0";
    private static final File[] licensePropertiesLocations;
    private boolean accessible;
    protected MojoExecution execution;
    protected MavenSession context;
    protected String[] locales;
    protected File[] sourcePaths;
    private boolean allowSourcePathOverlap;
    private boolean showWarnings;
    private Warning warnings;
    protected String debugPassword;
    private boolean keepGeneratedActionscript;
    private Namespace[] namespaces;
    private boolean optimize;
    private boolean incremental;
    private String[] keepAs3Metadatas;
    private boolean strict;
    private boolean as3;
    private boolean es;
    private boolean verboseStacktraces;
    private Font fonts;
    private boolean useNetwork;
    private Map<String, String> licenses;
    private Map<String, String> defines;
    private Properties definesDeclaration;
    private String contextRoot;
    protected boolean linkReport;
    private boolean configurationReport;
    protected MavenArtifact[] loadExterns;
    protected File configFile;
    private String targetPlayer;
    private String rawMetadata;
    private Metadata metadata;
    private String[] rslUrls;
    private String[] policyFileUrls;
    private File services;
    private Boolean mergeResourceBundle;
    protected String resourceBundlePath;
    private String compatibilityVersion;
    private String encoding;
    private File defaultsCss;
    private String defaultBackgroundColor;
    private int defaultFrameRate;
    private int scriptMaxRecursionDepth;
    private int scriptMaxExecutionTime;
    private int defaultSizeWidth;
    private int defaultSizeHeight;
    private String[] externs;
    private FrameLabel[] frames;
    private String[] includes;
    private boolean headlessServer;
    private boolean keepAllTypeSelectors;
    private boolean useResourceBundleMetadata;
    private boolean verifyDigests;
    private File compilationData;
    protected E builder;
    protected Configuration configuration;
    protected boolean isSetProjectFile = true;
    protected File linkReportFile;
    private boolean quick;
    private boolean enableMavenResourcesResolver;
    protected String[] runtimeLocales;
    protected String[] compiledLocales;
    private String[] themes;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        Factory factory = new Factory("AbstractFlexCompilerMojo.java", Class.forName("info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "setMavenPathResolver", "info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo", "", "", "", "void"), 997);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "configureFontsAntiAliasing", "info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo", "", "", "", "void"), 1167);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "enableFlashType", "info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo", "", "", "", "void"), 1168);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "addDefines", "info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo", "", "", "org.apache.maven.plugin.MojoExecutionException:", "void"), 1199);
        ajc$tjp_4 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "setCompatibilityMode", "info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo", "", "", "org.apache.maven.plugin.MojoExecutionException:", "void"), 1308);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "setTargetPlayer", "info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo", "", "", "org.apache.maven.plugin.MojoExecutionException:", "void"), 1312);
        ajc$tjp_6 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "verifyDigests", "info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo", "", "", "", "void"), 1349);
        ajc$tjp_7 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "setLocales2", "info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo", "[Ljava.lang.String;:", "locales:", "org.apache.maven.plugin.MojoExecutionException:", "void"), 1488);
        ajc$tjp_8 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "setLocales3", "info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo", "[Ljava.lang.String;:", "locales:", "", "void"), 1489);
        ajc$tjp_9 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "configureWarnings3", "info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo", "flex2.tools.oem.Configuration:", "cfg:", "", "void"), 1970);
        licensePropertiesLocations = new File[]{new File("C:/Documents and Settings/All Users/Application Data/Adobe/Flex/license.properties"), new File("C:/ProgramData/Adobe/Flex/license.properties"), new File("/Library/Application Support/Adobe/Flex/license.properties"), new File(System.getProperty("user.home"), ".adobe/Flex/license.properties")};
    }

    @Override
    public void setUp() throws MojoExecutionException, MojoFailureException {
        File cfg;
        List resources;
        this.processLocales();
        if (this.sourcePaths == null) {
            List sourceRoots = this.project.getExecutionProject() != null ? this.project.getExecutionProject().getCompileSourceRoots() : this.project.getCompileSourceRoots();
            List<File> sources = this.getValidSourceRoots(sourceRoots);
            if (this.compiledLocales != null) {
                sources.add(new File(this.resourceBundlePath));
            }
            this.sourcePaths = sources.toArray(new File[sources.size()]);
        }
        if (this.configFile == null) {
            resources = this.build.getResources();
            for (Resource resource : resources) {
                cfg = new File(resource.getDirectory(), "config.xml");
                if (!cfg.exists()) continue;
                this.configFile = cfg;
                break;
            }
        }
        if (this.configFile == null) {
            this.getLog().debug((CharSequence)"No config found, generating one!");
            this.configFile = MavenUtils.getConfigFile((Build)this.build);
        }
        if (!this.configFile.exists()) {
            throw new MojoExecutionException("Unable to find " + this.configFile);
        }
        this.getLog().info((CharSequence)("Using configuration file " + this.configFile));
        if (this.services == null) {
            resources = this.build.getResources();
            for (Resource resource : resources) {
                cfg = new File(resource.getDirectory(), "services-config.xml");
                if (!cfg.exists()) continue;
                this.services = cfg;
                break;
            }
        }
        if (this.rslUrls == null) {
            this.rslUrls = new String[]{"/{contextRoot}/rsl/{artifactId}-{version}.{extension}"};
        }
        if (this.policyFileUrls == null) {
            this.policyFileUrls = new String[]{""};
        }
        if (this.metadata == null) {
            Iterator iterator;
            this.metadata = new Metadata();
            if (this.project.getDevelopers() != null && !this.project.getDevelopers().isEmpty()) {
                List developers = this.project.getDevelopers();
                iterator = developers.iterator();
                if (iterator.hasNext()) {
                    Developer d = (Developer)iterator.next();
                    this.metadata.setCreator(d.getName());
                }
            }
            if (this.project.getContributors() != null && !this.project.getContributors().isEmpty()) {
                List contributors = this.project.getContributors();
                iterator = contributors.iterator();
                if (iterator.hasNext()) {
                    Contributor c = (Contributor)iterator.next();
                    this.metadata.setContributor(c.getName());
                }
            }
            this.metadata.setDate(new Date());
        }
        if (this.licenses == null) {
            this.licenses = this.getLicenses();
        }
        this.validateLocales(this.runtimeLocales);
        this.validateLocales(this.compiledLocales);
        this.configuration = this.builder.getDefaultConfiguration();
        this.configure();
        this.compilationData = new File(this.build.getDirectory(), String.valueOf(this.build.getFinalName()) + ".incr");
        AbstractFlexCompilerMojo abstractFlexCompilerMojo = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)abstractFlexCompilerMojo));
        Object[] objectArray = new Object[]{this, abstractFlexCompilerMojo, joinPoint};
        FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new AbstractFlexCompilerMojo$AjcClosure1(objectArray), joinPoint);
        this.getOutput().getParentFile().mkdirs();
    }

    private void processLocales() {
        if (this.locales != null) {
            if (this.mergeResourceBundle == null) {
                this.getLog().warn((CharSequence)"Not defined if locales should be merged or not");
                return;
            }
            if (this.mergeResourceBundle.booleanValue()) {
                this.compiledLocales = this.locales;
            } else {
                this.runtimeLocales = this.locales;
            }
        }
    }

    private void validateLocales(String ... locales) throws MojoExecutionException {
        if (locales == null) {
            return;
        }
        String[] stringArray = locales;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String locale = stringArray[n];
            MavenUtils.getLocaleResourcePath((String)this.resourceBundlePath, (String)locale);
            ++n;
        }
    }

    protected List<File> getValidSourceRoots(List<?> sourceRoots) {
        ArrayList<File> sources = new ArrayList<File>();
        for (Object sourceRoot : sourceRoots) {
            File source = new File(sourceRoot.toString());
            if (!source.exists()) continue;
            sources.add(source);
        }
        return sources;
    }

    @FlexCompatibility(minVersion="3")
    private void setMavenPathResolver() {
        if (this.enableMavenResourcesResolver) {
            this.builder.setPathResolver((PathResolver)new MavenPathResolver(this.build.getResources()));
        }
    }

    private Map<String, String> getLicenses() throws MojoExecutionException {
        File licensePropertyFile = null;
        File[] fileArray = licensePropertiesLocations;
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File lpl = fileArray[n];
            if (lpl.exists()) {
                licensePropertyFile = lpl;
                break;
            }
            ++n;
        }
        if (licensePropertyFile == null) {
            return null;
        }
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(licensePropertyFile));
        }
        catch (FileNotFoundException e) {
            this.getLog().warn((CharSequence)("Unable to read license files " + licensePropertyFile.getAbsolutePath()), (Throwable)e);
            return null;
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Unable to read license files " + licensePropertyFile.getAbsolutePath()), (Throwable)e);
            return null;
        }
        HashMap<String, String> licenses = new HashMap<String, String>();
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = props.getProperty(name);
            licenses.put(name, value);
        }
        return licenses;
    }

    @Override
    public void run() throws MojoExecutionException, MojoFailureException {
        this.builder.setLogger((Logger)new CompileLogger(this.getLog()));
        this.builder.setConfiguration(this.configuration);
        this.build(this.builder);
    }

    private OutputStream saveCompilationData() throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(this.compilationData));
    }

    private InputStream loadCompilationData() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.compilationData));
    }

    protected void configure() throws MojoExecutionException, MojoFailureException {
        int n;
        Object[] objectArray;
        File fontsSnapshot;
        this.resolveDependencies();
        this.configuration.enableAccessibility(this.accessible);
        this.configuration.allowSourcePathOverlap(this.allowSourcePathOverlap);
        this.configuration.useActionScript3(this.as3);
        this.configuration.enableDebugging(this.isDebug(), this.debugPassword);
        this.configuration.useECMAScript(this.es);
        if (this.fonts != null) {
            AbstractFlexCompilerMojo abstractFlexCompilerMojo = this;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)abstractFlexCompilerMojo));
            Object[] objectArray2 = new Object[]{this, abstractFlexCompilerMojo, joinPoint};
            FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new AbstractFlexCompilerMojo$AjcClosure3(objectArray2), joinPoint);
            AbstractFlexCompilerMojo abstractFlexCompilerMojo2 = this;
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)abstractFlexCompilerMojo2));
            Object[] objectArray3 = new Object[]{this, abstractFlexCompilerMojo2, joinPoint2};
            FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new AbstractFlexCompilerMojo$AjcClosure5(objectArray3), joinPoint2);
            this.configuration.setFontManagers(this.fonts.getManagers());
            this.configuration.setMaximumCachedFonts(this.fonts.getMaxCachedFonts());
            this.configuration.setMaximumGlyphsPerFace(this.fonts.getMaxGlyphsPerFace());
            if (this.fonts.getLanguages() != null && !this.fonts.getLanguages().isEmpty()) {
                for (String language : this.fonts.getLanguages().keySet()) {
                    this.configuration.setFontLanguageRange(language, this.fonts.getLanguages().get(language));
                }
            }
        }
        if ((fontsSnapshot = this.getFontsSnapshot()) == null || !fontsSnapshot.exists()) {
            throw new MojoExecutionException("LocalFontSnapshot not found " + fontsSnapshot);
        }
        this.configuration.setLocalFontSnapshot(fontsSnapshot);
        this.configuration.setActionScriptMetadata(this.keepAs3Metadatas);
        this.configuration.keepCompilerGeneratedActionScript(this.keepGeneratedActionscript);
        if (this.licenses != null) {
            for (String licenseName : this.licenses.keySet()) {
                String key = this.licenses.get(licenseName);
                this.configuration.setLicense(licenseName, key);
            }
        }
        AbstractFlexCompilerMojo abstractFlexCompilerMojo = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)abstractFlexCompilerMojo));
        Object[] objectArray4 = new Object[]{this, abstractFlexCompilerMojo, joinPoint};
        FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new AbstractFlexCompilerMojo$AjcClosure7(objectArray4), joinPoint);
        if (this.compiledLocales == null && this.runtimeLocales == null && this.isApplication()) {
            this.setLocales(this.getDefaultLocale());
        } else if (this.compiledLocales != null) {
            this.setLocales(this.compiledLocales);
        } else {
            this.setLocales(new String[0]);
        }
        List fdkNamespaces = MavenUtils.getFdkNamespaces(this.getDependencyArtifacts(), (Build)this.build);
        if (this.namespaces != null) {
            fdkNamespaces.addAll((Collection)Arrays.asList(this.namespaces));
        }
        this.namespaces = fdkNamespaces.toArray(new Namespace[0]);
        if (this.namespaces != null) {
            objectArray = this.namespaces;
            int key = 0;
            n = objectArray.length;
            while (key < n) {
                Namespace namespace = objectArray[key];
                File manifest = namespace.getManifest();
                this.configuration.setComponentManifest(namespace.getUri(), manifest);
                ++key;
            }
        }
        this.configuration.optimize(this.optimize);
        if (this.warnings != null) {
            this.configureWarnings(this.configuration);
        }
        this.configuration.setSourcePath(this.sourcePaths);
        this.configuration.enableStrictChecking(this.strict);
        this.configuration.useNetwork(this.useNetwork);
        this.configuration.enableVerboseStacktraces(this.verboseStacktraces);
        if (this.contextRoot != null) {
            this.configuration.setContextRoot(this.contextRoot);
        }
        this.configuration.keepLinkReport(this.linkReport);
        this.configuration.keepConfigurationReport(this.configurationReport);
        this.configuration.setConfiguration(this.configFile);
        this.configuration.setServiceConfiguration(this.services);
        if (this.loadExterns != null) {
            ArrayList<File> externsFiles = new ArrayList<File>();
            MavenArtifact[] mavenArtifactArray = this.loadExterns;
            n = 0;
            int n2 = mavenArtifactArray.length;
            while (n < n2) {
                MavenArtifact mvnArtifact = mavenArtifactArray[n];
                Artifact artifact = this.artifactFactory.createArtifactWithClassifier(mvnArtifact.getGroupId(), mvnArtifact.getArtifactId(), mvnArtifact.getVersion(), "xml", "link-report");
                MavenUtils.resolveArtifact((Artifact)artifact, (ArtifactResolver)this.resolver, (ArtifactRepository)this.localRepository, (List)this.remoteRepositories);
                externsFiles.add(artifact.getFile());
                ++n;
            }
            this.configuration.setExterns(externsFiles.toArray(new File[externsFiles.size()]));
        }
        if (this.rawMetadata != null) {
            this.configuration.setSWFMetaData(this.rawMetadata);
        }
        if (this.metadata != null) {
            if (this.metadata.getContributor() != null) {
                this.configuration.setSWFMetaData(1, (Object)this.metadata.getContributor());
            }
            if (this.metadata.getCreator() != null) {
                this.configuration.setSWFMetaData(2, (Object)this.metadata.getCreator());
            }
            if (this.metadata.getDate() != null) {
                this.configuration.setSWFMetaData(4, (Object)this.metadata.getDate());
            }
            if (this.metadata.getDescriptions() != null) {
                this.configuration.setSWFMetaData(8, this.metadata.getDescriptions());
            }
            if (this.metadata.getTitles() != null) {
                this.configuration.setSWFMetaData(16, this.metadata.getTitles());
            }
            if (this.metadata.getLanguage() != null) {
                this.configuration.setSWFMetaData(32, (Object)this.metadata.getLanguage());
            }
        }
        AbstractFlexCompilerMojo abstractFlexCompilerMojo3 = this;
        JoinPoint joinPoint3 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)abstractFlexCompilerMojo3));
        Object[] objectArray5 = new Object[]{this, abstractFlexCompilerMojo3, joinPoint3};
        FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new AbstractFlexCompilerMojo$AjcClosure9(objectArray5), joinPoint3);
        this.configuration.setActionScriptFileEncoding(this.encoding);
        AbstractFlexCompilerMojo abstractFlexCompilerMojo4 = this;
        JoinPoint joinPoint4 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)abstractFlexCompilerMojo4));
        Object[] objectArray6 = new Object[]{this, abstractFlexCompilerMojo4, joinPoint4};
        FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new AbstractFlexCompilerMojo$AjcClosure11(objectArray6), joinPoint4);
        if (this.defaultsCss != null) {
            this.configuration.setDefaultCSS(this.defaultsCss);
        }
        this.configuration.setDefaultBackgroundColor(Integer.parseInt(this.defaultBackgroundColor, 16));
        this.configuration.setDefaultFrameRate(this.defaultFrameRate);
        this.configuration.setDefaultScriptLimits(this.scriptMaxRecursionDepth, this.scriptMaxExecutionTime);
        this.configuration.setDefaultSize(this.defaultSizeWidth, this.defaultSizeHeight);
        if (this.externs != null && this.externs.length > 0) {
            this.configuration.setExterns(this.externs);
        }
        if (this.frames != null && this.frames.length > 0) {
            objectArray = this.frames;
            int n3 = 0;
            n = objectArray.length;
            while (n3 < n) {
                Namespace frame = objectArray[n3];
                this.configuration.setFrameLabel(frame.getLabel(), frame.getClassNames());
                ++n3;
            }
        }
        if (this.includes != null && this.includes.length > 0) {
            this.configuration.setIncludes(this.includes);
        }
        this.configuration.useHeadlessServer(this.headlessServer);
        this.configuration.keepAllTypeSelectors(this.keepAllTypeSelectors);
        this.configuration.useResourceBundleMetaData(this.useResourceBundleMetadata);
        AbstractFlexCompilerMojo abstractFlexCompilerMojo5 = this;
        JoinPoint joinPoint5 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)abstractFlexCompilerMojo5));
        Object[] objectArray7 = new Object[]{this, abstractFlexCompilerMojo5, joinPoint5};
        FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new AbstractFlexCompilerMojo$AjcClosure13(objectArray7), joinPoint5);
    }

    protected abstract String getDefaultLocale();

    protected abstract boolean isApplication();

    protected abstract boolean isDebug();

    protected void resolveDependencies() throws MojoExecutionException, MojoFailureException {
        this.configuration.setExternalLibraryPath(this.getGlobalDependency());
        this.configuration.addExternalLibraryPath(this.getDependenciesPath("external"));
        this.configuration.includeLibraries(this.getDependenciesPath("internal"));
        this.configuration.setLibraryPath(this.getDependenciesPath("compile"));
        this.configuration.addLibraryPath(this.getDependenciesPath("merged"));
        if (this.compiledLocales == null && this.runtimeLocales == null && this.isApplication()) {
            this.configuration.addLibraryPath(this.getResourcesBundles(this.getDefaultLocale()));
        } else if (this.compiledLocales != null) {
            this.configuration.addLibraryPath(this.getResourcesBundles(this.compiledLocales));
        }
        this.resolveRuntimeLibraries();
        this.configuration.setTheme(this.getThemes());
    }

    protected File[] getThemes() throws MojoExecutionException, MojoFailureException {
        ArrayList<File> themeFiles = new ArrayList<File>();
        if (this.themes != null) {
            String[] stringArray = this.themes;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String theme = stringArray[n];
                File themeFile = MavenUtils.resolveResourceFile((MavenProject)this.project, (String)theme);
                themeFiles.add(themeFile);
                ++n;
            }
        }
        themeFiles.addAll((Collection)Arrays.asList(this.getDependenciesPath("theme")));
        if (themeFiles.isEmpty()) {
            return null;
        }
        return themeFiles.toArray(new File[0]);
    }

    @FlexCompatibility(maxVersion="2")
    private void enableFlashType() {
        this.configuration.enableFlashType(this.fonts.isFlashType());
    }

    @FlexCompatibility(minVersion="3")
    private void verifyDigests() {
        this.configuration.enableDigestVerification(this.verifyDigests);
    }

    @FlexCompatibility(minVersion="3")
    private void setTargetPlayer() throws MojoExecutionException {
        if (this.targetPlayer != null) {
            String[] nodes = this.targetPlayer.split("\\.");
            if (nodes.length != 3) {
                throw new MojoExecutionException("Invalid player version " + this.targetPlayer);
            }
            int[] versions = new int[nodes.length];
            int i = 0;
            while (i < nodes.length) {
                try {
                    versions[i] = Integer.parseInt(nodes[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MojoExecutionException("Invalid player version " + this.targetPlayer);
                }
                ++i;
            }
            if (versions[0] < 9) {
                throw new MojoExecutionException("Invalid player version " + this.targetPlayer);
            }
            this.configuration.setTargetPlayer(versions[0], versions[1], versions[2]);
        }
    }

    @FlexCompatibility(minVersion="3")
    private void setCompatibilityMode() throws MojoExecutionException {
        if (this.compatibilityVersion != null) {
            if (!(COMPATIBILITY_2_0_0.equals(this.compatibilityVersion) || COMPATIBILITY_2_0_1.equals(this.compatibilityVersion) || COMPATIBILITY_3_0_0.equals(this.compatibilityVersion))) {
                throw new MojoExecutionException("Invalid compatibility version " + this.compatibilityVersion);
            }
            if (COMPATIBILITY_2_0_0.equals(this.compatibilityVersion)) {
                this.configuration.setCompatibilityVersion(2, 0, 0);
            } else if (COMPATIBILITY_2_0_1.equals(this.compatibilityVersion)) {
                this.configuration.setCompatibilityVersion(2, 0, 1);
            } else if (COMPATIBILITY_3_0_0.equals(this.compatibilityVersion)) {
                this.configuration.setCompatibilityVersion(3, 0, 0);
            } else {
                throw new IllegalStateException("Should never reach this");
            }
        }
    }

    protected void setLocales(String ... locales) throws MojoExecutionException {
        String[] stringArray = locales;
        AbstractFlexCompilerMojo abstractFlexCompilerMojo = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)abstractFlexCompilerMojo), (Object)stringArray);
        Object[] objectArray = new Object[]{this, abstractFlexCompilerMojo, stringArray, joinPoint};
        FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new AbstractFlexCompilerMojo$AjcClosure15(objectArray), joinPoint);
        String[] stringArray2 = locales;
        AbstractFlexCompilerMojo abstractFlexCompilerMojo2 = this;
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)abstractFlexCompilerMojo2), (Object)stringArray2);
        Object[] objectArray2 = new Object[]{this, abstractFlexCompilerMojo2, stringArray2, joinPoint2};
        FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new AbstractFlexCompilerMojo$AjcClosure17(objectArray2), joinPoint2);
    }

    @FlexCompatibility(minVersion="3")
    private void setLocales3(String[] locales) {
        this.configuration.setLocale(locales);
    }

    @FlexCompatibility(maxVersion="2")
    private void setLocales2(String[] locales) throws MojoExecutionException {
        if (locales.length == 1) {
            this.configuration.setLocale(new Locale(locales[0]));
        } else if (locales.length != 0) {
            throw new MojoExecutionException("Only one locale is allowed");
        }
    }

    @FlexCompatibility(minVersion="3")
    private void addDefines() throws MojoExecutionException {
        PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(this.context, this.execution, null, null, this.project, this.project.getProperties());
        if (this.defines != null) {
            if (this.definesDeclaration == null) {
                this.definesDeclaration = new Properties();
            }
            this.definesDeclaration.putAll(this.defines);
        }
        if (this.definesDeclaration != null) {
            for (Object definekey : this.definesDeclaration.keySet()) {
                String defineName = definekey.toString();
                String value = this.definesDeclaration.getProperty(defineName);
                if (value.contains("${")) {
                    try {
                        value = (String)expressionEvaluator.evaluate(value);
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new MojoExecutionException("Expression error in " + defineName, (Exception)((Object)e));
                    }
                }
                this.getLog().debug((CharSequence)("define " + defineName + " = " + value));
                this.configuration.addDefineDirective(defineName, value);
            }
        }
    }

    @FlexCompatibility(minVersion="3")
    private void configureFontsAntiAliasing() {
        this.configuration.enableAdvancedAntiAliasing(this.fonts.isAdvancedAntiAliasing());
    }

    protected File[] getGlobalDependency() throws MojoExecutionException {
        Set<Artifact> dependencies = this.getDependencyArtifacts();
        for (Artifact artifact : dependencies) {
            if (!"playerglobal".equals(artifact.getArtifactId()) && !"airglobal".equals(artifact.getArtifactId())) continue;
            return new File[]{MavenUtils.getArtifactFile((Artifact)artifact, (Build)this.build)};
        }
        throw new MojoExecutionException("Player/Air Global dependency not found.");
    }

    private void resolveRuntimeLibraries() throws MojoExecutionException {
        List<Artifact> rsls = this.getDependencyArtifacts("rsl", "caching");
        this.rslsSort(rsls);
        for (Artifact artifact : rsls) {
            String scope = artifact.getScope();
            File artifactFile = artifact.getFile();
            String artifactPath = artifactFile.getAbsolutePath();
            String extension = "caching".equals(scope) ? "swz" : "swf";
            String[] rslUrls = this.getRslUrls(artifact, extension);
            String[] rslPolicyFileUrls = this.getRslPolicyFileUrls(artifact);
            this.configuration.addRuntimeSharedLibraryPath(artifactPath, rslUrls, rslPolicyFileUrls);
        }
    }

    public void rslsSort(List<Artifact> rslArtifacts) throws MojoExecutionException {
        Map<Artifact, List<Artifact>> dependencies = this.getDependencies(rslArtifacts);
        ArrayList<Artifact> ordered = new ArrayList<Artifact>();
        for (Artifact a : rslArtifacts) {
            if (dependencies.get(a) != null && !dependencies.get(a).isEmpty()) continue;
            ordered.add(a);
        }
        rslArtifacts.removeAll(ordered);
        while (!rslArtifacts.isEmpty()) {
            int original = rslArtifacts.size();
            for (Artifact a : rslArtifacts) {
                List<Artifact> deps = dependencies.get(a);
                if (!ordered.containsAll(deps)) continue;
                ordered.add(a);
            }
            rslArtifacts.removeAll(ordered);
            if (original != rslArtifacts.size()) continue;
            throw new MojoExecutionException("Unable to resolve " + rslArtifacts);
        }
        rslArtifacts.addAll(ordered);
    }

    private Map<Artifact, List<Artifact>> getDependencies(List<Artifact> rslArtifacts) throws MojoExecutionException {
        HashMap<Artifact, List<Artifact>> dependencies = new HashMap<Artifact, List<Artifact>>();
        for (Artifact pomArtifact : rslArtifacts) {
            try {
                MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteRepositories, this.localRepository);
                Set pomArtifacts = pomProject.createArtifacts(this.artifactFactory, null, null);
                ArtifactResolutionResult arr = this.resolver.resolveTransitively(pomArtifacts, pomArtifact, this.remoteRepositories, this.localRepository, this.artifactMetadataSource);
                List<Artifact> artifactDependencies = new ArrayList<Artifact>(arr.getArtifacts());
                artifactDependencies = this.removeNonRSLDependencies(rslArtifacts, artifactDependencies);
                dependencies.put(pomArtifact, artifactDependencies);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        return dependencies;
    }

    private List<Artifact> removeNonRSLDependencies(List<Artifact> rslArtifacts, List<Artifact> artifactDependencies) {
        ArrayList<Artifact> cleanArtifacts = new ArrayList<Artifact>();
        block0: for (Artifact artifact : artifactDependencies) {
            for (Artifact rslArtifact : rslArtifacts) {
                if (!artifact.getGroupId().equals(rslArtifact.getGroupId()) || !artifact.getArtifactId().equals(rslArtifact.getArtifactId()) || !artifact.getType().equals(rslArtifact.getType())) continue;
                cleanArtifacts.add(rslArtifact);
                continue block0;
            }
        }
        return cleanArtifacts;
    }

    private String[] getRslPolicyFileUrls(Artifact artifact) {
        String[] domains = new String[this.policyFileUrls.length];
        int i = 0;
        while (i < this.policyFileUrls.length) {
            String domain = this.policyFileUrls[i];
            if (this.contextRoot != null) {
                domain = domain.replace("{contextRoot}", this.contextRoot);
            }
            domain = domain.replace("{groupId}", artifact.getGroupId());
            domain = domain.replace("{artifactId}", artifact.getArtifactId());
            domains[i] = domain = domain.replace("{version}", artifact.getVersion());
            ++i;
        }
        return domains;
    }

    private String[] getRslUrls(Artifact artifact, String extension) {
        String[] rsls = new String[this.rslUrls.length];
        int i = 0;
        while (i < this.rslUrls.length) {
            String rsl = this.rslUrls[i];
            if (this.contextRoot != null) {
                rsl = rsl.replace("{contextRoot}", this.contextRoot);
            }
            rsl = rsl.replace("{groupId}", artifact.getGroupId());
            rsl = rsl.replace("{artifactId}", artifact.getArtifactId());
            rsl = rsl.replace("{version}", artifact.getVersion());
            rsls[i] = rsl = rsl.replace("{extension}", extension);
            ++i;
        }
        return rsls;
    }

    protected File getFontsSnapshot() throws MojoExecutionException {
        if (this.fonts != null && this.fonts.getLocalFontsSnapshot() != null) {
            return this.fonts.getLocalFontsSnapshot();
        }
        this.getLog().debug((CharSequence)"No fonts snapshot found, generating one!");
        return MavenUtils.getFontsFile((Build)this.build);
    }

    protected File[] getResourcesBundles(String ... requestedLocales) throws MojoExecutionException {
        if (requestedLocales == null) {
            return new File[0];
        }
        ArrayList<File> resourceBundles = new ArrayList<File>();
        for (Artifact resourceBundleBeacon : this.getDependencyArtifacts()) {
            if (!"rb.swc".equals(resourceBundleBeacon.getType())) continue;
            String[] stringArray = requestedLocales;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String requestLocale = stringArray[n];
                Artifact resolvedResourceBundle = this.artifactFactory.createArtifactWithClassifier(resourceBundleBeacon.getGroupId(), resourceBundleBeacon.getArtifactId(), resourceBundleBeacon.getVersion(), resourceBundleBeacon.getType(), requestLocale);
                MavenUtils.resolveArtifact((Artifact)resolvedResourceBundle, (ArtifactResolver)this.resolver, (ArtifactRepository)this.localRepository, (List)this.remoteRepositories);
                resourceBundles.add(resolvedResourceBundle.getFile());
                ++n;
            }
        }
        this.getLog().debug((CharSequence)("getResourcesBundles(" + requestedLocales + ") returning resourceBundles: " + resourceBundles));
        return resourceBundles.toArray(new File[resourceBundles.size()]);
    }

    protected File[] getDependenciesPath(String scope) throws MojoExecutionException {
        if (scope == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (Artifact a : this.getDependencyArtifacts(scope)) {
            if ("playerglobal".equals(a.getArtifactId()) || "airglobal".equals(a.getArtifactId())) continue;
            files.add(a.getFile());
        }
        return files.toArray(new File[files.size()]);
    }

    @Override
    protected void tearDown() throws MojoExecutionException, MojoFailureException {
        if (this.isSetProjectFile) {
            this.project.getArtifact().setFile(this.getOutput());
        }
        Report report = this.builder.getReport();
        if (this.linkReport) {
            this.writeLinkReport(report);
        }
        if (this.configurationReport) {
            this.writeConfigurationReport(report);
        }
        if (this.runtimeLocales != null) {
            this.writeResourceBundle(report);
        }
    }

    private void writeResourceBundle(Report report) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Compiling resources bundles!");
        String[] bundles = report.getResourceBundleNames();
        if (bundles == null || bundles.length == 0) {
            this.getLog().warn((CharSequence)"Resource-bundle generation fail: No resource-bundle found.");
            return;
        }
        try {
            File tempFile = File.createTempFile(this.build.getFinalName(), ".rb.swc");
            tempFile.deleteOnExit();
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("/rb.swc"), (File)tempFile);
            this.getLog().info((CharSequence)("Installing resource bundle beacon: " + tempFile));
            this.projectHelper.attachArtifact(this.project, "resource-bundle", tempFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create beacon resource bundle. " + this.build.getFinalName() + ".rb.swc", (Exception)e);
        }
        String[] stringArray = this.runtimeLocales;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String locale = stringArray[n];
            this.getLog().info((CharSequence)("Generating resource-bundle for " + locale));
            File localePath = MavenUtils.getLocaleResourcePath((String)this.resourceBundlePath, (String)locale);
            if (!localePath.exists()) {
                this.getLog().error((CharSequence)("Unable to find locales path: " + localePath.getAbsolutePath()));
            } else {
                this.writeResourceBundle(bundles, locale, localePath);
            }
            ++n;
        }
    }

    protected abstract void writeResourceBundle(String[] var1, String var2, File var3) throws MojoExecutionException;

    private void configureWarnings(Configuration cfg) {
        cfg.showActionScriptWarnings(this.showWarnings);
        cfg.showBindingWarnings(this.warnings.getBinding());
        cfg.showDeprecationWarnings(this.warnings.getDeprecation());
        cfg.showUnusedTypeSelectorWarnings(this.warnings.getUnusedTypeSelector());
        cfg.checkActionScriptWarning(1044, this.warnings.getArrayTostringChanges());
        cfg.checkActionScriptWarning(1100, this.warnings.getAssignmentWithinConditional());
        cfg.checkActionScriptWarning(1112, this.warnings.getBadArrayCast());
        cfg.checkActionScriptWarning(3590, this.warnings.getBadBooleanAssignment());
        cfg.checkActionScriptWarning(3575, this.warnings.getBadDateCast());
        cfg.checkActionScriptWarning(3594, this.warnings.getBadEs3TypeMethod());
        cfg.checkActionScriptWarning(3592, this.warnings.getBadEs3TypeProp());
        cfg.checkActionScriptWarning(1098, this.warnings.getBadNanComparison());
        cfg.checkActionScriptWarning(1102, this.warnings.getBadNullAssignment());
        cfg.checkActionScriptWarning(1096, this.warnings.getBadNullComparison());
        cfg.checkActionScriptWarning(1012, this.warnings.getBadUndefinedComparison());
        cfg.checkActionScriptWarning(1034, this.warnings.getBooleanConstructorWithNoArgs());
        cfg.checkActionScriptWarning(1066, this.warnings.getChangesInResolve());
        cfg.checkActionScriptWarning(1072, this.warnings.getClassIsSealed());
        cfg.checkActionScriptWarning(1110, this.warnings.getConstNotInitialized());
        cfg.checkActionScriptWarning(1030, this.warnings.getConstructorReturnsValue());
        cfg.checkActionScriptWarning(1090, this.warnings.getDeprecatedEventHandlerError());
        cfg.checkActionScriptWarning(1060, this.warnings.getDeprecatedFunctionError());
        cfg.checkActionScriptWarning(1058, this.warnings.getDeprecatedPropertyError());
        cfg.checkActionScriptWarning(3583, this.warnings.getDuplicateArgumentNames());
        cfg.checkActionScriptWarning(3596, this.warnings.getDuplicateVariableDef());
        cfg.checkActionScriptWarning(1086, this.warnings.getForVarInChanges());
        cfg.checkActionScriptWarning(3581, this.warnings.getImportHidesClass());
        cfg.checkActionScriptWarning(3555, this.warnings.getInstanceOfChanges());
        cfg.checkActionScriptWarning(1088, this.warnings.getInternalError());
        cfg.checkActionScriptWarning(1070, this.warnings.getLevelNotSupported());
        cfg.checkActionScriptWarning(1084, this.warnings.getMissingNamespaceDecl());
        cfg.checkActionScriptWarning(1092, this.warnings.getNegativeUintLiteral());
        cfg.checkActionScriptWarning(1104, this.warnings.getNoConstructor());
        cfg.checkActionScriptWarning(1114, this.warnings.getNoExplicitSuperCallInConstructor());
        cfg.checkActionScriptWarning(1008, this.warnings.getNoTypeDecl());
        cfg.checkActionScriptWarning(1038, this.warnings.getNumberFromStringChanges());
        cfg.checkActionScriptWarning(1082, this.warnings.getScopingChangeInThis());
        cfg.checkActionScriptWarning(3551, this.warnings.getSlowTextFieldAddition());
        cfg.checkActionScriptWarning(3553, this.warnings.getUnlikelyFunctionValue());
        cfg.checkActionScriptWarning(3573, this.warnings.getXmlClassHasChanged());
        Configuration configuration = cfg;
        AbstractFlexCompilerMojo abstractFlexCompilerMojo = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)abstractFlexCompilerMojo), (Object)configuration);
        Object[] objectArray = new Object[]{this, abstractFlexCompilerMojo, configuration, joinPoint};
        FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new AbstractFlexCompilerMojo$AjcClosure19(objectArray), joinPoint);
    }

    @FlexCompatibility(minVersion="3")
    private void configureWarnings3(Configuration cfg) {
        cfg.showShadowedDeviceFontWarnings(this.warnings.getShadowedDeviceFont());
    }

    private void writeLinkReport(Report report) throws MojoExecutionException {
        this.writeReport(report, "link");
    }

    private void writeConfigurationReport(Report report) throws MojoExecutionException {
        this.writeReport(report, "config");
    }

    private void writeReport(Report report, String type) throws MojoExecutionException {
        File fileReport = new File(this.build.getDirectory(), String.valueOf(this.project.getArtifactId()) + "-" + this.project.getVersion() + "-" + type + "-report.xml");
        try {
            StringWriter writer = new StringWriter();
            if ("link".equals(type)) {
                report.writeLinkReport((Writer)writer);
                this.linkReportFile = fileReport;
            } else if ("config".equals(type)) {
                report.writeConfigurationReport((Writer)writer);
            }
            FileUtils.writeStringToFile((File)fileReport, (String)writer.toString());
            this.getLog().info((CharSequence)("Written " + type + " report to " + fileReport));
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error has ocurried while recording " + type + "-report", (Exception)e);
        }
        this.projectHelper.attachArtifact(this.project, "xml", String.valueOf(type) + "-report", fileReport);
    }

    protected void build(E builder) throws MojoExecutionException {
        long bytes;
        if (!this.isCompilationRequired()) {
            return;
        }
        this.getLog().info((CharSequence)("Flex compiler configurations:" + this.configuration.toString().replace("--", "\n-")));
        try {
            if (this.incremental && this.compilationData.exists()) {
                builder.load(this.loadCompilationData());
            }
            bytes = builder.build(this.incremental);
            if (this.incremental) {
                if (this.compilationData.exists()) {
                    this.compilationData.delete();
                    this.compilationData.createNewFile();
                }
                builder.save(this.saveCompilationData());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        if (bytes == 0L) {
            throw new MojoExecutionException("Error compiling!");
        }
    }

    private boolean isCompilationRequired() throws MojoExecutionException {
        String locale;
        int n;
        int n2;
        String[] stringArray;
        if (!this.quick) {
            return true;
        }
        Artifact artifact = this.artifactFactory.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, this.project.getPackaging());
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (AbstractArtifactResolutionException abstractArtifactResolutionException) {
            return true;
        }
        File artifactFile = artifact.getFile();
        if (artifactFile == null || !artifactFile.exists()) {
            this.getLog().warn((CharSequence)"Can't find any older instaled version.");
            return true;
        }
        try {
            FileUtils.copyFile((File)artifactFile, (File)this.getOutput());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy instaled version to target folder.", (Exception)e);
        }
        long lastCompiledArtifact = artifactFile.lastModified();
        Set<Artifact> dependencies = this.getDependencyArtifacts();
        for (Artifact dependency : dependencies) {
            if (!FileUtils.isFileNewer((File)dependency.getFile(), (long)lastCompiledArtifact)) continue;
            this.getLog().warn((CharSequence)("Found a updated dependency: " + dependency));
            return true;
        }
        ArrayList<File> paths = new ArrayList<File>((Collection)Arrays.asList(this.sourcePaths));
        if (this.compiledLocales != null) {
            paths.remove(new File(this.resourceBundlePath));
            stringArray = this.compiledLocales;
            n2 = 0;
            n = stringArray.length;
            while (n2 < n) {
                locale = stringArray[n2];
                paths.add(MavenUtils.getLocaleResourcePath((String)this.resourceBundlePath, (String)locale));
                ++n2;
            }
        }
        if (this.runtimeLocales != null) {
            stringArray = this.runtimeLocales;
            n2 = 0;
            n = stringArray.length;
            while (n2 < n) {
                locale = stringArray[n2];
                paths.add(MavenUtils.getLocaleResourcePath((String)this.resourceBundlePath, (String)locale));
                ++n2;
            }
        }
        for (File sourcePath : paths) {
            Collection files = FileUtils.listFiles((File)sourcePath, (IOFileFilter)new AgeFileFilter(lastCompiledArtifact, false), (IOFileFilter)TrueFileFilter.INSTANCE);
            if (files.size() <= 0) continue;
            this.getLog().warn((CharSequence)"Found some updated files.");
            return true;
        }
        return false;
    }

    public String getFDKVersion() {
        Artifact compiler = MavenUtils.searchFor((Collection)this.pluginArtifacts, (String)"com.adobe.flex", (String)"compiler", null, (String)"pom", null);
        return compiler.getVersion();
    }

    protected abstract File getOutput();

    static final /* synthetic */ void setMavenPathResolver_aroundBody0(AbstractFlexCompilerMojo abstractFlexCompilerMojo, AbstractFlexCompilerMojo abstractFlexCompilerMojo2, JoinPoint joinPoint) {
        abstractFlexCompilerMojo2.setMavenPathResolver();
    }

    static final /* synthetic */ void configureFontsAntiAliasing_aroundBody2(AbstractFlexCompilerMojo abstractFlexCompilerMojo, AbstractFlexCompilerMojo abstractFlexCompilerMojo2, JoinPoint joinPoint) {
        abstractFlexCompilerMojo2.configureFontsAntiAliasing();
    }

    static final /* synthetic */ void enableFlashType_aroundBody4(AbstractFlexCompilerMojo abstractFlexCompilerMojo, AbstractFlexCompilerMojo abstractFlexCompilerMojo2, JoinPoint joinPoint) {
        abstractFlexCompilerMojo2.enableFlashType();
    }

    static final /* synthetic */ void addDefines_aroundBody6(AbstractFlexCompilerMojo abstractFlexCompilerMojo, AbstractFlexCompilerMojo abstractFlexCompilerMojo2, JoinPoint joinPoint) {
        abstractFlexCompilerMojo2.addDefines();
    }

    static final /* synthetic */ void setCompatibilityMode_aroundBody8(AbstractFlexCompilerMojo abstractFlexCompilerMojo, AbstractFlexCompilerMojo abstractFlexCompilerMojo2, JoinPoint joinPoint) {
        abstractFlexCompilerMojo2.setCompatibilityMode();
    }

    static final /* synthetic */ void setTargetPlayer_aroundBody10(AbstractFlexCompilerMojo abstractFlexCompilerMojo, AbstractFlexCompilerMojo abstractFlexCompilerMojo2, JoinPoint joinPoint) {
        abstractFlexCompilerMojo2.setTargetPlayer();
    }

    static final /* synthetic */ void verifyDigests_aroundBody12(AbstractFlexCompilerMojo abstractFlexCompilerMojo, AbstractFlexCompilerMojo abstractFlexCompilerMojo2, JoinPoint joinPoint) {
        abstractFlexCompilerMojo2.verifyDigests();
    }

    static final /* synthetic */ void setLocales2_aroundBody14(AbstractFlexCompilerMojo abstractFlexCompilerMojo, AbstractFlexCompilerMojo abstractFlexCompilerMojo2, String[] stringArray, JoinPoint joinPoint) {
        abstractFlexCompilerMojo2.setLocales2(stringArray);
    }

    static final /* synthetic */ void setLocales3_aroundBody16(AbstractFlexCompilerMojo abstractFlexCompilerMojo, AbstractFlexCompilerMojo abstractFlexCompilerMojo2, String[] stringArray, JoinPoint joinPoint) {
        abstractFlexCompilerMojo2.setLocales3(stringArray);
    }

    static final /* synthetic */ void configureWarnings3_aroundBody18(AbstractFlexCompilerMojo abstractFlexCompilerMojo, AbstractFlexCompilerMojo abstractFlexCompilerMojo2, Configuration configuration, JoinPoint joinPoint) {
        abstractFlexCompilerMojo2.configureWarnings3(configuration);
    }
}

