/*
 * Decompiled with CFR 0.152.
 */
package info.rvin.mojo.flexmojo.compiler;

import flex2.tools.Compiler;
import flex2.tools.oem.Application;
import flex2.tools.oem.Logger;
import info.flexmojos.compatibilitykit.FlexCompatibility;
import info.flexmojos.compatibilitykit.FlexCompatibilityAspect;
import info.flexmojos.utilities.FlashPlayerUtils;
import info.rvin.flexmojos.utilities.MavenUtils;
import info.rvin.mojo.flexmojo.compiler.AbstractFlexCompilerMojo;
import info.rvin.mojo.flexmojo.compiler.ApplicationMojo$AjcClosure1;
import info.rvin.mojo.flexmojo.compiler.ApplicationMojo$AjcClosure3;
import info.rvin.mojo.flexmojo.compiler.CompileLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationMojo
extends AbstractFlexCompilerMojo<Application> {
    protected String sourceFile;
    private String[] moduleFiles;
    private List<File> modules;
    private boolean loadExternsOnModules;
    protected File source;
    private boolean updateSecuritySandbox;
    private boolean debug;
    private String defaultLocale;
    protected File output;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Override
    public void setUp() throws MojoExecutionException, MojoFailureException {
        File sourceDirectory = new File(this.build.getSourceDirectory());
        if (!sourceDirectory.exists()) {
            throw new MojoExecutionException("Unable to found sourceDirectory: " + sourceDirectory);
        }
        if (this.source == null) {
            this.getLog().warn((CharSequence)"Source file was not defined, flex-mojos will guess one.");
            this.source = MavenUtils.resolveSourceFile((MavenProject)this.project, (String)this.sourceFile);
        }
        if (this.source == null) {
            throw new MojoExecutionException("Source file not expecified and no default found!");
        }
        if (!this.source.exists()) {
            throw new MojoFailureException("Unable to find " + this.sourceFile);
        }
        try {
            this.builder = new Application(this.source);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MojoFailureException("Unable to find " + this.source);
        }
        if (this.moduleFiles != null) {
            this.modules = new ArrayList<File>();
            String[] stringArray = this.moduleFiles;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String modulePath = stringArray[n];
                File module = new File(sourceDirectory, modulePath);
                if (!module.exists()) {
                    throw new MojoExecutionException("Module " + module + " not found.");
                }
                this.modules.add(module);
                ++n;
            }
            if (this.loadExternsOnModules) {
                this.linkReport = true;
            }
        }
        super.setUp();
        ((Application)this.builder).setOutput(this.getOutput());
    }

    @Override
    protected void tearDown() throws MojoExecutionException, MojoFailureException {
        super.tearDown();
        if (this.updateSecuritySandbox) {
            this.updateSecuritySandbox();
        }
        if (this.modules != null) {
            this.compileModules();
        }
    }

    protected void compileModules() throws MojoFailureException, MojoExecutionException {
        if (this.loadExternsOnModules) {
            this.configuration.addExterns(new File[]{this.linkReportFile});
        }
        for (File module : this.modules) {
            Application moduleBuilder;
            this.getLog().info((CharSequence)("Compiling module " + module));
            String moduleName = module.getName();
            moduleName = moduleName.substring(0, moduleName.lastIndexOf(46));
            try {
                moduleBuilder = new Application(module);
            }
            catch (FileNotFoundException e) {
                throw new MojoFailureException("Unable to find " + module, (Throwable)e);
            }
            moduleBuilder.setConfiguration(this.configuration);
            moduleBuilder.setLogger((Logger)new CompileLogger(this.getLog()));
            File outputModule = new File(this.build.getDirectory(), String.valueOf(this.build.getFinalName()) + "-" + moduleName + "." + this.project.getPackaging());
            moduleBuilder.setOutput(outputModule);
            this.build(moduleBuilder);
            this.projectHelper.attachArtifact(this.project, "swf", moduleName, outputModule);
        }
    }

    @Override
    protected void writeResourceBundle(String[] bundles, String locale, File localePath) throws MojoExecutionException {
        File output = new File(this.build.getDirectory(), String.valueOf(this.build.getFinalName()) + "-" + locale + ".swf");
        String bundlesString = Arrays.toString(bundles).replace("[", "").replace("]", "").replace(", ", ",");
        ArrayList<File> external = new ArrayList<File>();
        ArrayList<File> internal = new ArrayList<File>();
        ArrayList<File> merged = new ArrayList<File>();
        external.addAll((Collection)Arrays.asList(this.getGlobalDependency()));
        external.addAll((Collection)Arrays.asList(this.getDependenciesPath("external")));
        external.addAll((Collection)Arrays.asList(this.getDependenciesPath("rsl")));
        internal.addAll((Collection)Arrays.asList(this.getDependenciesPath("internal")));
        merged.addAll((Collection)Arrays.asList(this.getDependenciesPath("compile")));
        merged.addAll((Collection)Arrays.asList(this.getDependenciesPath("merged")));
        merged.addAll((Collection)Arrays.asList(this.getResourcesBundles(locale)));
        HashSet<String> args = new HashSet<String>();
        args.add("-locale=" + locale);
        args.add("-source-path=" + localePath.getAbsolutePath());
        args.add("-include-resource-bundles=" + bundlesString);
        args.add("-output=" + output.getAbsolutePath());
        args.add("-compiler.fonts.local-fonts-snapshot=" + this.getFontsSnapshot().getAbsolutePath());
        args.add("-load-config=" + this.configFile.getAbsolutePath());
        args.add("-external-library-path=" + this.toString(external));
        args.add("-include-libraries=" + this.toString(internal));
        args.add("-library-path=" + this.toString(merged));
        this.getLog().debug((CharSequence)("writeResourceBundle calling mxmlc with args: " + ((Object)args).toString()));
        HashSet<String> hashSet = args;
        ApplicationMojo applicationMojo = this;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)applicationMojo), hashSet);
        Object[] objectArray = new Object[]{this, applicationMojo, hashSet, joinPoint};
        FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new ApplicationMojo$AjcClosure1(objectArray), joinPoint);
        HashSet<String> hashSet2 = args;
        ApplicationMojo applicationMojo2 = this;
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)applicationMojo2), hashSet2);
        Object[] objectArray2 = new Object[]{this, applicationMojo2, hashSet2, joinPoint2};
        FlexCompatibilityAspect.aspectOf().ajc$around$info_flexmojos_compatibilitykit_FlexCompatibilityAspect$1$a783a4a3((AroundClosure)new ApplicationMojo$AjcClosure3(objectArray2), joinPoint2);
        this.projectHelper.attachArtifact(this.project, "swf", locale, output);
    }

    @FlexCompatibility(maxVersion="2")
    private void forkMxmlc(Set<String> args) throws MojoExecutionException {
        throw new MojoExecutionException("Not implemented yet");
    }

    @FlexCompatibility(minVersion="3")
    private void runMxmlc(Set<String> args) {
        Compiler.mxmlc((String[])args.toArray(new String[args.size()]));
    }

    private String toString(List<File> libs) {
        StringBuilder sb = new StringBuilder();
        for (File lib : libs) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(lib.getAbsolutePath());
        }
        return sb.toString();
    }

    private void updateSecuritySandbox() throws MojoExecutionException {
        File fpTrustFolder = FlashPlayerUtils.getTrustDir();
        File mavenCfg = new File(fpTrustFolder, "maven.cfg");
        if (!mavenCfg.exists()) {
            try {
                mavenCfg.createNewFile();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create FlashPayerTrust file: " + mavenCfg.getAbsolutePath(), (Exception)e);
            }
        }
        try {
            FileReader input = new FileReader(mavenCfg);
            String cfg = IOUtils.toString((Reader)input);
            input.close();
            String trustedFile = this.getOutput().getAbsolutePath();
            if (cfg.contains(trustedFile)) {
                this.getLog().info((CharSequence)("Already trust on " + trustedFile));
                return;
            }
            this.getLog().info((CharSequence)("Updating Flash Payer Trust directory " + trustedFile));
            if (!cfg.endsWith("\n")) {
                cfg = String.valueOf(cfg) + '\n';
            }
            cfg = String.valueOf(cfg) + trustedFile + '\n';
            FileWriter output = new FileWriter(mavenCfg);
            IOUtils.write((String)cfg, (Writer)output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to edit FlashPayerTrust file: " + mavenCfg.getAbsolutePath(), (Exception)e);
        }
    }

    @Override
    protected boolean isDebug() {
        return this.debug;
    }

    @Override
    protected boolean isApplication() {
        return true;
    }

    @Override
    protected String getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    protected File getOutput() {
        return this.output;
    }

    static {
        Factory factory = new Factory("ApplicationMojo.java", Class.forName("info.rvin.mojo.flexmojo.compiler.ApplicationMojo"));
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "forkMxmlc", "info.rvin.mojo.flexmojo.compiler.ApplicationMojo", "java.util.Set:", "args:", "org.apache.maven.plugin.MojoExecutionException:", "void"), 294);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("2", "runMxmlc", "info.rvin.mojo.flexmojo.compiler.ApplicationMojo", "java.util.Set:", "args:", "", "void"), 295);
    }

    static final /* synthetic */ void forkMxmlc_aroundBody0(ApplicationMojo applicationMojo, ApplicationMojo applicationMojo2, Set set, JoinPoint joinPoint) {
        applicationMojo2.forkMxmlc(set);
    }

    static final /* synthetic */ void runMxmlc_aroundBody2(ApplicationMojo applicationMojo, ApplicationMojo applicationMojo2, Set set, JoinPoint joinPoint) {
        applicationMojo2.runMxmlc(set);
    }
}

