/*
 * Decompiled with CFR 0.152.
 */
package info.flexmojos.compatibilitykit;

public class VersionUtils {
    public static int[] splitVersion(String version) {
        if (version == null || version.trim().equals("")) {
            return new int[0];
        }
        int endIndex = version.indexOf(45);
        if (endIndex != -1) {
            version = version.substring(0, endIndex);
        }
        String[] versionsStr = version.split("\\.");
        int[] versions = new int[versionsStr.length];
        int i = 0;
        while (i < versionsStr.length) {
            versions[i] = new Integer(versionsStr[i]);
            ++i;
        }
        return versions;
    }

    public static boolean isMinVersionOK(int[] fdkVersion, int[] minVersion) {
        int lenght = VersionUtils.getSmaller(fdkVersion.length, minVersion.length);
        int i = 0;
        while (i < lenght) {
            int current = fdkVersion[i];
            int min = minVersion[i];
            if (current < min) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isMaxVersionOK(int[] fdkVersion, int[] maxVersion) {
        int lenght = VersionUtils.getSmaller(fdkVersion.length, maxVersion.length);
        int i = 0;
        while (i < lenght) {
            int current = fdkVersion[i];
            int max = maxVersion[i];
            if (current > max) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static int getSmaller(int ... integers) {
        if (integers.length == 0) {
            return 0;
        }
        int smaller = Integer.MAX_VALUE;
        int[] nArray = integers;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int integer = nArray[n];
            if (integer < smaller) {
                smaller = integer;
            }
            ++n;
        }
        return smaller;
    }
}

