/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs.build;

import info.debatty.java.graphs.Edge;
import info.debatty.java.graphs.Graph;
import info.debatty.java.graphs.SimilarityInterface;
import info.debatty.java.graphs.build.AbstractNNDescent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NNDescent<T>
extends AbstractNNDescent<T> {
    @Override
    protected final Graph<T> nndescent(List<T> nodes, SimilarityInterface<T> similarity) {
        Graph<Object> neighborlists = new Graph<Object>(nodes.size());
        HashMap<T, ArrayList<T>> old_lists = new HashMap<T, ArrayList<T>>(nodes.size());
        HashMap<T, ArrayList<T>> new_lists = new HashMap<T, ArrayList<T>>(nodes.size());
        for (T v : nodes) {
            neighborlists.put(v, this.randomNeighborList(nodes, v));
        }
        int c = 0;
        int iterations = 0;
        do {
            ++iterations;
            c = 0;
            for (int i = 0; i < nodes.size(); ++i) {
                T v = nodes.get(i);
                old_lists.put(v, this.pickFalses(v, neighborlists.getNeighbors(v)));
                new_lists.put(v, this.pickTruesAndMark(v, neighborlists.getNeighbors(v)));
            }
            HashMap<T, ArrayList<T>> old_lists_2 = this.reverse(nodes, old_lists);
            HashMap<T, ArrayList<T>> new_lists_2 = this.reverse(nodes, new_lists);
            for (int i = 0; i < nodes.size(); ++i) {
                T v = nodes.get(i);
                old_lists.put(v, this.union((ArrayList)old_lists.get(v), this.sample(old_lists_2.get(v), (int)(this.getRho() * (double)this.getK()))));
                new_lists.put(v, this.union((ArrayList)new_lists.get(v), this.sample(new_lists_2.get(v), (int)(this.getRho() * (double)this.getK()))));
                for (int j = 0; j < ((ArrayList)new_lists.get(v)).size(); ++j) {
                    double s;
                    Object u2;
                    int l;
                    Object u1 = ((ArrayList)new_lists.get(v)).get(j);
                    for (l = j + 1; l < ((ArrayList)new_lists.get(u1)).size(); ++l) {
                        u2 = ((ArrayList)new_lists.get(u1)).get(l);
                        s = similarity.similarity(u1, u2);
                        c += this.updateNL(neighborlists.getNeighbors(u1), u2, s);
                        c += this.updateNL(neighborlists.getNeighbors(u2), u1, s);
                    }
                    for (l = 0; l < ((ArrayList)old_lists.get(v)).size(); ++l) {
                        u2 = ((ArrayList)old_lists.get(v)).get(l);
                        if (u1.equals(u2)) continue;
                        s = similarity.similarity(u1, u2);
                        c += this.updateNL(neighborlists.getNeighbors(u1), u2, s);
                        c += this.updateNL(neighborlists.getNeighbors(u2), u1, s);
                    }
                }
            }
        } while (!((double)c <= this.getDelta() * (double)nodes.size() * (double)this.getK()) && iterations < this.getMaxIterations());
        return neighborlists;
    }

    @Override
    protected final Set<Edge> getSetInstance(int size) {
        return new HashSet<Edge>(size);
    }
}

