/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs;

import info.debatty.java.graphs.Neighbor;
import info.debatty.java.util.SynchronizedBoundedPriorityQueue;
import java.io.Serializable;
import java.util.Iterator;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeighborList
extends SynchronizedBoundedPriorityQueue<Neighbor>
implements Serializable {
    private static final double EPSILON = 1.0E-12;

    public NeighborList(NeighborList origin) {
        super(origin.size());
        for (Neighbor neighbor : origin) {
            this.add(neighbor);
        }
    }

    public NeighborList(int size) {
        super(size);
    }

    public final int countCommonNodes(NeighborList other_nl) {
        int count = 0;
        for (Neighbor n : this) {
            if (!other_nl.contains(n)) continue;
            ++count;
        }
        return count;
    }

    public final int countCommons(NeighborList other) {
        PriorityQueue<Neighbor> copy_this = new PriorityQueue<Neighbor>(this);
        PriorityQueue<Neighbor> copy_other = new PriorityQueue<Neighbor>(other);
        int count = 0;
        Neighbor this_neighbor = copy_this.poll();
        Neighbor other_neighbor = copy_other.poll();
        while (this_neighbor != null && other_neighbor != null) {
            double delta = this_neighbor.getSimilarity() - other_neighbor.getSimilarity();
            if (delta < 1.0E-12 && delta > -1.0E-12) {
                ++count;
                this_neighbor = copy_this.poll();
                other_neighbor = copy_other.poll();
                continue;
            }
            if (this_neighbor.getSimilarity() > other_neighbor.getSimilarity()) {
                other_neighbor = copy_other.poll();
                continue;
            }
            this_neighbor = copy_this.poll();
        }
        return count;
    }

    public final <T> boolean containsNode(T node) {
        for (Neighbor n : this) {
            if (!n.getNode().equals(node)) continue;
            return true;
        }
        return false;
    }

    public final <T> boolean removeNode(T node) {
        for (Neighbor n : this) {
            if (!n.getNode().equals(node)) continue;
            this.remove(n);
            return true;
        }
        return false;
    }

    public final void prune(double threshold) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Neighbor neighbor = (Neighbor)iterator.next();
            if (!(neighbor.getSimilarity() < threshold)) continue;
            iterator.remove();
        }
    }
}

