/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.graphs;

import info.debatty.java.graphs.NeighborList;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastSearchResult<T>
implements Serializable {
    private int similarities;
    private int restarts;
    private int boundary_restarts;
    private final NeighborList neighbors;
    private T boundary_node;

    public FastSearchResult(int k) {
        this.neighbors = new NeighborList(k);
    }

    public final int getSimilarities() {
        return this.similarities;
    }

    public final int getRestarts() {
        return this.restarts;
    }

    public final int getBoundaryRestarts() {
        return this.boundary_restarts;
    }

    public final NeighborList getNeighbors() {
        return this.neighbors;
    }

    final void incSimilarities() {
        ++this.similarities;
    }

    final void incRestarts() {
        ++this.restarts;
    }

    final void incBoundaryRestarts() {
        ++this.boundary_restarts;
    }

    public final T getBoundaryNode() {
        return this.boundary_node;
    }

    final void setBoundaryNode(T boundary_node) {
        this.boundary_node = boundary_node;
    }

    public final void add(FastSearchResult<T> other) {
        this.similarities += other.similarities;
        this.boundary_restarts += other.boundary_restarts;
        this.neighbors.addAll(other.neighbors);
        this.restarts += other.restarts;
    }

    public final void addAll(List<FastSearchResult<T>> others) {
        for (FastSearchResult<T> other : others) {
            this.add(other);
        }
    }

    public final String toString() {
        return "FastSearchResult{similarities=" + this.similarities + ", restarts=" + this.restarts + ", boundary_restarts=" + this.boundary_restarts + ", neighbors=" + this.neighbors + ", boundary_node=" + this.boundary_node + '}';
    }
}

