/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.aggregation;

import info.debatty.java.aggregation.Line;
import info.debatty.java.aggregation.Point;

final class InterpolationFunction {
    private Type type = Type.straight;
    private double m = 0.0;
    private double n = 0.0;
    private Point p0 = new Point();
    private Point p1 = new Point();
    private Point p2 = new Point();
    private Point p3 = new Point();
    private Point p4 = new Point();

    InterpolationFunction() {
    }

    InterpolationFunction(Line line1, Line line2, Point point1, Point point2) {
        if (line1.a == line2.a && line1.b == line2.b) {
            this.type = Type.straight;
            this.m = line1.a;
            this.n = line1.b;
        } else if (line1.a == line2.a) {
            this.calcDVOWDNa(line1, line2, point1, point2);
        } else {
            this.calcDVOWDa(line1, line2, point1, point2);
        }
    }

    public double eval(double x) {
        double y = this.type == Type.straight ? this.m * x + this.n : (this.p0.x <= x && x <= this.p2.x ? Point.bernsteinInterpolation2(this.p0, this.p1, this.p2, x) : Point.bernsteinInterpolation2(this.p2, this.p3, this.p4, x));
        assert (y <= 2.0);
        if (y < 0.0) {
            y = 0.0;
        }
        if (y > 1.0) {
            y = 1.0;
        }
        return y;
    }

    private void calcDVOWDNa(Line line1, Line line2, Point point1, Point point2) {
        double average_x = (point1.x + point2.x) / 2.0;
        this.p1 = new Point((point1.x + average_x) / 2.0, line1.a * (point1.x + average_x) / 2.0 + line1.b);
        this.p3 = new Point((point2.x + average_x) / 2.0, line2.a * (point2.x + average_x) / 2.0 + line2.b);
        Line median = Line.fromPoints(this.p1, this.p3);
        this.p2 = new Point(average_x, median.eval(average_x));
        assert (this.p3.y <= Math.max(point2.y, point1.y));
        assert (this.p1.y <= Math.max(point2.y, point1.y));
        assert (this.p3.y >= Math.min(point2.y, point1.y));
        assert (this.p1.y >= Math.min(point2.y, point1.y));
        this.type = Type.bernstein;
        this.p0 = new Point(point1);
        this.p4 = new Point(point2);
    }

    private void calcDVOWDa(Line line0, Line line1, Point p0, Point p1) {
        double x_intersection = (line0.b - line1.b) / (line1.a - line0.a);
        double y_intersection = (line1.a * line0.b - line0.a * line1.b) / (line1.a - line0.a);
        double x_between = p0.x <= x_intersection && x_intersection <= p1.x && p0.y <= y_intersection && y_intersection <= p1.y ? x_intersection : (p0.x + p1.x) / 2.0;
        this.type = Type.bernstein;
        this.p0 = new Point(p0);
        this.p1 = new Point((p0.x + x_between) / 2.0, line0.a * (p0.x + x_between) / 2.0 + line0.b);
        this.p3 = new Point((p1.x + x_between) / 2.0, line1.a * (p1.x + x_between) / 2.0 + line1.b);
        Line straight_line = Line.fromPoints(this.p1, this.p3);
        this.p2 = new Point(x_between, straight_line.eval(x_between));
        this.p4 = new Point(p1);
    }

    private static enum Type {
        straight,
        bernstein;

    }
}

