/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java.After;
import cucumber.api.java.Before;
import cucumber.api.java8.GlueBase;
import cucumber.api.java8.HookBody;
import cucumber.api.java8.HookNoArgsBody;
import cucumber.api.java8.StepdefBody;
import cucumber.runtime.Backend;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.CucumberException;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.NoInstancesException;
import cucumber.runtime.Reflections;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.TooManyInstancesException;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.Utils;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.java.DefaultJavaObjectFactory;
import cucumber.runtime.java.Java8HookDefinition;
import cucumber.runtime.java.Java8StepDefinition;
import cucumber.runtime.java.JavaHookDefinition;
import cucumber.runtime.java.JavaSnippet;
import cucumber.runtime.java.JavaStepDefinition;
import cucumber.runtime.java.MethodScanner;
import cucumber.runtime.java.ObjectFactory;
import cucumber.runtime.java.TypeIntrospector;
import cucumber.runtime.snippets.FunctionNameGenerator;
import cucumber.runtime.snippets.Snippet;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class JavaBackend
implements Backend {
    public static final ThreadLocal<JavaBackend> INSTANCE = new ThreadLocal();
    private SnippetGenerator snippetGenerator = new SnippetGenerator((Snippet)new JavaSnippet());
    private final ObjectFactory objectFactory;
    private final ClassFinder classFinder;
    private final MethodScanner methodScanner;
    private Glue glue;
    private List<Class<? extends GlueBase>> glueBaseClasses = new ArrayList<Class<? extends GlueBase>>();

    public JavaBackend(ResourceLoader resourceLoader) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.classFinder = new ResourceLoaderClassFinder(resourceLoader, classLoader);
        this.methodScanner = new MethodScanner(this.classFinder);
        this.objectFactory = JavaBackend.loadObjectFactory(this.classFinder);
    }

    public JavaBackend(ObjectFactory objectFactory) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        this.classFinder = new ResourceLoaderClassFinder((ResourceLoader)resourceLoader, classLoader);
        this.methodScanner = new MethodScanner(this.classFinder);
        this.objectFactory = objectFactory;
    }

    public JavaBackend(ObjectFactory objectFactory, ClassFinder classFinder) {
        this.objectFactory = objectFactory;
        this.classFinder = classFinder;
        this.methodScanner = new MethodScanner(classFinder);
    }

    public static ObjectFactory loadObjectFactory(ClassFinder classFinder) {
        ObjectFactory objectFactory;
        try {
            Reflections reflections = new Reflections(classFinder);
            objectFactory = (ObjectFactory)reflections.instantiateExactlyOneSubclass(ObjectFactory.class, "cucumber.runtime", new Class[0], new Object[0]);
        }
        catch (TooManyInstancesException e) {
            System.out.println(JavaBackend.getMultipleObjectFactoryLogMessage());
            objectFactory = new DefaultJavaObjectFactory();
        }
        catch (NoInstancesException e) {
            objectFactory = new DefaultJavaObjectFactory();
        }
        return objectFactory;
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        this.methodScanner.scan(this, gluePaths);
        for (String gluePath : gluePaths) {
            Collection glueDefinerClasses = this.classFinder.getDescendants(GlueBase.class, MultiLoader.packageName((String)gluePath));
            for (Class glueClass : glueDefinerClasses) {
                if (glueClass.isInterface()) continue;
                this.objectFactory.addClass(glueClass);
                this.glueBaseClasses.add(glueClass);
            }
        }
    }

    public void loadGlue(Glue glue, Method method, Class<?> glueCodeClass) {
        this.glue = glue;
        this.methodScanner.scan(this, method, glueCodeClass);
    }

    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    public void buildWorld() {
        this.objectFactory.start();
        try {
            INSTANCE.set(this);
            this.glue.removeScenarioScopedGlue();
            for (Class<? extends GlueBase> glueBaseClass : this.glueBaseClasses) {
                this.objectFactory.getInstance(glueBaseClass);
            }
        }
        finally {
            INSTANCE.remove();
        }
    }

    public void disposeWorld() {
        this.objectFactory.stop();
    }

    public String getSnippet(Step step, FunctionNameGenerator functionNameGenerator) {
        return this.snippetGenerator.getSnippet(step, functionNameGenerator);
    }

    void addStepDefinition(Annotation annotation, Method method) {
        try {
            this.objectFactory.addClass(method.getDeclaringClass());
            this.glue.addStepDefinition((StepDefinition)new JavaStepDefinition(method, this.pattern(annotation), this.timeoutMillis(annotation), this.objectFactory));
        }
        catch (DuplicateStepDefinitionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CucumberException(e);
        }
    }

    public void addStepDefinition(String regexp, long timeoutMillis, StepdefBody body, TypeIntrospector typeIntrospector) {
        try {
            this.glue.addStepDefinition((StepDefinition)new Java8StepDefinition(Pattern.compile(regexp), timeoutMillis, body, typeIntrospector));
        }
        catch (Exception e) {
            throw new CucumberException((Throwable)e);
        }
    }

    void addHook(Annotation annotation, Method method) {
        this.objectFactory.addClass(method.getDeclaringClass());
        if (annotation.annotationType().equals(Before.class)) {
            String[] tagExpressions = ((Before)annotation).value();
            long timeout = ((Before)annotation).timeout();
            this.glue.addBeforeHook((HookDefinition)new JavaHookDefinition(method, tagExpressions, ((Before)annotation).order(), timeout, this.objectFactory));
        } else {
            String[] tagExpressions = ((After)annotation).value();
            long timeout = ((After)annotation).timeout();
            this.glue.addAfterHook((HookDefinition)new JavaHookDefinition(method, tagExpressions, ((After)annotation).order(), timeout, this.objectFactory));
        }
    }

    public void addBeforeHookDefinition(String[] tagExpressions, long timeoutMillis, int order, HookBody body) {
        this.glue.addBeforeHook((HookDefinition)new Java8HookDefinition(tagExpressions, order, timeoutMillis, body));
    }

    public void addAfterHookDefinition(String[] tagExpressions, long timeoutMillis, int order, HookBody body) {
        this.glue.addAfterHook((HookDefinition)new Java8HookDefinition(tagExpressions, order, timeoutMillis, body));
    }

    public void addBeforeHookDefinition(String[] tagExpressions, long timeoutMillis, int order, HookNoArgsBody body) {
        this.glue.addBeforeHook((HookDefinition)new Java8HookDefinition(tagExpressions, order, timeoutMillis, body));
    }

    public void addAfterHookDefinition(String[] tagExpressions, long timeoutMillis, int order, HookNoArgsBody body) {
        this.glue.addAfterHook((HookDefinition)new Java8HookDefinition(tagExpressions, order, timeoutMillis, body));
    }

    private Pattern pattern(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("value", new Class[0]);
        String regexpString = (String)Utils.invoke((Object)annotation, (Method)regexpMethod, (long)0L, (Object[])new Object[0]);
        return Pattern.compile(regexpString);
    }

    private long timeoutMillis(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("timeout", new Class[0]);
        return (Long)Utils.invoke((Object)annotation, (Method)regexpMethod, (long)0L, (Object[])new Object[0]);
    }

    private static String getMultipleObjectFactoryLogMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("More than one Cucumber ObjectFactory was found in the classpath\n\n");
        sb.append("You probably may have included, for instance, cucumber-spring AND cucumber-guice as part of\n");
        sb.append("your dependencies. When this happens, Cucumber falls back to instantiating the\n");
        sb.append("DefaultJavaObjectFactory implementation which doesn't provide IoC.\n");
        sb.append("In order to enjoy IoC features, please remove the unnecessary dependencies from your classpath.\n");
        return sb.toString();
    }
}

