/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.ContactPoint;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.Period;
import org.hl7.fhir.Reference;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Practitioner.PractitionerRole", propOrder={"organization", "role", "specialty", "identifier", "telecom", "period", "location", "healthcareService"})
public class PractitionerPractitionerRole
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected Reference organization;
    protected CodeableConcept role;
    protected List<CodeableConcept> specialty;
    protected List<Identifier> identifier;
    protected List<ContactPoint> telecom;
    protected Period period;
    protected List<Reference> location;
    protected List<Reference> healthcareService;

    public Reference getOrganization() {
        return this.organization;
    }

    public void setOrganization(Reference value) {
        this.organization = value;
    }

    public CodeableConcept getRole() {
        return this.role;
    }

    public void setRole(CodeableConcept value) {
        this.role = value;
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period value) {
        this.period = value;
    }

    public List<Reference> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        return this.location;
    }

    public List<Reference> getHealthcareService() {
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        return this.healthcareService;
    }

    public PractitionerPractitionerRole withOrganization(Reference value) {
        this.setOrganization(value);
        return this;
    }

    public PractitionerPractitionerRole withRole(CodeableConcept value) {
        this.setRole(value);
        return this;
    }

    public PractitionerPractitionerRole withSpecialty(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getSpecialty().add(value);
            }
        }
        return this;
    }

    public PractitionerPractitionerRole withSpecialty(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getSpecialty().addAll(values);
        }
        return this;
    }

    public PractitionerPractitionerRole withIdentifier(Identifier ... values) {
        if (values != null) {
            for (Identifier value : values) {
                this.getIdentifier().add(value);
            }
        }
        return this;
    }

    public PractitionerPractitionerRole withIdentifier(Collection<Identifier> values) {
        if (values != null) {
            this.getIdentifier().addAll(values);
        }
        return this;
    }

    public PractitionerPractitionerRole withTelecom(ContactPoint ... values) {
        if (values != null) {
            for (ContactPoint value : values) {
                this.getTelecom().add(value);
            }
        }
        return this;
    }

    public PractitionerPractitionerRole withTelecom(Collection<ContactPoint> values) {
        if (values != null) {
            this.getTelecom().addAll(values);
        }
        return this;
    }

    public PractitionerPractitionerRole withPeriod(Period value) {
        this.setPeriod(value);
        return this;
    }

    public PractitionerPractitionerRole withLocation(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getLocation().add(value);
            }
        }
        return this;
    }

    public PractitionerPractitionerRole withLocation(Collection<Reference> values) {
        if (values != null) {
            this.getLocation().addAll(values);
        }
        return this;
    }

    public PractitionerPractitionerRole withHealthcareService(Reference ... values) {
        if (values != null) {
            for (Reference value : values) {
                this.getHealthcareService().add(value);
            }
        }
        return this;
    }

    public PractitionerPractitionerRole withHealthcareService(Collection<Reference> values) {
        if (values != null) {
            this.getHealthcareService().addAll(values);
        }
        return this;
    }

    @Override
    public PractitionerPractitionerRole withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public PractitionerPractitionerRole withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public PractitionerPractitionerRole withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public PractitionerPractitionerRole withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public PractitionerPractitionerRole withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        PractitionerPractitionerRole that = (PractitionerPractitionerRole)object;
        Reference lhsOrganization = this.getOrganization();
        Reference rhsOrganization = that.getOrganization();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"organization", (Object)lhsOrganization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"organization", (Object)rhsOrganization), (Object)lhsOrganization, (Object)rhsOrganization, this.organization != null, that.organization != null)) {
            return false;
        }
        CodeableConcept lhsRole = this.getRole();
        CodeableConcept rhsRole = that.getRole();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"role", (Object)lhsRole), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"role", (Object)rhsRole), (Object)lhsRole, (Object)rhsRole, this.role != null, that.role != null)) {
            return false;
        }
        List<CodeableConcept> lhsSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        List<CodeableConcept> rhsSpecialty = that.specialty != null && !that.specialty.isEmpty() ? that.getSpecialty() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"specialty", lhsSpecialty), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"specialty", rhsSpecialty), lhsSpecialty, rhsSpecialty, this.specialty != null && !this.specialty.isEmpty(), that.specialty != null && !that.specialty.isEmpty())) {
            return false;
        }
        List<Identifier> lhsIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        List<Identifier> rhsIdentifier = that.identifier != null && !that.identifier.isEmpty() ? that.getIdentifier() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"identifier", lhsIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, this.identifier != null && !this.identifier.isEmpty(), that.identifier != null && !that.identifier.isEmpty())) {
            return false;
        }
        List<ContactPoint> lhsTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        List<ContactPoint> rhsTelecom = that.telecom != null && !that.telecom.isEmpty() ? that.getTelecom() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"telecom", lhsTelecom), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"telecom", rhsTelecom), lhsTelecom, rhsTelecom, this.telecom != null && !this.telecom.isEmpty(), that.telecom != null && !that.telecom.isEmpty())) {
            return false;
        }
        Period lhsPeriod = this.getPeriod();
        Period rhsPeriod = that.getPeriod();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"period", (Object)lhsPeriod), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"period", (Object)rhsPeriod), (Object)lhsPeriod, (Object)rhsPeriod, this.period != null, that.period != null)) {
            return false;
        }
        List<Reference> lhsLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        List<Reference> rhsLocation = that.location != null && !that.location.isEmpty() ? that.getLocation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"location", lhsLocation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"location", rhsLocation), lhsLocation, rhsLocation, this.location != null && !this.location.isEmpty(), that.location != null && !that.location.isEmpty())) {
            return false;
        }
        List<Reference> lhsHealthcareService = this.healthcareService != null && !this.healthcareService.isEmpty() ? this.getHealthcareService() : null;
        List<Reference> rhsHealthcareService = that.healthcareService != null && !that.healthcareService.isEmpty() ? that.getHealthcareService() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"healthcareService", lhsHealthcareService), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"healthcareService", rhsHealthcareService), lhsHealthcareService, rhsHealthcareService, this.healthcareService != null && !this.healthcareService.isEmpty(), that.healthcareService != null && !that.healthcareService.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Reference theOrganization = this.getOrganization();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"organization", (Object)theOrganization), currentHashCode, (Object)theOrganization, this.organization != null);
        CodeableConcept theRole = this.getRole();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"role", (Object)theRole), currentHashCode, (Object)theRole, this.role != null);
        List<CodeableConcept> theSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"specialty", theSpecialty), currentHashCode, theSpecialty, this.specialty != null && !this.specialty.isEmpty());
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"identifier", theIdentifier), currentHashCode, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        List<ContactPoint> theTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"telecom", theTelecom), currentHashCode, theTelecom, this.telecom != null && !this.telecom.isEmpty());
        Period thePeriod = this.getPeriod();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"period", (Object)thePeriod), currentHashCode, (Object)thePeriod, this.period != null);
        List<Reference> theLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"location", theLocation), currentHashCode, theLocation, this.location != null && !this.location.isEmpty());
        List<Reference> theHealthcareService = this.healthcareService != null && !this.healthcareService.isEmpty() ? this.getHealthcareService() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"healthcareService", theHealthcareService), currentHashCode, theHealthcareService, this.healthcareService != null && !this.healthcareService.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Reference theOrganization = this.getOrganization();
        strategy.appendField(locator, (Object)this, "organization", buffer, (Object)theOrganization, this.organization != null);
        CodeableConcept theRole = this.getRole();
        strategy.appendField(locator, (Object)this, "role", buffer, (Object)theRole, this.role != null);
        List<CodeableConcept> theSpecialty = this.specialty != null && !this.specialty.isEmpty() ? this.getSpecialty() : null;
        strategy.appendField(locator, (Object)this, "specialty", buffer, theSpecialty, this.specialty != null && !this.specialty.isEmpty());
        List<Identifier> theIdentifier = this.identifier != null && !this.identifier.isEmpty() ? this.getIdentifier() : null;
        strategy.appendField(locator, (Object)this, "identifier", buffer, theIdentifier, this.identifier != null && !this.identifier.isEmpty());
        List<ContactPoint> theTelecom = this.telecom != null && !this.telecom.isEmpty() ? this.getTelecom() : null;
        strategy.appendField(locator, (Object)this, "telecom", buffer, theTelecom, this.telecom != null && !this.telecom.isEmpty());
        Period thePeriod = this.getPeriod();
        strategy.appendField(locator, (Object)this, "period", buffer, (Object)thePeriod, this.period != null);
        List<Reference> theLocation = this.location != null && !this.location.isEmpty() ? this.getLocation() : null;
        strategy.appendField(locator, (Object)this, "location", buffer, theLocation, this.location != null && !this.location.isEmpty());
        List<Reference> theHealthcareService = this.healthcareService != null && !this.healthcareService.isEmpty() ? this.getHealthcareService() : null;
        strategy.appendField(locator, (Object)this, "healthcareService", buffer, theHealthcareService, this.healthcareService != null && !this.healthcareService.isEmpty());
        return buffer;
    }

    public void setSpecialty(List<CodeableConcept> value) {
        this.specialty = value;
    }

    public void setIdentifier(List<Identifier> value) {
        this.identifier = value;
    }

    public void setTelecom(List<ContactPoint> value) {
        this.telecom = value;
    }

    public void setLocation(List<Reference> value) {
        this.location = value;
    }

    public void setHealthcareService(List<Reference> value) {
        this.healthcareService = value;
    }
}

