/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.BackboneElement;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Extension;
import org.hl7.fhir.MedicationContent;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Medication.Package", propOrder={"container", "content"})
public class MedicationPackage
extends BackboneElement
implements Equals2,
HashCode2,
ToString2 {
    protected CodeableConcept container;
    protected List<MedicationContent> content;

    public CodeableConcept getContainer() {
        return this.container;
    }

    public void setContainer(CodeableConcept value) {
        this.container = value;
    }

    public List<MedicationContent> getContent() {
        if (this.content == null) {
            this.content = new ArrayList<MedicationContent>();
        }
        return this.content;
    }

    public MedicationPackage withContainer(CodeableConcept value) {
        this.setContainer(value);
        return this;
    }

    public MedicationPackage withContent(MedicationContent ... values) {
        if (values != null) {
            for (MedicationContent value : values) {
                this.getContent().add(value);
            }
        }
        return this;
    }

    public MedicationPackage withContent(Collection<MedicationContent> values) {
        if (values != null) {
            this.getContent().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationPackage withModifierExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getModifierExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationPackage withModifierExtension(Collection<Extension> values) {
        if (values != null) {
            this.getModifierExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationPackage withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public MedicationPackage withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public MedicationPackage withId(String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        MedicationPackage that = (MedicationPackage)object;
        CodeableConcept lhsContainer = this.getContainer();
        CodeableConcept rhsContainer = that.getContainer();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"container", (Object)lhsContainer), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"container", (Object)rhsContainer), (Object)lhsContainer, (Object)rhsContainer, this.container != null, that.container != null)) {
            return false;
        }
        List<MedicationContent> lhsContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        List<MedicationContent> rhsContent = that.content != null && !that.content.isEmpty() ? that.getContent() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (String)"content", lhsContent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (String)"content", rhsContent), lhsContent, rhsContent, this.content != null && !this.content.isEmpty(), that.content != null && !that.content.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        CodeableConcept theContainer = this.getContainer();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"container", (Object)theContainer), currentHashCode, (Object)theContainer, this.container != null);
        List<MedicationContent> theContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (String)"content", theContent), currentHashCode, theContent, this.content != null && !this.content.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        CodeableConcept theContainer = this.getContainer();
        strategy.appendField(locator, (Object)this, "container", buffer, (Object)theContainer, this.container != null);
        List<MedicationContent> theContent = this.content != null && !this.content.isEmpty() ? this.getContent() : null;
        strategy.appendField(locator, (Object)this, "content", buffer, theContent, this.content != null && !this.content.isEmpty());
        return buffer;
    }

    public void setContent(List<MedicationContent> value) {
        this.content = value;
    }
}

