/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hl7.fhir.ActionDefinitionBehavior;
import org.hl7.fhir.ActionDefinitionCustomization;
import org.hl7.fhir.ActionDefinitionRelatedAction;
import org.hl7.fhir.ActionType;
import org.hl7.fhir.Attachment;
import org.hl7.fhir.CodeableConcept;
import org.hl7.fhir.Element;
import org.hl7.fhir.Extension;
import org.hl7.fhir.Identifier;
import org.hl7.fhir.ParticipantType;
import org.hl7.fhir.Reference;
import org.hl7.fhir.String;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ActionDefinition", propOrder={"actionIdentifier", "label", "title", "description", "textEquivalent", "concept", "supportingEvidence", "documentation", "relatedAction", "participantType", "type", "behavior", "resource", "customization", "action"})
public class ActionDefinition
extends Element
implements Equals2,
HashCode2,
ToString2 {
    protected Identifier actionIdentifier;
    protected String label;
    protected String title;
    protected String description;
    protected String textEquivalent;
    protected List<CodeableConcept> concept;
    protected List<Attachment> supportingEvidence;
    protected List<Attachment> documentation;
    protected ActionDefinitionRelatedAction relatedAction;
    protected List<ParticipantType> participantType;
    protected ActionType type;
    protected List<ActionDefinitionBehavior> behavior;
    protected Reference resource;
    protected List<ActionDefinitionCustomization> customization;
    protected List<ActionDefinition> action;

    public Identifier getActionIdentifier() {
        return this.actionIdentifier;
    }

    public void setActionIdentifier(Identifier value) {
        this.actionIdentifier = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getTextEquivalent() {
        return this.textEquivalent;
    }

    public void setTextEquivalent(String value) {
        this.textEquivalent = value;
    }

    public List<CodeableConcept> getConcept() {
        if (this.concept == null) {
            this.concept = new ArrayList<CodeableConcept>();
        }
        return this.concept;
    }

    public List<Attachment> getSupportingEvidence() {
        if (this.supportingEvidence == null) {
            this.supportingEvidence = new ArrayList<Attachment>();
        }
        return this.supportingEvidence;
    }

    public List<Attachment> getDocumentation() {
        if (this.documentation == null) {
            this.documentation = new ArrayList<Attachment>();
        }
        return this.documentation;
    }

    public ActionDefinitionRelatedAction getRelatedAction() {
        return this.relatedAction;
    }

    public void setRelatedAction(ActionDefinitionRelatedAction value) {
        this.relatedAction = value;
    }

    public List<ParticipantType> getParticipantType() {
        if (this.participantType == null) {
            this.participantType = new ArrayList<ParticipantType>();
        }
        return this.participantType;
    }

    public ActionType getType() {
        return this.type;
    }

    public void setType(ActionType value) {
        this.type = value;
    }

    public List<ActionDefinitionBehavior> getBehavior() {
        if (this.behavior == null) {
            this.behavior = new ArrayList<ActionDefinitionBehavior>();
        }
        return this.behavior;
    }

    public Reference getResource() {
        return this.resource;
    }

    public void setResource(Reference value) {
        this.resource = value;
    }

    public List<ActionDefinitionCustomization> getCustomization() {
        if (this.customization == null) {
            this.customization = new ArrayList<ActionDefinitionCustomization>();
        }
        return this.customization;
    }

    public List<ActionDefinition> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<ActionDefinition>();
        }
        return this.action;
    }

    public ActionDefinition withActionIdentifier(Identifier value) {
        this.setActionIdentifier(value);
        return this;
    }

    public ActionDefinition withLabel(String value) {
        this.setLabel(value);
        return this;
    }

    public ActionDefinition withTitle(String value) {
        this.setTitle(value);
        return this;
    }

    public ActionDefinition withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public ActionDefinition withTextEquivalent(String value) {
        this.setTextEquivalent(value);
        return this;
    }

    public ActionDefinition withConcept(CodeableConcept ... values) {
        if (values != null) {
            for (CodeableConcept value : values) {
                this.getConcept().add(value);
            }
        }
        return this;
    }

    public ActionDefinition withConcept(Collection<CodeableConcept> values) {
        if (values != null) {
            this.getConcept().addAll(values);
        }
        return this;
    }

    public ActionDefinition withSupportingEvidence(Attachment ... values) {
        if (values != null) {
            for (Attachment value : values) {
                this.getSupportingEvidence().add(value);
            }
        }
        return this;
    }

    public ActionDefinition withSupportingEvidence(Collection<Attachment> values) {
        if (values != null) {
            this.getSupportingEvidence().addAll(values);
        }
        return this;
    }

    public ActionDefinition withDocumentation(Attachment ... values) {
        if (values != null) {
            for (Attachment value : values) {
                this.getDocumentation().add(value);
            }
        }
        return this;
    }

    public ActionDefinition withDocumentation(Collection<Attachment> values) {
        if (values != null) {
            this.getDocumentation().addAll(values);
        }
        return this;
    }

    public ActionDefinition withRelatedAction(ActionDefinitionRelatedAction value) {
        this.setRelatedAction(value);
        return this;
    }

    public ActionDefinition withParticipantType(ParticipantType ... values) {
        if (values != null) {
            for (ParticipantType value : values) {
                this.getParticipantType().add(value);
            }
        }
        return this;
    }

    public ActionDefinition withParticipantType(Collection<ParticipantType> values) {
        if (values != null) {
            this.getParticipantType().addAll(values);
        }
        return this;
    }

    public ActionDefinition withType(ActionType value) {
        this.setType(value);
        return this;
    }

    public ActionDefinition withBehavior(ActionDefinitionBehavior ... values) {
        if (values != null) {
            for (ActionDefinitionBehavior value : values) {
                this.getBehavior().add(value);
            }
        }
        return this;
    }

    public ActionDefinition withBehavior(Collection<ActionDefinitionBehavior> values) {
        if (values != null) {
            this.getBehavior().addAll(values);
        }
        return this;
    }

    public ActionDefinition withResource(Reference value) {
        this.setResource(value);
        return this;
    }

    public ActionDefinition withCustomization(ActionDefinitionCustomization ... values) {
        if (values != null) {
            for (ActionDefinitionCustomization value : values) {
                this.getCustomization().add(value);
            }
        }
        return this;
    }

    public ActionDefinition withCustomization(Collection<ActionDefinitionCustomization> values) {
        if (values != null) {
            this.getCustomization().addAll(values);
        }
        return this;
    }

    public ActionDefinition withAction(ActionDefinition ... values) {
        if (values != null) {
            for (ActionDefinition value : values) {
                this.getAction().add(value);
            }
        }
        return this;
    }

    public ActionDefinition withAction(Collection<ActionDefinition> values) {
        if (values != null) {
            this.getAction().addAll(values);
        }
        return this;
    }

    @Override
    public ActionDefinition withExtension(Extension ... values) {
        if (values != null) {
            for (Extension value : values) {
                this.getExtension().add(value);
            }
        }
        return this;
    }

    @Override
    public ActionDefinition withExtension(Collection<Extension> values) {
        if (values != null) {
            this.getExtension().addAll(values);
        }
        return this;
    }

    @Override
    public ActionDefinition withId(java.lang.String value) {
        this.setId(value);
        return this;
    }

    @Override
    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(thisLocator, thatLocator, object, strategy)) {
            return false;
        }
        ActionDefinition that = (ActionDefinition)object;
        Identifier lhsActionIdentifier = this.getActionIdentifier();
        Identifier rhsActionIdentifier = that.getActionIdentifier();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"actionIdentifier", (Object)lhsActionIdentifier), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"actionIdentifier", (Object)rhsActionIdentifier), (Object)lhsActionIdentifier, (Object)rhsActionIdentifier, this.actionIdentifier != null, that.actionIdentifier != null)) {
            return false;
        }
        String lhsLabel = this.getLabel();
        String rhsLabel = that.getLabel();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"label", (Object)lhsLabel), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"label", (Object)rhsLabel), (Object)lhsLabel, (Object)rhsLabel, this.label != null, that.label != null)) {
            return false;
        }
        String lhsTitle = this.getTitle();
        String rhsTitle = that.getTitle();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"title", (Object)lhsTitle), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"title", (Object)rhsTitle), (Object)lhsTitle, (Object)rhsTitle, this.title != null, that.title != null)) {
            return false;
        }
        String lhsDescription = this.getDescription();
        String rhsDescription = that.getDescription();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"description", (Object)lhsDescription), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"description", (Object)rhsDescription), (Object)lhsDescription, (Object)rhsDescription, this.description != null, that.description != null)) {
            return false;
        }
        String lhsTextEquivalent = this.getTextEquivalent();
        String rhsTextEquivalent = that.getTextEquivalent();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"textEquivalent", (Object)lhsTextEquivalent), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"textEquivalent", (Object)rhsTextEquivalent), (Object)lhsTextEquivalent, (Object)rhsTextEquivalent, this.textEquivalent != null, that.textEquivalent != null)) {
            return false;
        }
        List<CodeableConcept> lhsConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        List<CodeableConcept> rhsConcept = that.concept != null && !that.concept.isEmpty() ? that.getConcept() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"concept", lhsConcept), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"concept", rhsConcept), lhsConcept, rhsConcept, this.concept != null && !this.concept.isEmpty(), that.concept != null && !that.concept.isEmpty())) {
            return false;
        }
        List<Attachment> lhsSupportingEvidence = this.supportingEvidence != null && !this.supportingEvidence.isEmpty() ? this.getSupportingEvidence() : null;
        List<Attachment> rhsSupportingEvidence = that.supportingEvidence != null && !that.supportingEvidence.isEmpty() ? that.getSupportingEvidence() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"supportingEvidence", lhsSupportingEvidence), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"supportingEvidence", rhsSupportingEvidence), lhsSupportingEvidence, rhsSupportingEvidence, this.supportingEvidence != null && !this.supportingEvidence.isEmpty(), that.supportingEvidence != null && !that.supportingEvidence.isEmpty())) {
            return false;
        }
        List<Attachment> lhsDocumentation = this.documentation != null && !this.documentation.isEmpty() ? this.getDocumentation() : null;
        List<Attachment> rhsDocumentation = that.documentation != null && !that.documentation.isEmpty() ? that.getDocumentation() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"documentation", lhsDocumentation), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"documentation", rhsDocumentation), lhsDocumentation, rhsDocumentation, this.documentation != null && !this.documentation.isEmpty(), that.documentation != null && !that.documentation.isEmpty())) {
            return false;
        }
        ActionDefinitionRelatedAction lhsRelatedAction = this.getRelatedAction();
        ActionDefinitionRelatedAction rhsRelatedAction = that.getRelatedAction();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"relatedAction", (Object)lhsRelatedAction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"relatedAction", (Object)rhsRelatedAction), (Object)lhsRelatedAction, (Object)rhsRelatedAction, this.relatedAction != null, that.relatedAction != null)) {
            return false;
        }
        List<ParticipantType> lhsParticipantType = this.participantType != null && !this.participantType.isEmpty() ? this.getParticipantType() : null;
        List<ParticipantType> rhsParticipantType = that.participantType != null && !that.participantType.isEmpty() ? that.getParticipantType() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"participantType", lhsParticipantType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"participantType", rhsParticipantType), lhsParticipantType, rhsParticipantType, this.participantType != null && !this.participantType.isEmpty(), that.participantType != null && !that.participantType.isEmpty())) {
            return false;
        }
        ActionType lhsType = this.getType();
        ActionType rhsType = that.getType();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"type", (Object)lhsType), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"type", (Object)rhsType), (Object)lhsType, (Object)rhsType, this.type != null, that.type != null)) {
            return false;
        }
        List<ActionDefinitionBehavior> lhsBehavior = this.behavior != null && !this.behavior.isEmpty() ? this.getBehavior() : null;
        List<ActionDefinitionBehavior> rhsBehavior = that.behavior != null && !that.behavior.isEmpty() ? that.getBehavior() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"behavior", lhsBehavior), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"behavior", rhsBehavior), lhsBehavior, rhsBehavior, this.behavior != null && !this.behavior.isEmpty(), that.behavior != null && !that.behavior.isEmpty())) {
            return false;
        }
        Reference lhsResource = this.getResource();
        Reference rhsResource = that.getResource();
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"resource", (Object)lhsResource), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"resource", (Object)rhsResource), (Object)lhsResource, (Object)rhsResource, this.resource != null, that.resource != null)) {
            return false;
        }
        List<ActionDefinitionCustomization> lhsCustomization = this.customization != null && !this.customization.isEmpty() ? this.getCustomization() : null;
        List<ActionDefinitionCustomization> rhsCustomization = that.customization != null && !that.customization.isEmpty() ? that.getCustomization() : null;
        if (!strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"customization", lhsCustomization), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"customization", rhsCustomization), lhsCustomization, rhsCustomization, this.customization != null && !this.customization.isEmpty(), that.customization != null && !that.customization.isEmpty())) {
            return false;
        }
        List<ActionDefinition> lhsAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        List<ActionDefinition> rhsAction = that.action != null && !that.action.isEmpty() ? that.getAction() : null;
        return strategy.equals((ObjectLocator)LocatorUtils.property((ObjectLocator)thisLocator, (java.lang.String)"action", lhsAction), (ObjectLocator)LocatorUtils.property((ObjectLocator)thatLocator, (java.lang.String)"action", rhsAction), lhsAction, rhsAction, this.action != null && !this.action.isEmpty(), that.action != null && !that.action.isEmpty());
    }

    @Override
    public boolean equals(Object object) {
        JAXBEqualsStrategy strategy = JAXBEqualsStrategy.getInstance();
        return this.equals(null, null, object, (EqualsStrategy2)strategy);
    }

    @Override
    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = super.hashCode(locator, strategy);
        Identifier theActionIdentifier = this.getActionIdentifier();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"actionIdentifier", (Object)theActionIdentifier), currentHashCode, (Object)theActionIdentifier, this.actionIdentifier != null);
        String theLabel = this.getLabel();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"label", (Object)theLabel), currentHashCode, (Object)theLabel, this.label != null);
        String theTitle = this.getTitle();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"title", (Object)theTitle), currentHashCode, (Object)theTitle, this.title != null);
        String theDescription = this.getDescription();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"description", (Object)theDescription), currentHashCode, (Object)theDescription, this.description != null);
        String theTextEquivalent = this.getTextEquivalent();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"textEquivalent", (Object)theTextEquivalent), currentHashCode, (Object)theTextEquivalent, this.textEquivalent != null);
        List<CodeableConcept> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"concept", theConcept), currentHashCode, theConcept, this.concept != null && !this.concept.isEmpty());
        List<Attachment> theSupportingEvidence = this.supportingEvidence != null && !this.supportingEvidence.isEmpty() ? this.getSupportingEvidence() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"supportingEvidence", theSupportingEvidence), currentHashCode, theSupportingEvidence, this.supportingEvidence != null && !this.supportingEvidence.isEmpty());
        List<Attachment> theDocumentation = this.documentation != null && !this.documentation.isEmpty() ? this.getDocumentation() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"documentation", theDocumentation), currentHashCode, theDocumentation, this.documentation != null && !this.documentation.isEmpty());
        ActionDefinitionRelatedAction theRelatedAction = this.getRelatedAction();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"relatedAction", (Object)theRelatedAction), currentHashCode, (Object)theRelatedAction, this.relatedAction != null);
        List<ParticipantType> theParticipantType = this.participantType != null && !this.participantType.isEmpty() ? this.getParticipantType() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"participantType", theParticipantType), currentHashCode, theParticipantType, this.participantType != null && !this.participantType.isEmpty());
        ActionType theType = this.getType();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"type", (Object)theType), currentHashCode, (Object)theType, this.type != null);
        List<ActionDefinitionBehavior> theBehavior = this.behavior != null && !this.behavior.isEmpty() ? this.getBehavior() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"behavior", theBehavior), currentHashCode, theBehavior, this.behavior != null && !this.behavior.isEmpty());
        Reference theResource = this.getResource();
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"resource", (Object)theResource), currentHashCode, (Object)theResource, this.resource != null);
        List<ActionDefinitionCustomization> theCustomization = this.customization != null && !this.customization.isEmpty() ? this.getCustomization() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"customization", theCustomization), currentHashCode, theCustomization, this.customization != null && !this.customization.isEmpty());
        List<ActionDefinition> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        currentHashCode = strategy.hashCode((ObjectLocator)LocatorUtils.property((ObjectLocator)locator, (java.lang.String)"action", theAction), currentHashCode, theAction, this.action != null && !this.action.isEmpty());
        return currentHashCode;
    }

    @Override
    public int hashCode() {
        JAXBHashCodeStrategy strategy = JAXBHashCodeStrategy.getInstance();
        return this.hashCode(null, (HashCodeStrategy2)strategy);
    }

    @Override
    public java.lang.String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy2)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        super.appendFields(locator, buffer, strategy);
        Identifier theActionIdentifier = this.getActionIdentifier();
        strategy.appendField(locator, (Object)this, "actionIdentifier", buffer, (Object)theActionIdentifier, this.actionIdentifier != null);
        String theLabel = this.getLabel();
        strategy.appendField(locator, (Object)this, "label", buffer, (Object)theLabel, this.label != null);
        String theTitle = this.getTitle();
        strategy.appendField(locator, (Object)this, "title", buffer, (Object)theTitle, this.title != null);
        String theDescription = this.getDescription();
        strategy.appendField(locator, (Object)this, "description", buffer, (Object)theDescription, this.description != null);
        String theTextEquivalent = this.getTextEquivalent();
        strategy.appendField(locator, (Object)this, "textEquivalent", buffer, (Object)theTextEquivalent, this.textEquivalent != null);
        List<CodeableConcept> theConcept = this.concept != null && !this.concept.isEmpty() ? this.getConcept() : null;
        strategy.appendField(locator, (Object)this, "concept", buffer, theConcept, this.concept != null && !this.concept.isEmpty());
        List<Attachment> theSupportingEvidence = this.supportingEvidence != null && !this.supportingEvidence.isEmpty() ? this.getSupportingEvidence() : null;
        strategy.appendField(locator, (Object)this, "supportingEvidence", buffer, theSupportingEvidence, this.supportingEvidence != null && !this.supportingEvidence.isEmpty());
        List<Attachment> theDocumentation = this.documentation != null && !this.documentation.isEmpty() ? this.getDocumentation() : null;
        strategy.appendField(locator, (Object)this, "documentation", buffer, theDocumentation, this.documentation != null && !this.documentation.isEmpty());
        ActionDefinitionRelatedAction theRelatedAction = this.getRelatedAction();
        strategy.appendField(locator, (Object)this, "relatedAction", buffer, (Object)theRelatedAction, this.relatedAction != null);
        List<ParticipantType> theParticipantType = this.participantType != null && !this.participantType.isEmpty() ? this.getParticipantType() : null;
        strategy.appendField(locator, (Object)this, "participantType", buffer, theParticipantType, this.participantType != null && !this.participantType.isEmpty());
        ActionType theType = this.getType();
        strategy.appendField(locator, (Object)this, "type", buffer, (Object)theType, this.type != null);
        List<ActionDefinitionBehavior> theBehavior = this.behavior != null && !this.behavior.isEmpty() ? this.getBehavior() : null;
        strategy.appendField(locator, (Object)this, "behavior", buffer, theBehavior, this.behavior != null && !this.behavior.isEmpty());
        Reference theResource = this.getResource();
        strategy.appendField(locator, (Object)this, "resource", buffer, (Object)theResource, this.resource != null);
        List<ActionDefinitionCustomization> theCustomization = this.customization != null && !this.customization.isEmpty() ? this.getCustomization() : null;
        strategy.appendField(locator, (Object)this, "customization", buffer, theCustomization, this.customization != null && !this.customization.isEmpty());
        List<ActionDefinition> theAction = this.action != null && !this.action.isEmpty() ? this.getAction() : null;
        strategy.appendField(locator, (Object)this, "action", buffer, theAction, this.action != null && !this.action.isEmpty());
        return buffer;
    }

    public void setConcept(List<CodeableConcept> value) {
        this.concept = value;
    }

    public void setSupportingEvidence(List<Attachment> value) {
        this.supportingEvidence = value;
    }

    public void setDocumentation(List<Attachment> value) {
        this.documentation = value;
    }

    public void setParticipantType(List<ParticipantType> value) {
        this.participantType = value;
    }

    public void setBehavior(List<ActionDefinitionBehavior> value) {
        this.behavior = value;
    }

    public void setCustomization(List<ActionDefinitionCustomization> value) {
        this.customization = value;
    }

    public void setAction(List<ActionDefinition> value) {
        this.action = value;
    }
}

