/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;

public class ToBooleanEvaluator {
    public static Object toBoolean(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof Boolean) {
            return operand;
        }
        if (operand instanceof Integer) {
            if ((Integer)operand == 1) {
                return true;
            }
            if ((Integer)operand == 0) {
                return false;
            }
            return null;
        }
        if (operand instanceof BigDecimal) {
            if (((BigDecimal)operand).compareTo(new BigDecimal("0.0")) == 0) {
                return false;
            }
            if (((BigDecimal)operand).compareTo(new BigDecimal("1.0")) == 0) {
                return true;
            }
            return null;
        }
        if (operand instanceof String) {
            String compare = ((String)operand).toLowerCase();
            if (compare.equals("true") || compare.equals("t") || compare.equals("yes") || compare.equals("y") || compare.equals("1")) {
                return true;
            }
            if (compare.equals("false") || compare.equals("f") || compare.equals("no") || compare.equals("n") || compare.equals("0")) {
                return false;
            }
            return null;
        }
        throw new InvalidOperatorArgument("ToBoolean(String)", String.format("ToBoolean(%s)", operand.getClass().getName()));
    }
}

