/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.executing;

import java.math.BigDecimal;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.Value;

public class MultiplyEvaluator {
    public static Object multiply(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer) {
            return (Integer)left * (Integer)right;
        }
        if (left instanceof Long) {
            return (Long)left * (Long)right;
        }
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            return Value.verifyPrecision(((BigDecimal)left).multiply((BigDecimal)right), null);
        }
        if (left instanceof Quantity && right instanceof Quantity) {
            String unit = ((Quantity)left).getUnit().equals("1") ? ((Quantity)right).getUnit() : ((Quantity)left).getUnit();
            BigDecimal value = Value.verifyPrecision(((Quantity)left).getValue().multiply(((Quantity)right).getValue()), null);
            return new Quantity().withValue(value).withUnit(unit);
        }
        if (left instanceof BigDecimal && right instanceof Quantity) {
            BigDecimal value = Value.verifyPrecision(((BigDecimal)left).multiply(((Quantity)right).getValue()), null);
            return ((Quantity)right).withValue(value);
        }
        if (left instanceof Quantity && right instanceof BigDecimal) {
            BigDecimal value = Value.verifyPrecision(((Quantity)left).getValue().multiply((BigDecimal)right), null);
            return ((Quantity)left).withValue(value);
        }
        if (left instanceof Interval && right instanceof Interval) {
            Interval leftInterval = (Interval)left;
            Interval rightInterval = (Interval)right;
            return new Interval(MultiplyEvaluator.multiply(leftInterval.getStart(), rightInterval.getStart()), true, MultiplyEvaluator.multiply(leftInterval.getEnd(), rightInterval.getEnd()), true);
        }
        throw new InvalidOperatorArgument("Multiply(Integer, Integer), Multiply(Long, Long), Multiply(Decimal, Decimal), Multiply(Decimal, Quantity), Multiply(Quantity, Decimal) or Multiply(Quantity, Quantity)", String.format("Multiply(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }
}

